/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.module.translation;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.GSExtensionInfo;
import com.g4mesoft.GSExtensionUID;
import com.g4mesoft.GSIExtension;
import com.g4mesoft.GSIExtensionListener;
import com.g4mesoft.access.common.GSIServerPlayNetworkHandlerAccess;
import com.g4mesoft.core.GSCoreExtension;
import com.g4mesoft.core.GSIModule;
import com.g4mesoft.core.GSIModuleManager;
import com.g4mesoft.module.translation.GSTranslationCache;
import com.g4mesoft.module.translation.GSTranslationCacheList;
import com.g4mesoft.module.translation.GSTranslationCachePacket;
import com.g4mesoft.module.translation.GSTranslationVersionsPacket;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_3222;

public class GSTranslationModule
implements GSIModule,
GSIExtensionListener {
    private static final String CACHED_TRANSLATION_FILENAME = "en.lang";
    public static final int INVALID_TRANSLATION_VERSION = -1;
    private static final long MAX_CACHE_LIFE_HOURS = 72L;
    private final Map<String, String> translations = new ConcurrentHashMap<String, String>();
    private final Map<GSExtensionUID, GSTranslationCacheList> cacheLists = new HashMap<GSExtensionUID, GSTranslationCacheList>();
    private GSIModuleManager manager;
    private long cacheSaveTime;
    private long translationsChangeTimestamp = -1L;

    @Override
    public void init(GSIModuleManager manager) {
        this.manager = manager;
        manager.runOnClient(managerClient -> {
            try (FileInputStream is = new FileInputStream(this.getCachedFile(manager));){
                this.loadCachedTranslations(is);
            }
            catch (FileNotFoundException | SecurityException exception) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        G4mespeedMod.getExtensions().forEach(this::addExtensionTranslations);
        G4mespeedMod.addExtensionListener(this);
    }

    @Override
    public void onClose() {
        this.manager.runOnClient(managerClient -> {
            try {
                File file = this.getCachedFile(this.manager);
                if (!file.exists()) {
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.isDirectory()) {
                        parentFile.mkdirs();
                    }
                    file.createNewFile();
                }
                try (FileOutputStream os = new FileOutputStream(file);){
                    this.saveTranslations(os);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        G4mespeedMod.removeExtensionListener(this);
    }

    @Override
    public void extensionAdded(GSIExtension extension) {
        this.addExtensionTranslations(extension);
    }

    private void addExtensionTranslations(GSIExtension extension) {
        String path = extension.getTranslationPath();
        if (path == null || path.isEmpty()) {
            return;
        }
        URL url = GSTranslationModule.class.getResource(path);
        if (url != null) {
            try (InputStream is = url.openStream();){
                this.loadTranslations(is, extension.getInfo().getUniqueId(), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onJoinG4mespeedServer(GSExtensionInfo coreInfo) {
        this.manager.runOnClient(m -> m.sendPacket(new GSTranslationVersionsPacket(this.cacheLists)));
    }

    void onTranslationVersionsReceived(class_3222 player, Map<GSExtensionUID, Integer> uidToVersion) {
        for (GSExtensionUID uid : this.cacheLists.keySet()) {
            this.sendMissingTranslations(player, uid, uidToVersion.getOrDefault(uid, -1));
        }
    }

    private void sendMissingTranslations(class_3222 player, GSExtensionUID uid, int translationVersion) {
        if (((GSIServerPlayNetworkHandlerAccess)player.field_13987).gs_getTranslationVersion(uid) != -1) {
            return;
        }
        GSTranslationCacheList cacheList = this.cacheLists.get(uid);
        if (cacheList != null && translationVersion < cacheList.getVersion()) {
            this.manager.runOnServer(managerServer -> {
                PriorityQueue<GSTranslationCache> cachesToSend = new PriorityQueue<GSTranslationCache>((e1, e2) -> Integer.compare(e1.getCacheVersion(), e2.getCacheVersion()));
                for (GSTranslationCache cache : cacheList.getCaches().values()) {
                    if (cache.getCacheVersion() <= translationVersion) continue;
                    cachesToSend.add(cache);
                }
                for (GSTranslationCache cache : cachesToSend) {
                    managerServer.sendPacket(new GSTranslationCachePacket(uid, cache), player);
                }
            });
            ((GSIServerPlayNetworkHandlerAccess)player.field_13987).gs_setTranslationVersion(uid, cacheList.getVersion());
        }
    }

    private void loadCachedTranslations(InputStream is) throws IOException {
        this.cacheSaveTime = System.currentTimeMillis();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = reader.readLine();
            long cacheTime = -1L;
            if (line != null && line.length() > 2) {
                try {
                    cacheTime = Long.parseLong(line.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (cacheTime < 0L) {
                throw new IOException("Invalid cache date: " + line);
            }
            long cacheLifeDuration = System.currentTimeMillis() - cacheTime;
            if (cacheLifeDuration < 0L) {
                throw new IOException("Cache lifetime duration is negative! System time changed?");
            }
            if (TimeUnit.HOURS.convert(cacheLifeDuration, TimeUnit.MILLISECONDS) > 72L) {
                throw new IOException("Cache is too old. Discard it.");
            }
            this.loadTranslations(reader, GSCoreExtension.UID, true);
            this.cacheSaveTime = cacheTime;
        }
    }

    private void loadTranslations(InputStream is, GSExtensionUID extensionUid, boolean cachedTranslations) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            this.loadTranslations(reader, extensionUid, cachedTranslations);
        }
    }

    private void loadTranslations(BufferedReader reader, GSExtensionUID extensionUid, boolean cachedTranslations) throws IOException {
        String line;
        HashMap<String, String> translations = new HashMap<String, String>();
        int currentVersion = -1;
        block7: while ((line = reader.readLine()) != null) {
            String[] entry;
            if (line.isEmpty()) continue;
            switch (line.charAt(0)) {
                case '#': {
                    continue block7;
                }
                case '/': {
                    if (cachedTranslations && (extensionUid = GSExtensionUID.parseUID(line.substring(1))) == null) {
                        throw new IOException("Unable to read extension uid! (" + line + ")");
                    }
                }
                case ':': {
                    if (!translations.isEmpty()) {
                        this.addTranslationCache(extensionUid, new GSTranslationCache(currentVersion, translations));
                        translations.clear();
                    }
                    try {
                        currentVersion = Integer.parseInt(line.substring(1));
                        continue block7;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Unable to read translation version! (" + line + ")");
                    }
                }
            }
            if (currentVersion == -1 || (entry = line.split("=")).length != 2) continue;
            translations.put(entry[0], entry[1]);
        }
        if (!translations.isEmpty()) {
            this.addTranslationCache(extensionUid, new GSTranslationCache(currentVersion, translations));
        }
    }

    private void saveTranslations(OutputStream os) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));){
            writer.write("# ");
            writer.write(Long.toString(this.cacheSaveTime));
            writer.newLine();
            writer.write("# Cache saved at ");
            writer.write(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            writer.newLine();
            for (Map.Entry<GSExtensionUID, GSTranslationCacheList> entry : this.cacheLists.entrySet()) {
                writer.write(47);
                writer.write(GSExtensionUID.toString(entry.getKey()));
                writer.newLine();
                for (GSTranslationCache cache : entry.getValue().getCaches().values()) {
                    writer.write(58);
                    writer.write(Integer.toString(cache.getCacheVersion()));
                    writer.newLine();
                    for (Map.Entry<String, String> translation : cache.getTranslationMap().entrySet()) {
                        writer.write(translation.getKey());
                        writer.write(61);
                        writer.write(translation.getValue());
                        writer.newLine();
                    }
                }
            }
        }
    }

    private File getCachedFile(GSIModuleManager manager) {
        return new File(manager.getCacheFile(), CACHED_TRANSLATION_FILENAME);
    }

    void addTranslationCache(GSExtensionUID uid, GSTranslationCache cache) {
        cache.getAllTranslations(this.translations);
        this.translationsChangeTimestamp = System.currentTimeMillis();
        GSTranslationCacheList cacheList = this.cacheLists.get(uid);
        if (cacheList == null) {
            cacheList = new GSTranslationCacheList();
            this.cacheLists.put(uid, cacheList);
        }
        cacheList.addTranslationCache(cache);
    }

    public long getTranslationTimestamp() {
        return this.translationsChangeTimestamp;
    }

    public String getTranslation(String key) {
        String value = this.translations.get(key);
        return value == null ? key : value;
    }

    public String getFormattedTranslation(String key, Object ... args) {
        String value = this.translations.get(key);
        return value == null ? key : String.format(value, args);
    }

    public boolean hasTranslation(String key) {
        return this.translations.containsKey(key);
    }
}

