/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.module.tps;

import java.util.Arrays;
import net.minecraft.class_156;

public class GSTpsMonitor {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int DEFAULT_MAX_HISTORY_SIZE = 10;
    private final int[] tpsHistory;
    private int tpsHistorySize;
    private int tpsHistoryPosition;
    private long tpsAccumulator;
    private long lastUpdateTime;
    private int ticks;
    private volatile float averageTps;

    public GSTpsMonitor() {
        this(10);
    }

    public GSTpsMonitor(int maxHistorySize) {
        this.tpsHistory = new int[maxHistorySize];
        this.reset();
    }

    public synchronized void reset() {
        Arrays.fill(this.tpsHistory, 0);
        this.tpsHistorySize = 0;
        this.tpsHistoryPosition = 0;
        this.tpsAccumulator = 0L;
        this.lastUpdateTime = class_156.method_658();
        this.ticks = 0;
    }

    public synchronized void update(int ticksPassed) {
        this.ticks += ticksPassed;
        long millisPassed = class_156.method_658() - this.lastUpdateTime;
        long secondsPassed = millisPassed / 1000L;
        if (secondsPassed > 0L) {
            long millisThisUpdate = secondsPassed * 1000L;
            int ticksThisUpdate = (int)((long)this.ticks * millisThisUpdate / millisPassed);
            if (ticksThisUpdate < 0) {
                ticksThisUpdate = this.ticks;
            }
            this.lastUpdateTime += millisThisUpdate;
            this.ticks -= ticksThisUpdate;
            if (secondsPassed > (long)this.tpsHistory.length) {
                long oldSeconds = secondsPassed - (long)this.tpsHistory.length;
                int oldTicks = (int)((long)ticksThisUpdate * oldSeconds / secondsPassed);
                if (oldTicks > 0) {
                    ticksThisUpdate -= oldTicks;
                }
                secondsPassed = this.tpsHistory.length;
            }
            for (int secondsToProcess = (int)secondsPassed; secondsToProcess > 0; --secondsToProcess) {
                int ticksThisSecond = ticksThisUpdate / secondsToProcess;
                this.addToHistory(ticksThisSecond);
                ticksThisUpdate -= ticksThisSecond;
            }
            this.averageTps = (float)((double)this.tpsAccumulator / (double)this.tpsHistorySize);
        }
    }

    private void addToHistory(int tps) {
        this.tpsAccumulator -= (long)this.tpsHistory[this.tpsHistoryPosition];
        this.tpsHistory[this.tpsHistoryPosition] = tps;
        this.tpsAccumulator += (long)tps;
        if (++this.tpsHistoryPosition >= this.tpsHistory.length) {
            this.tpsHistoryPosition = 0;
        }
        if (this.tpsHistorySize < this.tpsHistory.length) {
            ++this.tpsHistorySize;
        }
    }

    public float getAverageTps() {
        return this.averageTps;
    }
}

