/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.module.tps;

import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.module.tps.GSTpsModule;
import com.g4mesoft.ui.util.GSMathUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class GSTpsCommand {
    private static final double LOG_2 = Math.log(2.0);

    private GSTpsCommand() {
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"tps").requires(context -> context.method_9259(2));
        builder.executes(context -> GSTpsCommand.informCurrentTps((class_2168)context.getSource()));
        builder.then(class_2170.method_9244((String)"newTps", (ArgumentType)FloatArgumentType.floatArg((float)0.01f, (float)Float.MAX_VALUE)).executes(context -> GSTpsCommand.setCurrentTps((class_2168)context.getSource(), FloatArgumentType.getFloat((CommandContext)context, (String)"newTps"))));
        dispatcher.register(builder);
    }

    private static int informCurrentTps(class_2168 source) {
        float tps = GSServerController.getInstance().getTpsModule().getTps();
        String tpsFormatted = GSTpsModule.TPS_FORMAT.format(tps);
        float fn = (float)(Math.log(tps / 20.0f) / LOG_2 * 12.0);
        int n = Math.round(fn);
        if (n % 12 != 0 && GSMathUtil.equalsApproximate((float)fn, (float)n, (float)1.0E-4f)) {
            int o = n / 12;
            if ((n %= 12) < 0) {
                --o;
                n += 12;
            }
            class_5250 feedback = o != 0 ? class_2561.method_43469((String)"command.tps.geton", (Object[])new Object[]{tpsFormatted, GSTpsCommand.formatSign(o), GSTpsCommand.formatSign(n)}) : class_2561.method_43469((String)"command.tps.getn", (Object[])new Object[]{tpsFormatted, GSTpsCommand.formatSign(n)});
            source.method_9226(() -> GSTpsCommand.lambda$informCurrentTps$3((class_2561)feedback), false);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"command.tps.get", (Object[])new Object[]{tpsFormatted}), false);
        }
        return 1;
    }

    private static String formatSign(int value) {
        if (value > 0) {
            return "+" + Integer.toString(value);
        }
        return Integer.toString(value);
    }

    private static int setCurrentTps(class_2168 source, float newTps) throws CommandSyntaxException {
        GSServerController.getInstance().getTpsModule().setTps(newTps);
        source.method_9226(() -> class_2561.method_43469((String)"command.tps.set", (Object[])new Object[]{Float.valueOf(newTps)}), true);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$informCurrentTps$3(class_2561 feedback) {
        return feedback;
    }
}

