/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.mixin.client;

import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.module.tps.GSITpsDependant;
import com.g4mesoft.module.tps.GSTpsModule;
import com.g4mesoft.setting.GSISettingChangeListener;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import java.util.Map;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_4235;
import net.minecraft.class_5912;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1140.class})
public abstract class GSSoundSystemMixin
implements GSITpsDependant,
GSISettingChangeListener {
    @Shadow
    @Final
    private Map<class_1113, class_4235.class_4236> field_18950;
    @Unique
    private GSTpsModule gs_tpsModule;

    @Shadow
    protected abstract float method_4849(class_1113 var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(class_1144 loader, class_315 settings, class_5912 resourceFactory, CallbackInfo ci) {
        GSClientController client = GSClientController.getInstance();
        this.gs_tpsModule = client.getTpsModule();
        this.gs_tpsModule.addTpsListener(this);
        client.getSettingManager().addChangeListener(this);
    }

    @Inject(method={"getAdjustedPitch"}, cancellable=true, at={@At(value="HEAD")})
    private void onGetAdjustedPitch(class_1113 soundInstance, CallbackInfoReturnable<Float> cir) {
        float pitch = class_3532.method_15363((float)soundInstance.method_4782(), (float)0.5f, (float)2.0f);
        if (this.gs_tpsModule.cShiftPitch.get().booleanValue()) {
            pitch *= this.gs_tpsModule.getTps() / 20.0f;
        }
        cir.setReturnValue((Object)Float.valueOf(pitch));
        cir.cancel();
    }

    @Unique
    private void updatePitch() {
        for (Map.Entry<class_1113, class_4235.class_4236> soundEntry : this.field_18950.entrySet()) {
            float pitch = this.method_4849(soundEntry.getKey());
            soundEntry.getValue().method_19735(s -> s.method_19639(pitch));
        }
    }

    @Override
    public void tpsChanged(float newTps, float oldTps) {
        this.updatePitch();
    }

    @Override
    public void onSettingChanged(GSSettingCategory category, GSSetting<?> setting) {
        if (setting == this.gs_tpsModule.cShiftPitch) {
            this.updatePitch();
        }
    }
}

