/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.mixin.client;

import com.g4mesoft.access.client.GSIRenderTickCounterDynamicAccess;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.module.tps.GSITickTimer;
import com.g4mesoft.module.tps.GSServerTickTimer;
import com.g4mesoft.module.tps.GSTpsModule;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_9779.class_9781.class})
public class GSRenderTickCounterDynamicMixin
implements GSIRenderTickCounterDynamicAccess,
GSITickTimer {
    @Shadow
    public float field_51959;
    @Shadow
    public float field_51958;
    @Shadow
    public long field_51962;
    @Shadow
    @Final
    private float field_51964;
    @Shadow
    private float field_51960;
    @Shadow
    private float field_51961;
    @Shadow
    private long field_51963;
    @Unique
    private int gs_ticksThisFrame;
    @Unique
    private boolean gs_firstUpdate;
    @Unique
    private GSTpsModule gs_tpsModule;
    @Unique
    private GSServerTickTimer gs_serverTimer;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(float ticksPerSecond, long initialTimeMillis, FloatUnaryOperator targetMillisPerTick, CallbackInfo ci) {
        this.gs_firstUpdate = true;
    }

    @Inject(method={"beginRenderTick(J)I"}, at={@At(value="FIELD", shift=At.Shift.AFTER, opcode=181, target="Lnet/minecraft/client/render/RenderTickCounter$Dynamic;lastFrameDuration:F")})
    private void onModifyTickrate(long timeMillis, CallbackInfoReturnable<Integer> cir) {
        if (this.gs_firstUpdate) {
            this.init0(this.field_51962);
            this.gs_firstUpdate = false;
        }
        float millisPerTick = this.getMillisPerTick0();
        if (GSClientController.getInstance().isG4mespeedServer()) {
            this.gs_serverTimer.setMillisPerTick(millisPerTick);
        } else {
            this.gs_serverTimer.setMillisPerTick(50.0f);
        }
        this.field_51958 = (float)(timeMillis - this.field_51962) / millisPerTick;
    }

    @Inject(method={"beginRenderTick(J)I"}, at={@At(value="FIELD", shift=At.Shift.BEFORE, opcode=180, target="Lnet/minecraft/client/render/RenderTickCounter$Dynamic;tickDelta:F")})
    private void onGetTicksThisFrame(long currentTimeMillis, CallbackInfoReturnable<Integer> cir) {
        this.gs_ticksThisFrame = (int)this.field_51959;
    }

    @Inject(method={"beginRenderTick(J)I"}, cancellable=true, at={@At(value="RETURN")})
    private void onBeginRenderTick(long timeMillis, CallbackInfoReturnable<Integer> cir) {
        this.update0(timeMillis);
        cir.setReturnValue((Object)this.gs_ticksThisFrame);
        cir.cancel();
    }

    @Override
    public void gs_setFromTimer(GSITickTimer timer) {
        this.field_51959 = timer.getTickDelta0();
        this.field_51961 = timer.getTickDelta0();
        this.field_51960 = timer.getLastDuration0() * timer.getMillisPerTick0() / this.field_51964;
        this.field_51958 = timer.getLastDuration0();
        this.field_51963 = this.field_51962 = timer.getPrevTimeMillis0();
    }

    @Override
    public void init0(long initialTimeMillis) {
        this.gs_tpsModule = GSClientController.getInstance().getTpsModule();
        this.gs_serverTimer = this.gs_tpsModule.getServerTimer();
        this.gs_serverTimer.init0(initialTimeMillis);
    }

    @Override
    public void update0(long timeMillis) {
        this.gs_serverTimer.update0(timeMillis);
        this.gs_serverTimer.syncTimer(this);
    }

    @Override
    public float getMillisPerTick0() {
        return this.gs_tpsModule.getMsPerTick() * this.field_51964 / 50.0f;
    }

    @Override
    public float getTickDelta0() {
        return this.field_51959;
    }

    @Override
    public void setTickDelta0(float tickDelta) {
        this.field_51959 = tickDelta;
    }

    @Override
    public int getTickCount0() {
        return this.gs_ticksThisFrame;
    }

    @Override
    public void setTickCount0(int tickCount) {
        this.gs_ticksThisFrame = tickCount;
    }

    @Override
    public float getLastDuration0() {
        return this.field_51958;
    }

    @Override
    public long getPrevTimeMillis0() {
        return this.field_51962;
    }
}

