/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.mixin.client;

import com.g4mesoft.access.client.GSIEntityAccess;
import com.g4mesoft.access.client.GSIMinecraftClientAccess;
import com.g4mesoft.access.client.GSIPistonBlockEntityAccess;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.module.tps.GSTpsModule;
import com.g4mesoft.ui.util.GSMathUtil;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_4623;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2669.class})
public abstract class GSPistonBlockEntityMixin
extends class_2586
implements GSIPistonBlockEntityAccess {
    @Shadow
    private class_2350 field_12201;
    @Shadow
    private float field_12207;
    @Shadow
    private float field_12206;
    @Shadow
    private class_2680 field_12204;
    @Shadow
    private int field_26705;
    private float gs_actualLastProgress;
    @Unique
    private float gs_nextProgress = 0.0f;
    @Unique
    private boolean gs_wasAdded = false;
    private float gs_numberOfSteps = 2.0f;

    @Shadow
    public abstract float method_11499(float var1);

    @Shadow
    private static void method_11503(class_1937 world, class_2338 pos, float nextProgress, class_2669 blockEntity) {
    }

    @Shadow
    private static void method_23674(class_1937 world, class_2338 pos, float nextProgress, class_2669 blockEntity) {
    }

    @Shadow
    protected abstract class_2680 method_11496();

    @Shadow
    private static class_238 method_11500(class_2338 pos, class_238 box, class_2669 blockEntity) {
        return null;
    }

    @Shadow
    public abstract class_2350 method_11506();

    public GSPistonBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"getProgress"}, cancellable=true, at={@At(value="HEAD")})
    private void onGetProgressHead(float tickDelta, CallbackInfoReturnable<Float> cir) {
        if (this.field_11863.field_9236) {
            cir.setReturnValue((Object)Float.valueOf(this.gs_getOffsetForProgress(this.field_12207, this.gs_actualLastProgress, tickDelta)));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float gs_getOffsetForProgress(float progress, float lastProgress, float tickDelta) {
        if ((this.method_11015() || this.field_26705 != 0) && GSMathUtil.equalsApproximate((float)lastProgress, (float)1.0f)) {
            return 1.0f;
        }
        GSTpsModule tpsModule = GSClientController.getInstance().getTpsModule();
        return Math.min(1.0f, switch (tpsModule.cPistonAnimationType.get()) {
            default -> (progress * this.gs_numberOfSteps + tickDelta) / this.gs_numberOfSteps;
            case 1 -> {
                if (progress < 0.49999f) {
                    yield (progress * this.gs_numberOfSteps + tickDelta) / this.gs_numberOfSteps;
                }
                if (progress > 0.50001f) {
                    yield (progress * this.gs_numberOfSteps - 1.0f + tickDelta) / this.gs_numberOfSteps;
                }
                yield 0.5f;
            }
            case 2 -> lastProgress + (progress - lastProgress) * tickDelta;
            case 3 -> (progress * this.gs_numberOfSteps + tickDelta) / (this.gs_numberOfSteps + 1.0f);
        });
    }

    @Inject(method={"pushEntities", "moveEntitiesInHoneyBlock"}, at={@At(value="HEAD")})
    private static void onMoveEntitiesHead(class_1937 world, class_2338 pos, float nextProgress, class_2669 blockEntity, CallbackInfo ci) {
        ((GSIPistonBlockEntityAccess)blockEntity).gs_setNextProgress(nextProgress);
    }

    @ModifyVariable(method={"pushEntities"}, argsOnly=false, ordinal=0, at=@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/block/entity/PistonBlockEntity;getHeadBlockState()Lnet/minecraft/block/BlockState;"))
    private static double onPushEntitiesModifyDeltaProgress(double oldDeltaProgress, class_1937 world, class_2338 pos, float nextProgress, class_2669 blockEntity) {
        return GSPistonBlockEntityMixin.getDeltaProgress(oldDeltaProgress, blockEntity);
    }

    @Inject(method={"pushEntities"}, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/Entity;setVelocity(DDD)V")})
    private static void onPushEntitiesAfterEntitySetVelocity(class_1937 world, class_2338 pos, float nextProgress, class_2669 blockEntity, CallbackInfo ci, class_2350 direction, double d, class_265 voxelShape, class_238 box, List<?> list, List<?> list2, boolean bl, Iterator<?> var12, class_1297 entity) {
        ((GSIEntityAccess)entity).gs_setMovedByPiston(true);
    }

    @ModifyVariable(method={"moveEntitiesInHoneyBlock"}, argsOnly=false, ordinal=1, at=@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/World;getOtherEntities(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Box;Ljava/util/function/Predicate;)Ljava/util/List;"))
    private static double onMethod_23674ModifyDeltaProgress(double oldDeltaProgress, class_1937 world, class_2338 pos, float nextProgress, class_2669 blockEntity) {
        return GSPistonBlockEntityMixin.getDeltaProgress(oldDeltaProgress, blockEntity);
    }

    private static double getDeltaProgress(double oldDeltaProgress, class_2669 blockEntity) {
        if (GSPistonBlockEntityMixin.shouldCorrectPushEntities(blockEntity)) {
            float nextProgress = ((GSIPistonBlockEntityAccess)blockEntity).gs_getNextProgress();
            float progress = ((GSIPistonBlockEntityAccess)blockEntity).gs_getProgress();
            return ((GSIPistonBlockEntityAccess)blockEntity).gs_getOffsetForProgress(nextProgress, progress, 1.0f) - ((GSIPistonBlockEntityAccess)blockEntity).gs_getOffsetForProgress(nextProgress, progress, 0.0f);
        }
        return oldDeltaProgress;
    }

    @Redirect(method={"offsetHeadBox"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/block/entity/PistonBlockEntity;progress:F"))
    private static float onOffsetBoxRedirectProgress(class_2669 blockEntity) {
        if (GSPistonBlockEntityMixin.shouldCorrectPushEntities(blockEntity)) {
            float progress = ((GSIPistonBlockEntityAccess)blockEntity).gs_getProgress();
            float nextProgress = ((GSIPistonBlockEntityAccess)blockEntity).gs_getNextProgress();
            return ((GSIPistonBlockEntityAccess)blockEntity).gs_getOffsetForProgress(nextProgress, progress, 0.0f);
        }
        return ((GSIPistonBlockEntityAccess)blockEntity).gs_getProgress();
    }

    @Redirect(method={"getHeadBlockState", "getCollisionShape"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/block/entity/PistonBlockEntity;progress:F"))
    private float onGetCollisionShapeRedirectProgress(class_2669 blockEntity) {
        if (GSPistonBlockEntityMixin.shouldCorrectPushEntities(blockEntity)) {
            return this.method_11499(1.0f);
        }
        return this.field_12207;
    }

    @Override
    public void gs_onAdded() {
        if (!this.gs_wasAdded) {
            if (this.field_11863.field_9236 && GSPistonBlockEntityMixin.isPushCorrectionEnabled((class_2669)this)) {
                GSClientController controller = GSClientController.getInstance();
                ((GSIMinecraftClientAccess)controller.getClient()).gs_schedulePistonBlockEntityUpdate(this.field_11867);
            }
            this.gs_wasAdded = true;
        }
    }

    @Override
    public void gs_handleScheduledUpdate() {
        if (GSPistonBlockEntityMixin.isPushCorrectionEnabled((class_2669)this)) {
            double deltaProgress = GSPistonBlockEntityMixin.getDeltaProgress(0.0, (class_2669)this);
            if (GSMathUtil.equalsApproximate((double)deltaProgress, (double)0.0)) {
                this.markEntitiesMovedByPiston(Math.min(1.0f / this.gs_numberOfSteps, 1.0f));
            } else {
                GSPistonBlockEntityMixin.method_11503(this.field_11863, this.field_11867, 0.0f, (class_2669)this);
                GSPistonBlockEntityMixin.method_23674(this.field_11863, this.field_11867, 0.0f, (class_2669)this);
            }
        }
    }

    @Unique
    private void markEntitiesMovedByPiston(float stretchAmount) {
        class_2350 direction;
        class_238 box;
        List entities;
        class_265 voxelShape = this.method_11496().method_26220((class_1922)this.field_11863, this.method_11016());
        if (!voxelShape.method_1110() && !(entities = this.field_11863.method_8335((class_1297)null, class_4623.method_23362((class_238)(box = GSPistonBlockEntityMixin.method_11500(this.field_11867, voxelShape.method_1107(), (class_2669)this)), (class_2350)(direction = this.method_11506()), (double)stretchAmount).method_991(box))).isEmpty()) {
            for (class_1297 entity : entities) {
                if (entity.method_5657() == class_3619.field_15975 || entity instanceof class_3222) continue;
                ((GSIEntityAccess)entity).gs_setMovedByPiston(true);
            }
        }
    }

    @Unique
    private static boolean shouldCorrectPushEntities(class_2669 blockEntity) {
        return GSPistonBlockEntityMixin.isPushCorrectionEnabled(blockEntity) && !blockEntity.method_11495().method_27852(class_2246.field_10030);
    }

    @Unique
    private static boolean isPushCorrectionEnabled(class_2669 blockEntity) {
        class_1937 world = blockEntity.method_10997();
        if (world == null || !world.field_9236) {
            return false;
        }
        return GSClientController.getInstance().getTpsModule().cCorrectPistonPushing.get();
    }

    @Inject(method={"readNbt"}, at={@At(value="RETURN")})
    private void onReadNbt(class_2487 tag, class_7225.class_7874 registryLookup, CallbackInfo ci) {
        this.gs_actualLastProgress = Math.max(0.0f, this.field_12206 - 1.0f / this.gs_numberOfSteps);
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", shift=At.Shift.AFTER, opcode=181, target="Lnet/minecraft/block/entity/PistonBlockEntity;lastProgress:F")})
    private static void onTickProgressChanged(class_1937 world, class_2338 pos, class_2680 state, class_2669 blockEntity, CallbackInfo ci) {
        ((GSPistonBlockEntityMixin)blockEntity).gs_actualLastProgress = ((GSPistonBlockEntityMixin)blockEntity).field_12206;
    }

    @Inject(method={"finish"}, at={@At(value="FIELD", shift=At.Shift.AFTER, opcode=181, target="Lnet/minecraft/block/entity/PistonBlockEntity;lastProgress:F")})
    private void onFinishProgressChanged(CallbackInfo ci) {
        this.gs_actualLastProgress = this.field_12206;
    }

    @Override
    public float gs_getProgress() {
        return this.field_12207;
    }

    @Override
    public float gs_getNextProgress() {
        return this.gs_nextProgress;
    }

    @Override
    public void gs_setNextProgress(float nextProgress) {
        this.gs_nextProgress = nextProgress;
    }
}

