/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.mixin.client;

import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.module.tps.GSTpsModule;
import com.g4mesoft.module.translation.GSTranslationModule;
import com.g4mesoft.ui.util.GSMathUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_340;
import net.minecraft.class_4587;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class GSInGameHudMixin {
    private static final int TPS_LABEL_MAGIN = 5;
    private static final float RED_START = 1.0f;
    private static final float RED_END = 0.75f;
    private static final float GREEN_START = 0.5f;
    private static final float GREEN_END = 0.75f;
    private static final float BLUE_START = 1.0f;
    private static final float BLUE_END = 1.5f;
    private static final int LABEL_COLOR_MIN = 64;
    private static final int LABEL_COLOR_MAX = 218;
    private static final int LABEL_COLOR_DIFF = 154;
    private static final int LABEL_BACKGROUND_COLOR = 0x60333333;
    private static final int LABEL_TARGET_COLOR = -1118482;
    @Unique
    private static final DecimalFormat LOW_PRECISION_TPS_FORMAT = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
    @Shadow
    @Final
    private class_340 field_2026;
    @Shadow
    @Final
    private class_310 field_2035;

    @Shadow
    public abstract class_327 method_1756();

    @Inject(method={"method_55808"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/client/gui/hud/BossBarHud;render(Lnet/minecraft/client/gui/DrawContext;)V")})
    private void onRenderBeforeBossBar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (GSClientController.getInstance().getTpsModule().cTpsLabel.get() == 2) {
            class_4587 matrixStack = context.method_51448();
            matrixStack.method_22903();
            Objects.requireNonNull(this.field_2035.field_1772);
            matrixStack.method_22904(0.0, (double)(9 + 5), 0.0);
        }
    }

    @Inject(method={"method_55808"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/gui/hud/BossBarHud;render(Lnet/minecraft/client/gui/DrawContext;)V")})
    private void onRenderAfterBossBar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (GSClientController.getInstance().getTpsModule().cTpsLabel.get() == 2) {
            context.method_51448().method_22909();
        }
    }

    @Inject(method={"method_55806"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/client/gui/hud/SubtitlesHud;render(Lnet/minecraft/client/gui/DrawContext;)V")})
    private void onRenderBeforeSubtitles(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        GSClientController controller = GSClientController.getInstance();
        GSTpsModule tpsModule = controller.getTpsModule();
        int labelLocation = tpsModule.cTpsLabel.get();
        if (!this.field_2026.method_53536() && labelLocation != 0) {
            class_327 font = this.method_1756();
            GSTranslationModule translationModule = controller.getTranslationModule();
            float averageTps = tpsModule.getServerTps();
            float targetTps = tpsModule.getTps();
            String current = LOW_PRECISION_TPS_FORMAT.format(averageTps);
            String target = GSTpsModule.TPS_FORMAT.format(targetTps);
            String targetText = translationModule.getFormattedTranslation("play.info.tpsLabelTarget", target);
            int ly = 5;
            int lw = font.method_1727(current + " " + targetText);
            Objects.requireNonNull(font);
            int lh = 9;
            int lx = switch (labelLocation) {
                case 2 -> (context.method_51421() - lw) / 2;
                case 3 -> context.method_51421() - lw - 5 + 1;
                default -> 5;
            };
            context.method_25294(lx - 1, ly - 1, lx + lw, ly + lh, 0x60333333);
            int tx = context.method_51433(font, current, lx, ly, GSInGameHudMixin.getTpsLabelColor(averageTps, targetTps), false);
            context.method_51433(font, targetText, tx + font.method_1727(" "), ly, -1118482, false);
        }
    }

    @Unique
    private static int getTpsLabelColor(float averageTps, float targetTps) {
        float frac = Math.max(averageTps / targetTps, 0.0f);
        float rs = Math.max(0.0f, (frac - 1.0f) / -0.25f);
        float gs = Math.max(0.0f, (frac - 0.5f) / 0.25f);
        float bs = Math.max(0.0f, (frac - 1.0f) / 0.5f);
        int r = GSMathUtil.clamp((int)((int)(rs * 154.0f) + 64), (int)0, (int)255);
        int g = GSMathUtil.clamp((int)((int)(gs * 154.0f) + 64), (int)0, (int)255);
        int b = GSMathUtil.clamp((int)((int)(bs * 154.0f) + 64), (int)0, (int)255);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

