/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui.setting;

import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.legacy.GSButtonPanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import net.minecraft.class_2561;

public abstract class GSSettingPanel<T extends GSSetting<?>>
extends GSParentPanel {
    public static final int HOVERED_BACKGROUND = Integer.MIN_VALUE;
    protected static final int CONTENT_PADDING = 2;
    protected static final int CONTENT_MARGIN = 2;
    protected static final int RESET_BUTTON_WIDTH = 48;
    protected static final int RESET_BUTTON_HEIGHT = 20;
    protected static final class_2561 RESET_TEXT = class_2561.method_43471((String)"setting.button.reset");
    private static final int ENABLED_TEXT_COLOR = -1;
    private static final int DISABLED_TEXT_COLOR = -5592406;
    protected final GSSettingCategory category;
    protected final T setting;
    protected final String nameTextKey;
    protected final class_2561 nameText;
    private final GSButtonPanel resetButton;

    public GSSettingPanel(GSSettingCategory category, T setting) {
        this.category = category;
        this.setting = setting;
        this.nameTextKey = "setting." + category.getName() + "." + ((GSSetting)setting).getName();
        this.nameText = class_2561.method_43471((String)this.nameTextKey);
        this.resetButton = new GSButtonPanel(RESET_TEXT, this::resetSetting);
        this.add((GSPanel)this.resetButton);
    }

    public void setPreferredBounds(int x, int y, int width) {
        this.setBounds(x, y, width, this.getPreferredHeight());
    }

    public void render(GSIRenderer2D renderer) {
        if (renderer.isMouseInside(0, 0, this.width, this.height)) {
            renderer.fillRect(0, 0, this.width, this.height, Integer.MIN_VALUE);
        }
        super.render(renderer);
    }

    public int getTextColor() {
        return this.isSettingEnabled() ? -1 : -5592406;
    }

    public void layout() {
        int x = this.width - 2 - 48;
        int y = (this.getSettingHeight() - 20) / 2;
        this.resetButton.setBounds(x, y, 48, 20);
        this.updateResetActive();
    }

    protected void resetSetting() {
        if (this.isSettingEnabled()) {
            ((GSSetting)this.setting).reset();
        }
    }

    public void onSettingChanged() {
        this.updateResetActive();
    }

    private void updateResetActive() {
        this.resetButton.setEnabled(!((GSSetting)this.setting).isDefault() && this.isSettingEnabled());
    }

    public abstract class_2561 getFormattedDefault();

    protected boolean isSettingEnabled() {
        return ((GSSetting)this.setting).isEnabledInGui() && ((GSSetting)this.setting).isAllowedChange();
    }

    protected int getSettingHeight() {
        return this.height;
    }

    public int getPreferredWidth() {
        return 52;
    }

    public int getPreferredHeight() {
        return 24;
    }

    public String getNameTextKey() {
        return this.nameTextKey;
    }

    public GSSetting<?> getSetting() {
        return this.setting;
    }
}

