/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui.setting;

import com.g4mesoft.gui.setting.GSAbstractNumberSettingPanel;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.types.GSFloatSetting;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class GSFloatSettingPanel
extends GSAbstractNumberSettingPanel<GSFloatSetting> {
    private static final float MAX_DEF_INTERVAL_FOR_SLIDER = 100.0f;
    private static final DecimalFormat FORMATTER = new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.ENGLISH));

    public GSFloatSettingPanel(GSSettingCategory category, GSFloatSetting setting) {
        super(category, setting);
    }

    @Override
    protected void setValueFromSlider(float value) {
        ((GSFloatSetting)this.setting).set(value * (((GSFloatSetting)this.setting).getMax() - ((GSFloatSetting)this.setting).getMin()) + ((GSFloatSetting)this.setting).getMin());
    }

    @Override
    protected boolean setValueFromTextField(String str) {
        try {
            ((GSFloatSetting)this.setting).set(Float.parseFloat(str));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean shouldUseSlider() {
        return ((GSFloatSetting)this.setting).getMax() - ((GSFloatSetting)this.setting).getMin() < 100.0f;
    }

    @Override
    protected void updateFieldValue() {
        if (this.shouldUseSlider()) {
            this.setSliderValue((((GSFloatSetting)this.setting).get().floatValue() - ((GSFloatSetting)this.setting).getMin()) / (((GSFloatSetting)this.setting).getMax() - ((GSFloatSetting)this.setting).getMin()));
            this.setSliderText((class_2561)class_2561.method_43470((String)FORMATTER.format(((GSFloatSetting)this.setting).get().doubleValue())));
        } else {
            this.setTextFieldValue(String.format(Locale.ENGLISH, "%.3f", ((GSFloatSetting)this.setting).get()));
        }
    }

    @Override
    public class_2561 getFormattedDefault() {
        return class_2561.method_43470((String)FORMATTER.format(((Float)((GSFloatSetting)this.setting).getDefault()).doubleValue())).method_27692(class_124.field_1075);
    }
}

