/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui;

import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelContext;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5481;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class GSTabbedGUI
extends GSParentPanel
implements GSIMouseListener {
    private static final int TAB_VERTICAL_PADDING = 5;
    private static final int TAB_HORIZONTAL_PADDING = 5;
    private static final int HORIZONTAL_MARGIN = 5;
    private static final int VERTICAL_MARGIN = 5;
    private static final int MINIMUM_TAB_WIDTH = 60;
    private static final int TAB_TEXT_COLOR = -2171170;
    private static final int TAB_BORDER_COLOR = -2236963;
    private static final int SELECTED_TEXT_COLOR = -1;
    private static final int SELECTED_BACKGROUND_COLOR = -1431655766;
    private static final int HOVERED_BACKGROUND_COLOR = -1427247617;
    private final boolean showBackground;
    private int tabHeight;
    private List<GSTabEntry> tabs;
    private int selectedTabIndex;

    public GSTabbedGUI() {
        this(true);
    }

    public GSTabbedGUI(boolean showBackground) {
        this.showBackground = showBackground;
        this.tabs = new ArrayList<GSTabEntry>();
        this.selectedTabIndex = -1;
        this.addMouseEventListener(this);
    }

    public void addTab(String titleKey, GSPanel tabContent) {
        this.tabs.add(new GSTabEntry((class_2561)class_2561.method_43471((String)titleKey), tabContent));
        if (this.selectedTabIndex == -1) {
            this.setSelectedTabIndex(0);
        }
        this.invalidate();
    }

    public void setSelectedTabIndex(int index) {
        if (index != -1 && (index < 0 || index >= this.tabs.size())) {
            throw new IllegalArgumentException("Invalid tab index: " + index);
        }
        if (this.selectedTabIndex != -1) {
            this.remove(this.getTabContent(this.selectedTabIndex));
        }
        this.selectedTabIndex = index;
        if (index != -1) {
            this.add(this.getTabContent(index));
        }
    }

    public GSPanel getTabContent(int index) {
        return index != -1 ? this.tabs.get(index).getTabContent() : null;
    }

    public GSPanel getSelectedTabContent() {
        return this.getTabContent(this.selectedTabIndex);
    }

    public void layout() {
        GSTabEntry tab;
        int tabWidth;
        GSIRenderer2D renderer = GSPanelContext.getRenderer();
        this.tabHeight = renderer.getTextHeight() + 10;
        for (GSTabEntry tab2 : this.tabs) {
            class_2561 title = tab2.getTitle();
            int titleWidth = (int)Math.ceil(renderer.getTextWidth(title));
            tab2.setWidth(titleWidth + 10);
        }
        int contentWidth = Math.max(this.width - 10, this.tabs.size());
        int contentHeight = Math.max(this.height - this.tabHeight - 5, 1);
        int remainingTabs = this.tabs.size();
        int remainingWidth = contentWidth;
        GSTabEntry[] sortedTabs = this.tabs.toArray(new GSTabEntry[0]);
        Arrays.sort(sortedTabs, (a, b) -> Integer.compare(a.getWidth(), b.getWidth()));
        int minimumTabWidth = 60;
        GSTabEntry widestTab = sortedTabs[remainingTabs - 1];
        if (widestTab.getWidth() * remainingTabs <= remainingWidth) {
            minimumTabWidth = widestTab.getWidth();
        }
        for (int i = 0; i < sortedTabs.length && (tabWidth = Math.max(minimumTabWidth, (tab = sortedTabs[remainingTabs - 1]).getWidth())) * remainingTabs <= remainingWidth; ++i) {
            tab.setWidth(tabWidth);
            remainingWidth -= tabWidth;
            --remainingTabs;
        }
        while (remainingTabs > 0) {
            GSTabEntry tab3 = sortedTabs[remainingTabs - 1];
            tab3.setWidth(remainingWidth / remainingTabs);
            remainingWidth -= tab3.getWidth();
            --remainingTabs;
        }
        for (GSTabEntry tab4 : sortedTabs) {
            tab4.setDisplayTitle(renderer.trimString(tab4.getTitle(), tab4.getWidth()));
        }
        int tabOffsetX = 5;
        for (GSTabEntry tab5 : this.tabs) {
            GSPanel content = tab5.getTabContent();
            if (content != null) {
                int xo = 5;
                int yo = 5 + this.tabHeight;
                content.setBounds(xo, yo, contentWidth, contentHeight);
            }
            tab5.setX(tabOffsetX);
            tabOffsetX += tab5.getWidth();
        }
    }

    public void render(GSIRenderer2D renderer) {
        if (this.showBackground) {
            this.renderBackground(renderer);
        }
        super.render(renderer);
        this.renderTabs(renderer);
    }

    private boolean isInWorld() {
        class_310 client = class_310.method_1551();
        return client.field_1687 != null;
    }

    protected void renderBackground(GSIRenderer2D renderer) {
        renderer.drawMenuBackground(0, 0, this.width, this.height, this.isInWorld());
    }

    private void renderTabs(GSIRenderer2D renderer) {
        int totalTabWidth = 0;
        for (int i = 0; i < this.tabs.size(); ++i) {
            GSTabEntry tab = this.tabs.get(i);
            boolean selected = i == this.selectedTabIndex;
            this.renderTab(renderer, tab, i, selected);
            totalTabWidth += tab.getWidth();
        }
        renderer.drawRect(5, 5, totalTabWidth, this.tabHeight, -2236963);
    }

    private void renderTab(GSIRenderer2D renderer, GSTabEntry tab, int tabIndex, boolean selected) {
        if (tab.isHovered(renderer.getMouseX(), renderer.getMouseY())) {
            renderer.fillRect(tab.getX(), 5, tab.getWidth(), this.tabHeight, -1427247617);
        } else if (selected) {
            renderer.fillRect(tab.getX(), 5, tab.getWidth(), this.tabHeight, -1431655766);
        }
        int xc = tab.getX() + (tab.getWidth() + 1) / 2;
        int yc = 5 + (this.tabHeight - renderer.getTextHeight()) / 2;
        int titleColor = selected ? -1 : -2171170;
        renderer.drawCenteredText(tab.getDisplayTitle(), xc, yc, titleColor);
        if (tabIndex != 0) {
            renderer.drawVLine(tab.getX(), 5, this.tabHeight + 5, -2236963);
        }
    }

    private void playClickSound() {
        GSPanelContext.playSound((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public void mousePressed(GSMouseEvent event) {
        if (event.getButton() == 0) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                GSTabEntry tab = this.tabs.get(i);
                if (!tab.isHovered(event.getX(), event.getY())) continue;
                if (i != this.selectedTabIndex) {
                    this.setSelectedTabIndex(i);
                    this.playClickSound();
                }
                event.consume();
                return;
            }
        }
    }

    private class GSTabEntry {
        private final class_2561 title;
        private final GSPanel tabContent;
        private class_5481 displayTitle;
        private int x;
        private int width;

        public GSTabEntry(class_2561 title, GSPanel tabContent) {
            this.title = title;
            this.tabContent = tabContent;
        }

        public class_2561 getTitle() {
            return this.title;
        }

        public GSPanel getTabContent() {
            return this.tabContent;
        }

        public void setDisplayTitle(class_5481 displayTitle) {
            this.displayTitle = displayTitle;
        }

        public class_5481 getDisplayTitle() {
            return this.displayTitle;
        }

        private boolean isHovered(int mouseX, int mouseY) {
            if (mouseX < this.x || mouseX >= this.x + this.width) {
                return false;
            }
            return mouseY >= 5 && mouseY < 5 + GSTabbedGUI.this.tabHeight;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

