/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui;

import com.g4mesoft.gui.GSHotkeyGUI;
import com.g4mesoft.hotkey.GSKeyBinding;
import com.g4mesoft.hotkey.GSKeyCode;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.event.GSIKeyListener;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSKeyEvent;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.panel.legacy.GSButtonPanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3675;

public class GSHotkeyElementGUI
extends GSParentPanel
implements GSIMouseListener,
GSIKeyListener {
    private static final int HOTKEY_HEIGHT = 20;
    private static final int HOTKEY_PADDING = 2;
    private static final int MAX_NAME_WIDTH = 128;
    private static final int MODIFY_BUTTON_WIDTH = 160;
    private static final int RESET_BUTTON_WIDTH = 48;
    private static final int FONT_COLOR = -1;
    private static final int HOVERED_BACKGROUND = Integer.MIN_VALUE;
    private static final class_2561 RESET_TEXT = class_2561.method_43471((String)"gui.hotkey.reset");
    private static final class_2561 CANCEL_TEXT = class_2561.method_43471((String)"gui.hotkey.cancel");
    private final GSHotkeyGUI hotkeyGui;
    private final GSKeyBinding keyBinding;
    private final class_2561 nameText;
    private final GSButtonPanel modifyButton;
    private final GSButtonPanel resetButton;
    private boolean modifyingKeyCode;
    private final Set<class_3675.class_306> pressedKeys;
    private final Set<class_3675.class_306> activeKeys;

    public GSHotkeyElementGUI(GSHotkeyGUI hotkeyGui, GSKeyBinding keyBinding) {
        this.hotkeyGui = hotkeyGui;
        this.keyBinding = keyBinding;
        this.nameText = class_2561.method_43471((String)("hotkey." + keyBinding.getCategory() + "." + keyBinding.getName()));
        this.resetButton = new GSButtonPanel(RESET_TEXT, () -> {
            if (this.modifyingKeyCode) {
                this.stopModifying();
            } else if (hotkeyGui.getChangingElement() == null) {
                this.resetKeyCode();
            }
        });
        this.modifyButton = new GSButtonPanel("", () -> this.startModifying());
        this.add((GSPanel)this.resetButton);
        this.add((GSPanel)this.modifyButton);
        this.modifyingKeyCode = false;
        this.pressedKeys = new LinkedHashSet<class_3675.class_306>();
        this.activeKeys = new HashSet<class_3675.class_306>();
    }

    public void layout() {
        int by = 2;
        int rbx = this.width - 48 - 2;
        int mbx = rbx - 160 - 2;
        this.resetButton.setBounds(rbx, by, 48, 20);
        this.modifyButton.setBounds(mbx, by, 160, 20);
        this.updateButtons();
    }

    public void onAdded(GSPanel parent) {
        super.onAdded(parent);
        parent.addMouseEventListener((GSIMouseListener)this);
        parent.addKeyEventListener((GSIKeyListener)this);
    }

    public void onRemoved(GSPanel parent) {
        super.onAdded(parent);
        parent.removeMouseEventListener((GSIMouseListener)this);
        parent.removeKeyEventListener((GSIKeyListener)this);
    }

    private void updateButtons() {
        this.updateResetButton();
        this.updateModifyButton();
    }

    private void updateResetButton() {
        this.resetButton.setEnabled(this.modifyingKeyCode || !this.keyBinding.getKeyCode().equals(this.keyBinding.getDefaultKeyCode()));
        if (this.modifyingKeyCode) {
            this.resetButton.setText(CANCEL_TEXT);
        } else {
            this.resetButton.setText(RESET_TEXT);
        }
    }

    private void updateModifyButton() {
        class_2561 keyName = this.keyBinding.getLocalizedName();
        if (this.modifyingKeyCode) {
            keyName = keyName.method_27661().method_27692(class_124.field_1054);
            this.modifyButton.setText((class_2561)class_2561.method_43470((String)"> ").method_10852(keyName).method_27693(" <"));
        } else {
            this.modifyButton.setText(keyName);
        }
    }

    public void render(GSIRenderer2D renderer) {
        if (renderer.isMouseInside(0, 0, this.width, this.height)) {
            renderer.fillRect(0, 0, this.width, this.height, Integer.MIN_VALUE);
        }
        super.render(renderer);
        int ty = (this.height - renderer.getTextHeight() + 1) / 2;
        renderer.drawText(this.nameText, 2, ty, -1);
    }

    private void setKeyCode(GSKeyCode keyCode) {
        this.keyBinding.setKeyCode(keyCode);
        this.updateButtons();
    }

    public void resetKeyCode() {
        this.setKeyCode(this.keyBinding.getDefaultKeyCode());
    }

    public void unbindKeyCode() {
        this.setKeyCode(GSKeyCode.UNKNOWN_KEY);
    }

    private void startModifying() {
        if (this.hotkeyGui.getChangingElement() == null) {
            this.modifyingKeyCode = true;
            this.hotkeyGui.setChangingElement(this);
            this.updateButtons();
        }
        this.modifyButton.setPassingEvents(this.modifyingKeyCode);
    }

    private void stopModifying() {
        this.modifyingKeyCode = false;
        this.pressedKeys.clear();
        this.activeKeys.clear();
        this.modifyButton.setPassingEvents(false);
        if (this.hotkeyGui.getChangingElement() == this) {
            this.hotkeyGui.setChangingElement(null);
            this.updateButtons();
        }
    }

    public void mousePressed(GSMouseEvent event) {
        if (this.modifyingKeyCode) {
            this.onKeyPressed(class_3675.class_307.field_1672.method_1447(event.getButton()));
            event.consume();
        }
    }

    public void mouseReleased(GSMouseEvent event) {
        if (this.modifyingKeyCode) {
            this.onKeyReleased(class_3675.class_307.field_1672.method_1447(event.getButton()));
            event.consume();
        }
    }

    public void keyPressed(GSKeyEvent event) {
        if (this.modifyingKeyCode) {
            if (event.getKeyCode() == 256) {
                this.unbindKeyCode();
                this.stopModifying();
            } else {
                this.onKeyPressed(class_3675.method_15985((int)event.getKeyCode(), (int)event.getScanCode()));
            }
            event.consume();
        }
    }

    public void keyReleased(GSKeyEvent event) {
        if (this.modifyingKeyCode) {
            this.onKeyReleased(class_3675.method_15985((int)event.getKeyCode(), (int)event.getScanCode()));
            event.consume();
        }
    }

    private void onKeyPressed(class_3675.class_306 key) {
        this.pressedKeys.add(key);
        this.activeKeys.add(key);
    }

    private void onKeyReleased(class_3675.class_306 key) {
        if (this.activeKeys.remove(key) && this.activeKeys.isEmpty() && !this.pressedKeys.isEmpty()) {
            this.setKeyCode(GSKeyCode.fromKeys(this.pressedKeys.toArray(new class_3675.class_306[0])));
            this.stopModifying();
        }
    }

    public int getPreferredHeight() {
        return 24;
    }

    public int getPreferredWidth() {
        return 344;
    }
}

