/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui;

import com.g4mesoft.ui.panel.GSClosableParentPanel;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.event.GSCompoundButtonStroke;
import com.g4mesoft.ui.panel.event.GSIButtonStroke;
import com.g4mesoft.ui.panel.event.GSKeyButtonStroke;
import com.g4mesoft.ui.panel.event.GSMouseButtonStroke;
import java.util.LinkedList;

public class GSContentHistoryGUI
extends GSClosableParentPanel {
    private final LinkedList<GSPanel> contentHistory = new LinkedList();
    private GSPanel content;

    public GSContentHistoryGUI(GSPanel primaryContent, GSIButtonStroke backButton) {
        this.setContentNoHistory(primaryContent);
        backButton = new GSCompoundButtonStroke(backButton, new GSIButtonStroke[]{new GSMouseButtonStroke(3)});
        backButton = new GSCompoundButtonStroke(backButton, new GSIButtonStroke[]{new GSKeyButtonStroke(263, 6)});
        this.putButtonStroke(backButton, this::back);
    }

    protected void layout() {
        super.layout();
        this.content.setBounds(0, 0, this.width, this.height);
    }

    public void clearHistory() {
        if (!this.contentHistory.isEmpty()) {
            this.setContentNoHistory(this.contentHistory.getFirst());
            this.contentHistory.clear();
        }
    }

    public void removeHistory(GSPanel content) {
        if (content == this.content) {
            this.back();
        } else if (!this.contentHistory.isEmpty() && content != this.contentHistory.getFirst()) {
            this.contentHistory.removeLastOccurrence(content);
        }
    }

    public void back() {
        if (!this.contentHistory.isEmpty()) {
            this.setContentNoHistory(this.contentHistory.removeLast());
        } else {
            this.close();
        }
    }

    public GSPanel getContent() {
        return this.content;
    }

    public void setContent(GSPanel content) {
        this.contentHistory.addLast(this.content);
        this.setContentNoHistory(content);
    }

    private void setContentNoHistory(GSPanel content) {
        this.content = content;
        this.removeAll();
        this.add(content);
        this.invalidate();
        content.requestFocus();
    }
}

