/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.core.server;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.GSExtensionInfo;
import com.g4mesoft.GSExtensionUID;
import com.g4mesoft.GSIExtension;
import com.g4mesoft.access.common.GSIServerPlayNetworkHandlerAccess;
import com.g4mesoft.core.GSConnectionPacket;
import com.g4mesoft.core.GSController;
import com.g4mesoft.core.GSCoreExtension;
import com.g4mesoft.core.GSIModule;
import com.g4mesoft.core.GSVersion;
import com.g4mesoft.core.client.GSIClientModuleManager;
import com.g4mesoft.core.server.GSIServerModuleManager;
import com.g4mesoft.core.server.GSInfoCommand;
import com.g4mesoft.packet.GSCustomPayload;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.packet.GSPacketManager;
import com.g4mesoft.setting.GSISettingChangeListener;
import com.g4mesoft.setting.GSServerSettingMapPacket;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingChangePacket;
import com.g4mesoft.setting.GSSettingManager;
import com.g4mesoft.setting.GSSettingMap;
import com.g4mesoft.setting.GSSettingPermissionPacket;
import com.mojang.brigadier.CommandDispatcher;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class GSServerController
extends GSController
implements GSIServerModuleManager,
GSISettingChangeListener {
    public static final int OP_PERMISSION_LEVEL = 2;
    private static final GSServerController instance = new GSServerController();
    protected final GSSettingManager worldSettings = new GSSettingManager();
    private CommandDispatcher<class_2168> dispatcher;
    private MinecraftServer server = null;

    public GSServerController() {
        this.settings.addChangeListener(this);
        this.worldSettings.addChangeListener(this);
    }

    @Override
    public void addModule(GSIModule module) {
        if (!module.isServerSide()) {
            throw new IllegalArgumentException("Not a server module.");
        }
        module.registerGlobalServerSettings(this.settings);
        module.registerWorldServerSettings(this.worldSettings);
        if (!this.worldSettings.isDisjoint(this.settings)) {
            throw new IllegalStateException("The global- and world settings are not disjoint!");
        }
        if (this.dispatcher != null) {
            module.registerCommands(this.dispatcher);
        }
        super.addModule(module);
    }

    public void init(MinecraftServer server) {
        this.server = server;
        this.onStart();
    }

    @Override
    protected void onStart() {
        this.worldSettings.loadSettings(this.getWorldSettingsFile());
        super.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (!this.worldSettings.isEmpty()) {
            this.worldSettings.saveSettings(this.getWorldSettingsFile());
        }
        this.worldSettings.clearSettings();
    }

    public void setCommandDispatcher(CommandDispatcher<class_2168> dispatcher) {
        GSInfoCommand.registerCommand(dispatcher);
        for (GSIModule module : this.modules) {
            module.registerCommands(dispatcher);
        }
        this.dispatcher = dispatcher;
    }

    public void onPlayerJoin(class_3222 player) {
        this.sendPacket(new GSConnectionPacket(G4mespeedMod.getExtensionInfoList()), player, GSVersion.INVALID);
        for (GSIModule module : this.modules) {
            module.onPlayerJoin(player);
        }
    }

    @Override
    public boolean isExtensionInstalled(class_3222 player, GSExtensionUID extensionUid) {
        return ((GSIServerPlayNetworkHandlerAccess)player.field_13987).gs_isExtensionInstalled(extensionUid);
    }

    @Override
    public boolean isExtensionInstalled(class_3222 player, GSExtensionUID extensionUid, GSVersion minimumVersion) {
        return ((GSIServerPlayNetworkHandlerAccess)player.field_13987).gs_isExtensionInstalled(extensionUid, minimumVersion);
    }

    @Override
    public GSExtensionInfo getExtensionInfo(class_3222 player, GSExtensionUID extensionUid) {
        return ((GSIServerPlayNetworkHandlerAccess)player.field_13987).gs_getExtensionInfo(extensionUid);
    }

    public void onG4mespeedClientJoined(class_3222 player, GSExtensionInfo[] extensionInfo) {
        ((GSIServerPlayNetworkHandlerAccess)player.field_13987).gs_clearAllExtensionInfo();
        ((GSIServerPlayNetworkHandlerAccess)player.field_13987).gs_addAllExtensionInfo(extensionInfo);
        if (this.isExtensionInstalled(player, GSCoreExtension.UID)) {
            GSExtensionInfo coreInfo = this.getExtensionInfo(player, GSCoreExtension.UID);
            for (GSIModule module : this.modules) {
                module.onG4mespeedClientJoin(player, coreInfo);
            }
            this.sendSettings(player);
        }
    }

    private void sendSettings(class_3222 player) {
        this.sendSettingPermissionPacket(player);
        for (GSSettingMap settingMap : this.settings.getSettings()) {
            this.sendPacket(new GSServerSettingMapPacket(settingMap), player);
        }
        for (GSSettingMap settingMap : this.worldSettings.getSettings()) {
            this.sendPacket(new GSServerSettingMapPacket(settingMap), player);
        }
    }

    public void onPlayerLeave(class_3222 player) {
        for (GSIModule module : this.modules) {
            module.onPlayerLeave(player);
        }
    }

    public void onServerShutdown() {
        this.onStop();
        this.server = null;
    }

    public void onPlayerPermissionChanged(class_3222 player) {
        this.sendSettingPermissionPacket(player);
        for (GSIModule module : this.modules) {
            module.onPlayerPermissionChanged(player);
        }
    }

    @Override
    protected void addExtensionModules(GSIExtension extension) {
        extension.addServerModules(this);
    }

    @Override
    public boolean isThreadOwner() {
        return this.server != null && this.server.method_18854();
    }

    @Override
    public class_2596<?> createCustomPayload(ByteBuf buffer) {
        return new class_2658((class_8710)GSCustomPayload.create(buffer));
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void runOnClient(Consumer<GSIClientModuleManager> consumer) {
    }

    @Override
    public void runOnServer(Consumer<GSIServerModuleManager> consumer) {
        consumer.accept(this);
    }

    @Override
    public void sendPacket(GSIPacket packet, class_3222 player, GSVersion minExtensionVersion) {
        class_2596<?> customPayload;
        GSPacketManager packetManager;
        GSExtensionUID extensionUid;
        if (this.server != null && (extensionUid = (packetManager = G4mespeedMod.getPacketManager()).getPacketExtensionUniqueId(packet)) != null && this.isExtensionInstalled(player, extensionUid, minExtensionVersion) && (customPayload = packetManager.encodePacket(packet, this)) != null) {
            player.field_13987.method_14364(customPayload);
        }
    }

    @Override
    public void sendPacketToAll(GSIPacket packet, GSVersion minExtensionVersion) {
        this.sendPacketToAllExcept(packet, minExtensionVersion, null);
    }

    @Override
    public void sendPacketToAllExcept(GSIPacket packet, GSVersion minExtensionVersion, class_3222 exceptPlayer) {
        class_2596<?> customPayload;
        GSPacketManager packetManager;
        GSExtensionUID extensionUid;
        if (this.server != null && (extensionUid = (packetManager = G4mespeedMod.getPacketManager()).getPacketExtensionUniqueId(packet)) != null && (customPayload = packetManager.encodePacket(packet, this)) != null) {
            for (class_3222 player : this.getAllPlayers()) {
                if (player == exceptPlayer || !this.isExtensionInstalled(player, extensionUid, minExtensionVersion)) continue;
                player.field_13987.method_14364(customPayload);
            }
        }
    }

    @Override
    public class_3222 getPlayer(UUID playerUUID) {
        return this.server.method_3760().method_14602(playerUUID);
    }

    @Override
    public Collection<class_3222> getAllPlayers() {
        return Collections.unmodifiableCollection(this.server.method_3760().method_14571());
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public File getCacheFile() {
        File runDirectory = this.server.method_3831().toAbsolutePath().toFile();
        if (this.server.method_3816()) {
            return new File(runDirectory, "g4mespeed/cache");
        }
        return new File(runDirectory, "g4mespeed/integrated/cache");
    }

    @Override
    public GSSettingManager getWorldSettingManager() {
        return this.worldSettings;
    }

    @Override
    public File getWorldCacheFile() {
        return new File(this.server.method_27050(class_5218.field_24188).toAbsolutePath().toFile(), "g4mespeed/cache");
    }

    private File getWorldSettingsFile() {
        return new File(this.getWorldCacheFile(), "settings.cfg");
    }

    @Override
    public void onSettingChanged(GSSettingCategory category, GSSetting<?> setting) {
        this.sendSettingChange(category, setting, GSSettingChangePacket.GSESettingChangeType.SETTING_CHANGED);
    }

    @Override
    public void onSettingAdded(GSSettingCategory category, GSSetting<?> setting) {
        this.sendSettingChange(category, setting, GSSettingChangePacket.GSESettingChangeType.SETTING_ADDED);
    }

    @Override
    public void onSettingRemoved(GSSettingCategory category, GSSetting<?> setting) {
        this.sendSettingChange(category, setting, GSSettingChangePacket.GSESettingChangeType.SETTING_REMOVED);
    }

    private void sendSettingChange(GSSettingCategory category, GSSetting<?> setting, GSSettingChangePacket.GSESettingChangeType type) {
        if (!setting.isActive()) {
            return;
        }
        this.sendPacketToAll(new GSSettingChangePacket(category, setting, type));
    }

    public boolean isAllowedSettingChange(class_3222 player) {
        return player.method_5687(2);
    }

    private void sendSettingPermissionPacket(class_3222 player) {
        this.sendPacket(new GSSettingPermissionPacket(this.isAllowedSettingChange(player)), player);
    }

    public static GSServerController getInstance() {
        return instance;
    }
}

