/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.core.compat;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.core.compat.GSAbstractCompat;
import com.g4mesoft.core.compat.GSCompatUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.class_1297;

public class GSTweakerooCompat
extends GSAbstractCompat {
    private static final String CAMERA_ENTITY_CLASSPATH = "fi.dy.masa.tweakeroo.util.CameraEntity";
    private static final String MOVEMENT_TICK_METHOD = "movementTick";
    private static final String CAMERA_FIELD = "camera";
    private boolean tweakerooDetected = false;
    private Class<?> cameraEntityClazz = null;
    private Field cameraField = null;
    private Method movementTickMethod = null;
    private Object tmpCamera;

    @Override
    public void detect() {
        this.cameraEntityClazz = GSCompatUtil.findClassByName(CAMERA_ENTITY_CLASSPATH);
        if (this.cameraEntityClazz == null) {
            return;
        }
        this.tweakerooDetected = true;
        G4mespeedMod.GS_LOGGER.info("Tweakeroo mod detected!");
        this.cameraField = GSCompatUtil.findDeclaredField(this.cameraEntityClazz, CAMERA_FIELD);
        this.movementTickMethod = GSCompatUtil.findDeclaredMethod(this.cameraEntityClazz, MOVEMENT_TICK_METHOD, new Class[0]);
        if (this.cameraField == null || this.movementTickMethod == null) {
            G4mespeedMod.GS_LOGGER.warn("Unable to retreive CameraEntity fields and methods.");
            this.resetFields();
        } else {
            try {
                this.cameraField.setAccessible(true);
                this.movementTickMethod.setAccessible(true);
            }
            catch (Exception e) {
                G4mespeedMod.GS_LOGGER.warn("Unable to make camera field and movementTick method accessible.");
                this.resetFields();
            }
        }
    }

    private void resetFields() {
        this.cameraField = null;
        this.movementTickMethod = null;
    }

    public boolean isTweakerooDetected() {
        return this.tweakerooDetected;
    }

    public boolean isCameraEntityRetreived() {
        return this.tweakerooDetected && this.cameraField != null && this.movementTickMethod != null;
    }

    public boolean isCameraEntityInstance(class_1297 entity) {
        if (this.cameraEntityClazz != null) {
            return this.cameraEntityClazz.isInstance(entity);
        }
        return false;
    }

    public void disableCameraEntity() {
        if (this.cameraField != null) {
            this.tmpCamera = GSCompatUtil.getStaticField(this.cameraField);
            GSCompatUtil.setStaticField(this.cameraField, null);
        }
    }

    public void enableCameraEntityTicking() {
        if (this.cameraField != null) {
            GSCompatUtil.setStaticField(this.cameraField, this.tmpCamera);
            this.tmpCamera = null;
        }
    }

    public void tickCameraEntityMovement() {
        if (this.movementTickMethod != null) {
            GSCompatUtil.invokeStatic(this.movementTickMethod, new Object[0]);
        }
    }

    public boolean isCameraEntityEnabled() {
        return this.cameraField != null && GSCompatUtil.getStaticField(this.cameraField) != null;
    }
}

