/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.core.client;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.GSExtensionInfo;
import com.g4mesoft.GSExtensionInfoList;
import com.g4mesoft.GSExtensionUID;
import com.g4mesoft.GSIExtension;
import com.g4mesoft.core.GSConnectionPacket;
import com.g4mesoft.core.GSController;
import com.g4mesoft.core.GSCoreExtension;
import com.g4mesoft.core.GSIModule;
import com.g4mesoft.core.GSVersion;
import com.g4mesoft.core.client.GSIClientModuleManager;
import com.g4mesoft.core.server.GSIServerModuleManager;
import com.g4mesoft.gui.GSContentHistoryGUI;
import com.g4mesoft.gui.GSHotkeyGUI;
import com.g4mesoft.gui.GSInfoGUI;
import com.g4mesoft.gui.GSKeyBindingButtonStroke;
import com.g4mesoft.gui.GSTabbedGUI;
import com.g4mesoft.gui.setting.GSSettingsGUI;
import com.g4mesoft.hotkey.GSEKeyEventType;
import com.g4mesoft.hotkey.GSKeyBinding;
import com.g4mesoft.hotkey.GSKeyManager;
import com.g4mesoft.packet.GSCustomPayload;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.packet.GSPacketManager;
import com.g4mesoft.setting.GSRemoteSettingManager;
import com.g4mesoft.ui.G4mespeedUIMod;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelContext;
import com.g4mesoft.ui.panel.scroll.GSScrollPanel;
import com.g4mesoft.ui.renderer.GSIRenderable3D;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class GSClientController
extends GSController
implements GSIClientModuleManager {
    public static final String CLIENT_SETTINGS_GUI_TITLE = "gui.tab.clientSettings";
    private static final String SERVER_SETTINGS_GUI_TITLE = "gui.tab.serverSettings";
    public static final String HOTKEY_GUI_TITLE = "gui.tab.hotkeys";
    public static final String G4MESPEED_INFO_GUI_TITLE = "gui.tab.info";
    private static final String GS_KEY_CATEGORY = "gs";
    private static final String GUI_KEY_NAME = "opengui";
    private static final String HOTKEY_SETTINGS_FILE_NAME = "hotkeys.cfg";
    private static final GSClientController instance = new GSClientController();
    private class_310 minecraft;
    private boolean connectedToServer;
    private class_634 networkHandler;
    private final GSExtensionInfoList serverExtensionInfoList = new GSExtensionInfoList();
    private final GSRemoteSettingManager serverSettings = new GSRemoteSettingManager(this);
    private final GSKeyManager keyManager = new GSKeyManager();
    private GSKeyBinding openGUIKey;
    private GSTabbedGUI tabbedGUI;
    private GSContentHistoryGUI contentHistoryGUI;

    public void init(class_310 minecraft) {
        if (this.minecraft == null) {
            this.minecraft = minecraft;
            this.keyManager.loadKeys(this.getHotkeySettingsFile());
            this.openGUIKey = this.keyManager.registerKey(GUI_KEY_NAME, GS_KEY_CATEGORY, 71, () -> {
                if (this.contentHistoryGUI != null) {
                    GSPanelContext.openContent((GSPanel)this.contentHistoryGUI);
                }
            }, GSEKeyEventType.PRESS, false);
            this.tabbedGUI = new GSTabbedGUI();
            this.tabbedGUI.addTab(CLIENT_SETTINGS_GUI_TITLE, (GSPanel)new GSScrollPanel((GSPanel)new GSSettingsGUI(this.settings)));
            this.tabbedGUI.addTab(SERVER_SETTINGS_GUI_TITLE, (GSPanel)new GSScrollPanel((GSPanel)new GSSettingsGUI(this.serverSettings)));
            this.tabbedGUI.addTab(HOTKEY_GUI_TITLE, (GSPanel)new GSScrollPanel((GSPanel)new GSHotkeyGUI(this.keyManager)));
            this.tabbedGUI.addTab(G4MESPEED_INFO_GUI_TITLE, (GSPanel)new GSInfoGUI(this));
            this.contentHistoryGUI = new GSContentHistoryGUI((GSPanel)this.tabbedGUI, new GSKeyBindingButtonStroke(this.openGUIKey));
            this.onStart();
        }
    }

    @Override
    public void addModule(GSIModule module) {
        if (!module.isClientSide()) {
            throw new IllegalArgumentException("Not a client module.");
        }
        module.registerClientSettings(this.settings);
        module.registerHotkeys(this.keyManager);
        module.registerGlobalServerSettings(this.serverSettings);
        module.registerWorldServerSettings(this.serverSettings);
        super.addModule(module);
        module.initGUI(this.tabbedGUI);
    }

    public void setNetworkHandler(class_634 networkHandler) {
        this.networkHandler = networkHandler;
    }

    @Override
    public boolean isServerExtensionInstalled(GSExtensionUID extensionUid) {
        return this.serverExtensionInfoList.isExtensionInstalled(extensionUid);
    }

    @Override
    public boolean isServerExtensionInstalled(GSExtensionUID extensionUid, GSVersion minimumVersion) {
        return this.serverExtensionInfoList.isExtensionInstalled(extensionUid, minimumVersion);
    }

    @Override
    public GSExtensionInfo getServerExtensionInfo(GSExtensionUID extensionUid) {
        return this.serverExtensionInfoList.getInfo(extensionUid);
    }

    @Override
    public GSExtensionInfoList getServerExtensionInfoList() {
        return this.serverExtensionInfoList;
    }

    @Override
    public boolean isG4mespeedServer() {
        return this.isServerExtensionInstalled(GSCoreExtension.UID);
    }

    public boolean isConnectedToServer() {
        return this.connectedToServer;
    }

    public void onJoinServer() {
        this.connectedToServer = true;
        for (GSIModule module : this.modules) {
            module.onJoinServer();
        }
    }

    public void onJoinG4mespeedServer(GSExtensionInfo[] extensionInfo) {
        this.serverExtensionInfoList.clearInfo();
        this.serverExtensionInfoList.addAllInfo(extensionInfo);
        if (this.isServerExtensionInstalled(GSCoreExtension.UID)) {
            this.sendPacket(new GSConnectionPacket(G4mespeedMod.getExtensionInfoList()));
            GSExtensionInfo coreInfo = this.getServerExtensionInfo(GSCoreExtension.UID);
            for (GSIModule module : this.modules) {
                module.onJoinG4mespeedServer(coreInfo);
            }
        }
    }

    public void onDisconnectServer() {
        this.connectedToServer = false;
        this.setNetworkHandler(null);
        for (GSIModule module : this.modules) {
            module.onDisconnectServer();
        }
        this.contentHistoryGUI.clearHistory();
        this.serverExtensionInfoList.clearInfo();
        this.serverSettings.clearSettings();
    }

    public void onClientClose() {
        if (this.minecraft != null) {
            this.keyManager.saveKeys(this.getHotkeySettingsFile());
            this.keyManager.dispose();
            this.onStop();
            this.openGUIKey = null;
            this.tabbedGUI = null;
            this.minecraft = null;
        }
    }

    private File getHotkeySettingsFile() {
        return new File(this.getCacheFile(), HOTKEY_SETTINGS_FILE_NAME);
    }

    @Override
    protected void addExtensionModules(GSIExtension extension) {
        extension.addClientModules(this);
    }

    @Override
    public boolean isThreadOwner() {
        return this.minecraft != null && this.minecraft.method_18854();
    }

    @Override
    public class_2596<?> createCustomPayload(ByteBuf buffer) {
        return new class_2817((class_8710)GSCustomPayload.create(buffer));
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void runOnClient(Consumer<GSIClientModuleManager> consumer) {
        consumer.accept(this);
    }

    @Override
    public void runOnServer(Consumer<GSIServerModuleManager> consumer) {
    }

    @Override
    public boolean isInGame() {
        return this.minecraft != null && this.minecraft.field_1755 == null;
    }

    @Override
    public void sendPacket(GSIPacket packet, GSVersion minExtensionVersion) {
        class_2596<?> customPayload;
        GSPacketManager packetManager;
        GSExtensionUID extensionUid;
        if (this.networkHandler != null && (extensionUid = (packetManager = G4mespeedMod.getPacketManager()).getPacketExtensionUniqueId(packet)) != null && this.isServerExtensionInstalled(extensionUid, minExtensionVersion) && (customPayload = packetManager.encodePacket(packet, this)) != null) {
            this.networkHandler.method_52787(customPayload);
        }
    }

    @Override
    public File getCacheFile() {
        return new File(this.minecraft.field_1697, "g4mespeed/cache");
    }

    @Override
    public void addRenderable(GSIRenderable3D renderable) {
        G4mespeedUIMod.addRenderable((GSIRenderable3D)renderable);
    }

    @Override
    public void removeRenderable(GSIRenderable3D renderable) {
        G4mespeedUIMod.removeRenderable((GSIRenderable3D)renderable);
    }

    public class_746 getPlayer() {
        return this.minecraft != null ? this.minecraft.field_1724 : null;
    }

    public class_310 getClient() {
        return this.minecraft;
    }

    public GSKeyManager getKeyManager() {
        return this.keyManager;
    }

    public GSRemoteSettingManager getServerSettings() {
        return this.serverSettings;
    }

    public GSTabbedGUI getTabbedGUI() {
        return this.tabbedGUI;
    }

    public GSContentHistoryGUI getPrimaryGUI() {
        return this.contentHistoryGUI;
    }

    public GSKeyBinding getOpenGUIKey() {
        return this.openGUIKey;
    }

    public static GSClientController getInstance() {
        return instance;
    }
}

