/*
 * Decompiled with CFR 0.152.
 */
package litetech.commands;

import carpet.utils.CommandHelper;
import chronos.ChronosSettings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import litetech.helpers.ScoreboardObjectiveHelper;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2214;
import net.minecraft.class_2239;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_2995;
import net.minecraft.class_8646;
import net.minecraft.class_9015;

public class SideBarCommand {
    private static final SimpleCommandExceptionType OBJECTIVES_DISPLAY_ALREADY_SET_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.scoreboard.objectives.display.alreadySet"));
    private static final Dynamic2CommandExceptionType PLAYERS_GET_NULL_EXCEPTION = new Dynamic2CommandExceptionType((object, object2) -> class_2561.method_43469((String)"commands.scoreboard.players.get.null", (Object[])new Object[]{object, object2}));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sidebar").requires(player -> CommandHelper.canUseCommand((class_2168)player, (Object)ChronosSettings.commandSidebar))).then(class_2170.method_9247((String)"show").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(context -> SideBarCommand.executeSetDisplay((class_2168)context.getSource(), class_2214.method_9395((CommandContext)context, (String)"objective"), null))).then(class_2170.method_9244((String)"slot", (ArgumentType)class_2239.method_9468()).executes(context -> SideBarCommand.executeSetDisplay((class_2168)context.getSource(), class_2214.method_9395((CommandContext)context, (String)"objective"), class_2239.method_9465((CommandContext)context, (String)"slot"))))))).then(class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(context -> SideBarCommand.executeGet((class_2168)context.getSource(), (class_1657)class_2186.method_9315((CommandContext)context, (String)"player"), class_2214.method_9395((CommandContext)context, (String)"objective"))))))).then(class_2170.method_9247((String)"clear").executes(context -> SideBarCommand.executeClearDisplay((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"freeze").requires(source -> source.method_9259(1))).then(class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(context -> {
            class_266 objective = class_2214.method_9395((CommandContext)context, (String)"objective");
            ((ScoreboardObjectiveHelper)objective).setFrozen(true);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Froze scores for objective: " + objective.method_1113())));
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unfreeze").requires(source -> source.method_9259(1))).then(class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(context -> {
            class_266 objective = class_2214.method_9395((CommandContext)context, (String)"objective");
            ((ScoreboardObjectiveHelper)objective).setFrozen(false);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Unfroze scores for objective: " + objective.method_1113())));
            return 0;
        }))));
    }

    private static int executeClearDisplay(class_2168 source) throws CommandSyntaxException {
        class_2995 scoreboard = source.method_9211().method_3845();
        if (scoreboard.method_1189(null) == null) {
            throw OBJECTIVES_DISPLAY_ALREADY_SET_EXCEPTION.create();
        }
        scoreboard.method_1158(null, (class_266)null);
        source.method_45068((class_2561)class_2561.method_43471((String)"commands.scoreboard.objectives.display.cleared"));
        return 0;
    }

    private static int executeSetDisplay(class_2168 source, class_266 objective, class_8646 slot) throws CommandSyntaxException {
        class_2995 scoreboard = source.method_9211().method_3845();
        if (scoreboard.method_1189(slot) == objective) {
            throw OBJECTIVES_DISPLAY_ALREADY_SET_EXCEPTION.create();
        }
        scoreboard.method_1158(slot, objective);
        source.method_45068((class_2561)class_2561.method_43469((String)"commands.scoreboard.objectives.display.set", (Object[])new Object[]{objective.method_1114(), objective.method_1114()}));
        return 0;
    }

    private static int executeGet(class_2168 source, class_1657 player, class_266 objective) throws CommandSyntaxException {
        class_9015 holder;
        class_2995 scoreboard = source.method_9211().method_3845();
        if (scoreboard.method_55430(holder = class_9015.method_55422((String)player.method_5476().getString()), objective) == null) {
            throw PLAYERS_GET_NULL_EXCEPTION.create((Object)objective.method_1113(), (Object)player.method_5476().getString());
        }
        int score = scoreboard.method_55430(holder, objective).method_55397();
        source.method_45068((class_2561)class_2561.method_43469((String)"commands.scoreboard.players.get.success", (Object[])new Object[]{player.method_5476().getString(), score, objective.method_1120()}));
        return score;
    }
}

