/*
 * Decompiled with CFR 0.152.
 */
package chronos;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.api.settings.SettingsManager;
import chronos.ChronosSettings;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import johan.commands.TotalCommand;
import litetech.commands.SideBarCommand;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronosExtension
implements CarpetExtension,
ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"chronos-carpet");

    public static void noop() {
    }

    public void onGameStarted() {
        LOGGER.info("Initializing Chronos Carpet Extension");
        CarpetServer.settingsManager.parseSettingsClass(ChronosSettings.class);
    }

    public void onServerLoaded(MinecraftServer server) {
    }

    public void onTick(MinecraftServer server) {
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        SideBarCommand.register(dispatcher);
        TotalCommand.register(dispatcher);
    }

    public SettingsManager extensionSettingsManager() {
        return null;
    }

    public void onPlayerLoggedIn(class_3222 player) {
    }

    public void onPlayerLoggedOut(class_3222 player) {
    }

    public void onInitialize() {
    }

    public Map<String, String> canHasTranslations(String lang) {
        String jsonData;
        InputStream langFile = ChronosExtension.class.getClassLoader().getResourceAsStream("assets/chronos-carpet-addons/lang/%s.json".formatted(lang));
        if (langFile == null) {
            return Map.of();
        }
        try {
            jsonData = IOUtils.toString((InputStream)langFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Map.of();
        }
        return (Map)new Gson().fromJson(jsonData, new TypeToken<Map<String, String>>(){}.getType());
    }

    static {
        CarpetServer.manageExtension((CarpetExtension)new ChronosExtension());
    }
}

