/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.villager;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.villager.FavoriteData;
import fi.dy.masa.itemscroller.villager.IMerchantScreenHandler;
import fi.dy.masa.itemscroller.villager.TradeType;
import fi.dy.masa.itemscroller.villager.VillagerData;
import fi.dy.masa.itemscroller.villager.VillagerUtils;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1728;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

public class VillagerDataStorage {
    private static final VillagerDataStorage INSTANCE = new VillagerDataStorage();
    private final Map<UUID, VillagerData> data = new HashMap<UUID, VillagerData>();
    private final List<TradeType> globalFavorites = new ArrayList<TradeType>();
    private UUID lastInteractedUUID;
    private boolean dirty;

    public static VillagerDataStorage getInstance() {
        return INSTANCE;
    }

    public void setLastInteractedUUID(UUID uuid) {
        this.lastInteractedUUID = uuid;
    }

    @Nullable
    public VillagerData getDataForLastInteractionTarget() {
        return this.getDataFor(this.lastInteractedUUID, true);
    }

    public VillagerData getDataFor(@Nullable UUID uuid, boolean create) {
        VillagerData data;
        VillagerData villagerData = data = uuid != null ? this.data.get(uuid) : null;
        if (data == null && uuid != null && create) {
            this.setLastInteractedUUID(uuid);
            data = new VillagerData(uuid);
            this.data.put(uuid, data);
            this.dirty = true;
        }
        return data;
    }

    public void setTradeListPosition(int position) {
        VillagerData data = this.getDataFor(this.lastInteractedUUID, true);
        if (data != null) {
            data.setTradeListPosition(position);
            this.dirty = true;
        }
    }

    public void toggleFavorite(int tradeIndex) {
        VillagerData data = this.getDataFor(this.lastInteractedUUID, true);
        if (data != null) {
            data.toggleFavorite(tradeIndex);
            this.dirty = true;
        }
    }

    public void toggleGlobalFavorite(class_1914 trade) {
        TradeType type = TradeType.of(trade);
        if (this.globalFavorites.contains(type)) {
            this.globalFavorites.remove(type);
        } else {
            this.globalFavorites.add(type);
        }
        this.dirty = true;
    }

    public FavoriteData getFavoritesForCurrentVillager(class_1728 handler) {
        return this.getFavoritesForCurrentVillager(((IMerchantScreenHandler)handler).getOriginalList());
    }

    public FavoriteData getFavoritesForCurrentVillager(class_1916 originalTrades) {
        IntArrayList favorites;
        VillagerData data = this.getDataFor(this.lastInteractedUUID, false);
        IntArrayList intArrayList = favorites = data != null ? data.getFavorites() : null;
        if (favorites != null && !favorites.isEmpty()) {
            return new FavoriteData(favorites, false);
        }
        if (Configs.Generic.VILLAGER_TRADE_USE_GLOBAL_FAVORITES.getBooleanValue() && this.lastInteractedUUID != null) {
            return new FavoriteData(VillagerUtils.getGlobalFavoritesFor(originalTrades, this.globalFavorites), true);
        }
        return new FavoriteData(IntArrayList.of(), favorites == null);
    }

    private void readFromNBT(class_2487 nbt) {
        class_2487 tag;
        int i;
        if (nbt == null || !nbt.method_10573("VillagerData", 9)) {
            return;
        }
        class_2499 tagList = nbt.method_10554("VillagerData", 10);
        int count = tagList.size();
        for (i = 0; i < count; ++i) {
            tag = tagList.method_10602(i);
            VillagerData data = VillagerData.fromNBT(tag);
            if (data == null) continue;
            this.data.put(data.getUUID(), data);
        }
        tagList = nbt.method_10554("GlobalFavorites", 10);
        count = tagList.size();
        for (i = 0; i < count; ++i) {
            tag = tagList.method_10602(i);
            TradeType type = TradeType.fromTag(tag);
            if (type == null) continue;
            this.globalFavorites.add(type);
        }
    }

    private class_2487 writeToNBT(@Nonnull class_2487 nbt) {
        class_2499 favoriteListData = new class_2499();
        class_2499 globalFavoriteData = new class_2499();
        for (VillagerData data : this.data.values()) {
            favoriteListData.add((Object)data.toNBT());
        }
        for (TradeType type : this.globalFavorites) {
            globalFavoriteData.add((Object)type.toTag());
        }
        nbt.method_10566("VillagerData", (class_2520)favoriteListData);
        nbt.method_10566("GlobalFavorites", (class_2520)globalFavoriteData);
        this.dirty = false;
        return nbt;
    }

    private String getFileName() {
        String worldName = StringUtils.getWorldOrServerName();
        if (worldName != null) {
            return "villager_data_" + worldName + ".nbt";
        }
        return "villager_data.nbt";
    }

    private File getSaveDir() {
        return new File(FileUtils.getMinecraftDirectory(), "itemscroller");
    }

    public void readFromDisk() {
        this.data.clear();
        this.globalFavorites.clear();
        try {
            File saveDir = this.getSaveDir();
            File file = new File(saveDir, this.getFileName());
            if (file.exists() && file.isFile() && file.canRead()) {
                FileInputStream is = new FileInputStream(file);
                this.readFromNBT(class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898()));
                is.close();
            }
        }
        catch (Exception e) {
            ItemScroller.logger.warn("Failed to read villager data from file", (Throwable)e);
        }
    }

    public void writeToDisk() {
        if (this.dirty) {
            try {
                File saveDir = this.getSaveDir();
                if (!saveDir.exists() && !saveDir.mkdirs()) {
                    ItemScroller.logger.warn("Failed to create the data storage directory '{}'", (Object)saveDir.getPath());
                    return;
                }
                File fileTmp = new File(saveDir, this.getFileName() + ".tmp");
                File fileReal = new File(saveDir, this.getFileName());
                FileOutputStream os = new FileOutputStream(fileTmp);
                class_2507.method_10634((class_2487)this.writeToNBT(new class_2487()), (OutputStream)os);
                os.close();
                if (fileReal.exists()) {
                    fileReal.delete();
                }
                fileTmp.renameTo(fileReal);
                this.dirty = false;
            }
            catch (Exception e) {
                ItemScroller.logger.warn("Failed to write villager data to file!", (Throwable)e);
            }
        }
    }
}

