/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.compat.carpet.StackingShulkerBoxes;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3955;
import net.minecraft.class_465;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public class RecipePattern {
    private class_1799 result = InventoryUtils.EMPTY_STACK;
    private class_1799[] recipe = new class_1799[9];
    private class_8786<class_3955> cachedRecipeEntryFromBook = null;
    private int maxCraftAmount = 64;
    private HashSet<class_1792> recipeRemainders = new HashSet();

    public RecipePattern() {
        this.ensureRecipeSizeAndClearRecipe(9);
    }

    public void ensureRecipeSize(int size) {
        if (this.getRecipeLength() != size) {
            this.recipe = new class_1799[size];
        }
    }

    public void clearRecipe() {
        Arrays.fill(this.recipe, InventoryUtils.EMPTY_STACK);
        this.result = InventoryUtils.EMPTY_STACK;
        this.cachedRecipeEntryFromBook = null;
        this.maxCraftAmount = 64;
        this.recipeRemainders.clear();
    }

    public void ensureRecipeSizeAndClearRecipe(int size) {
        this.ensureRecipeSize(size);
        this.clearRecipe();
    }

    public void initializeRecipe() {
        for (int i = 0; i < this.recipe.length; ++i) {
            int maxCount;
            if (this.recipe[i].method_7909().method_7857()) {
                this.recipeRemainders.add(this.recipe[i].method_7909().method_7858());
            }
            if (this.recipe[i].method_7909() == class_1802.field_8162 || (maxCount = StackingShulkerBoxes.getMaxCount(this.recipe[i])) >= this.maxCraftAmount) continue;
            this.maxCraftAmount = maxCount;
        }
        this.cachedRecipeEntryFromBook = InventoryUtils.getBookRecipeEntryFromPattern(this);
    }

    public class_8786<class_3955> getCraftingRecipe() {
        if (this.cachedRecipeEntryFromBook == null) {
            this.cachedRecipeEntryFromBook = InventoryUtils.getBookRecipeEntryFromPattern(this);
        }
        return this.cachedRecipeEntryFromBook;
    }

    public int getMaxCraftAmount() {
        return this.maxCraftAmount;
    }

    public void storeCraftingRecipe(class_1735 slot, class_465<? extends class_1703> gui, boolean clearIfEmpty) {
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null) {
            if (slot.method_7681()) {
                int gridSize = range.getSlotCount();
                int numSlots = gui.method_17577().field_7761.size();
                this.ensureRecipeSizeAndClearRecipe(gridSize);
                int i = 0;
                for (int s = range.getFirst(); i < gridSize && s < numSlots; ++i, ++s) {
                    class_1735 slotTmp = gui.method_17577().method_7611(s);
                    this.recipe[i] = slotTmp.method_7681() ? slotTmp.method_7677().method_7972() : InventoryUtils.EMPTY_STACK;
                }
                this.result = slot.method_7677().method_7972();
                this.initializeRecipe();
            } else if (clearIfEmpty) {
                this.clearRecipe();
            }
        }
    }

    public void copyRecipeFrom(RecipePattern other) {
        int size = other.getRecipeLength();
        class_1799[] otherRecipe = other.getRecipeItems();
        this.ensureRecipeSizeAndClearRecipe(size);
        for (int i = 0; i < size; ++i) {
            this.recipe[i] = !InventoryUtils.isStackEmpty(otherRecipe[i]) ? otherRecipe[i].method_7972() : InventoryUtils.EMPTY_STACK;
        }
        this.result = !InventoryUtils.isStackEmpty(other.getResult()) ? other.getResult().method_7972() : InventoryUtils.EMPTY_STACK;
        this.initializeRecipe();
    }

    public void readFromNBT(@Nonnull class_2487 nbt, class_5455 registryManager) {
        if (nbt.method_10573("Result", 10) && nbt.method_10573("Ingredients", 9)) {
            class_2499 tagIngredients = nbt.method_10554("Ingredients", 10);
            int count = tagIngredients.size();
            int length = nbt.method_10550("Length");
            if (length > 0) {
                this.ensureRecipeSizeAndClearRecipe(length);
            }
            for (int i = 0; i < count; ++i) {
                class_2487 tag = tagIngredients.method_10602(i);
                int slot = tag.method_10550("Slot");
                if (slot < 0 || slot >= this.recipe.length) continue;
                this.recipe[slot] = class_1799.method_57359((class_7225.class_7874)registryManager, (class_2487)tag);
            }
            this.result = class_1799.method_57359((class_7225.class_7874)registryManager, (class_2487)nbt.method_10562("Result"));
            this.initializeRecipe();
        }
    }

    @Nonnull
    public class_2487 writeToNBT(class_5455 registryManager) {
        class_2487 nbt = new class_2487();
        if (this.isValid()) {
            class_2487 tag = (class_2487)this.result.method_57358((class_7225.class_7874)registryManager);
            nbt.method_10569("Length", this.recipe.length);
            nbt.method_10566("Result", (class_2520)tag);
            class_2499 tagIngredients = new class_2499();
            for (int i = 0; i < this.recipe.length; ++i) {
                if (this.recipe[i].method_7960() || InventoryUtils.isStackEmpty(this.recipe[i])) continue;
                tag = new class_2487();
                tag.method_10543((class_2487)this.recipe[i].method_57358((class_7225.class_7874)registryManager));
                tag.method_10569("Slot", i);
                tagIngredients.add((Object)tag);
            }
            nbt.method_10566("Ingredients", (class_2520)tagIngredients);
        }
        return nbt;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public int getRecipeLength() {
        return this.recipe.length;
    }

    public class_1799[] getRecipeItems() {
        return this.recipe;
    }

    public HashSet<class_1792> getRecipeRemainders() {
        return this.recipeRemainders;
    }

    public boolean isValid() {
        return !InventoryUtils.isStackEmpty(this.getResult());
    }
}

