/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.joml.Matrix4fStack;

public class RenderEventHandler {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final class_310 mc = class_310.method_1551();
    private int recipeListX;
    private int recipeListY;
    private int recipesPerColumn;
    private int columnWidth;
    private int columns;
    private int numberTextWidth;
    private int gapColumn;
    private int entryHeight;
    private double scale;

    public static RenderEventHandler instance() {
        return INSTANCE;
    }

    public void renderRecipeView(class_332 drawContext) {
        if (GuiUtils.getCurrentScreen() instanceof class_465 && InputUtils.isRecipeViewOpen()) {
            class_465 gui = (class_465)GuiUtils.getCurrentScreen();
            RecipeStorage recipes = RecipeStorage.getInstance();
            int first = recipes.getFirstVisibleRecipeId();
            int countPerPage = recipes.getRecipeCountPerPage();
            int lastOnPage = first + countPerPage - 1;
            this.calculateRecipePositions(gui);
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate((float)this.recipeListX, (float)this.recipeListY, 0.0f);
            matrix4fStack.scale((float)this.scale, (float)this.scale, 1.0f);
            String str = StringUtils.translate((String)"itemscroller.gui.label.recipe_page", (Object[])new Object[]{first / countPerPage + 1, recipes.getTotalRecipeCount() / countPerPage});
            drawContext.method_51433(this.mc.field_1772, str, 16, -12, -1061109568, false);
            int i = 0;
            for (int recipeId = first; recipeId <= lastOnPage; ++recipeId) {
                class_1799 stack = recipes.getRecipe(recipeId).getResult();
                boolean selected = recipeId == recipes.getSelection();
                int row = i % this.recipesPerColumn;
                int column = i / this.recipesPerColumn;
                this.renderStoredRecipeStack(stack, recipeId, row, column, gui, selected, drawContext);
                ++i;
            }
            if (Configs.Generic.CRAFTING_RENDER_RECIPE_ITEMS.getBooleanValue()) {
                int mouseY;
                int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
                int recipeId = this.getHoveredRecipeId(mouseX, mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY(), recipes, gui);
                RecipePattern recipe = recipeId >= 0 ? recipes.getRecipe(recipeId) : recipes.getSelectedRecipe();
                this.renderRecipeItems(recipe, recipes.getRecipeCountPerPage(), gui, drawContext);
            }
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.enableBlend();
        }
    }

    public void onDrawScreenPost(class_310 mc, class_332 drawContext) {
        this.renderRecipeView(drawContext);
        if (GuiUtils.getCurrentScreen() instanceof class_465) {
            RecipePattern recipe;
            class_1799 stack;
            class_465 gui = (class_465)this.mc.field_1755;
            if (!InputUtils.isRecipeViewOpen()) {
                return;
            }
            RecipeStorage recipes = RecipeStorage.getInstance();
            int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
            int mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY();
            int recipeId = this.getHoveredRecipeId(mouseX, mouseY, recipes, gui);
            float offset = 300.0f;
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, offset);
            if (recipeId >= 0) {
                RecipePattern recipe2 = recipes.getRecipe(recipeId);
                this.renderHoverTooltip(mouseX, mouseY, recipe2, gui, drawContext);
            } else if (Configs.Generic.CRAFTING_RENDER_RECIPE_ITEMS.getBooleanValue() && !InventoryUtils.isStackEmpty(stack = this.getHoveredRecipeIngredient(mouseX, mouseY, recipe = recipes.getSelectedRecipe(), recipes.getRecipeCountPerPage(), gui))) {
                InventoryOverlay.renderStackToolTip((int)mouseX, (int)mouseY, (class_1799)stack, (class_310)this.mc, (class_332)drawContext);
            }
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private void calculateRecipePositions(class_465<?> gui) {
        RecipeStorage recipes = RecipeStorage.getInstance();
        int gapHorizontal = 2;
        int gapVertical = 2;
        int stackBaseHeight = 16;
        int guiLeft = AccessorUtils.getGuiLeft(gui);
        this.recipesPerColumn = 9;
        this.columns = (int)Math.ceil((double)recipes.getRecipeCountPerPage() / (double)this.recipesPerColumn);
        this.numberTextWidth = 12;
        this.gapColumn = 4;
        int usableHeight = GuiUtils.getScaledWindowHeight();
        int usableWidth = guiLeft;
        double gapScaleVertical = 0.8888888888888888;
        int maxStackDimensionsVertical = (int)((double)usableHeight / ((double)this.recipesPerColumn + 1.2) * gapScaleVertical);
        double gapScaleHorizontal = 0.8888888888888888;
        int maxStackDimensionsHorizontal = (int)((double)(usableWidth - this.columns * (this.numberTextWidth + this.gapColumn)) / ((double)(this.columns + 3) + 0.8) * gapScaleHorizontal);
        int stackDimensions = Math.min(maxStackDimensionsVertical, maxStackDimensionsHorizontal);
        this.scale = (double)stackDimensions / 16.0;
        this.entryHeight = 18;
        this.recipeListX = guiLeft - (int)((double)(this.columns * (16 + this.numberTextWidth + this.gapColumn) + 2) * this.scale);
        this.recipeListY = (int)((double)this.entryHeight * this.scale);
        this.columnWidth = 16 + this.numberTextWidth + this.gapColumn;
    }

    private void renderHoverTooltip(int mouseX, int mouseY, RecipePattern recipe, class_465<?> gui, class_332 drawContext) {
        class_1799 stack = recipe.getResult();
        if (!InventoryUtils.isStackEmpty(stack)) {
            InventoryOverlay.renderStackToolTip((int)mouseX, (int)mouseY, (class_1799)stack, (class_310)this.mc, (class_332)drawContext);
        }
    }

    public int getHoveredRecipeId(int mouseX, int mouseY, RecipeStorage recipes, class_465<?> gui) {
        if (InputUtils.isRecipeViewOpen()) {
            this.calculateRecipePositions(gui);
            int stackDimensions = (int)(16.0 * this.scale);
            for (int column = 0; column < this.columns; ++column) {
                int startX = this.recipeListX + (int)((double)(column * this.columnWidth + this.gapColumn + this.numberTextWidth) * this.scale);
                if (mouseX < startX || mouseX > startX + stackDimensions) continue;
                for (int row = 0; row < this.recipesPerColumn; ++row) {
                    int startY = this.recipeListY + (int)((double)(row * this.entryHeight) * this.scale);
                    if (mouseY < startY || mouseY > startY + stackDimensions) continue;
                    return recipes.getFirstVisibleRecipeId() + column * this.recipesPerColumn + row;
                }
            }
        }
        return -1;
    }

    private void renderStoredRecipeStack(class_1799 stack, int recipeId, int row, int column, class_465<?> gui, boolean selected, class_332 drawContext) {
        class_327 font = this.mc.field_1772;
        String indexStr = String.valueOf(recipeId + 1);
        int x = column * this.columnWidth + this.gapColumn + this.numberTextWidth;
        int y = row * this.entryHeight;
        this.renderStackAt(stack, x, y, selected, drawContext);
        float scale = 0.75f;
        x = x - (int)((float)font.method_1727(indexStr) * scale) - 2;
        int n = row * this.entryHeight + this.entryHeight / 2;
        Objects.requireNonNull(font);
        y = n - 9 / 2;
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 0.0f);
        matrixStack.method_22905(scale, scale, 1.0f);
        drawContext.method_51433(font, indexStr, 0, 0, -4144960, false);
        matrixStack.method_22909();
    }

    private void renderRecipeItems(RecipePattern recipe, int recipeCountPerPage, class_465<?> gui, class_332 drawContext) {
        class_1799[] items = recipe.getRecipeItems();
        int recipeDimensions = (int)Math.ceil(Math.sqrt(recipe.getRecipeLength()));
        int x = -49;
        int y = 3 * this.entryHeight;
        int i = 0;
        for (int row = 0; row < recipeDimensions; ++row) {
            int col = 0;
            while (col < recipeDimensions) {
                int xOff = col * 17;
                int yOff = row * 17;
                this.renderStackAt(items[i], x + xOff, y + yOff, false, drawContext);
                ++col;
                ++i;
            }
        }
    }

    private class_1799 getHoveredRecipeIngredient(int mouseX, int mouseY, RecipePattern recipe, int recipeCountPerPage, class_465<?> gui) {
        int recipeDimensions = (int)Math.ceil(Math.sqrt(recipe.getRecipeLength()));
        int scaledStackDimensions = (int)(16.0 * this.scale);
        int scaledGridEntry = (int)(17.0 * this.scale);
        int x = this.recipeListX - (int)(49.0 * this.scale);
        int y = this.recipeListY + (int)((double)(3 * this.entryHeight) * this.scale);
        if (mouseX >= x && mouseX <= x + recipeDimensions * scaledGridEntry && mouseY >= y && mouseY <= y + recipeDimensions * scaledGridEntry) {
            int i = 0;
            for (int row = 0; row < recipeDimensions; ++row) {
                int col = 0;
                while (col < recipeDimensions) {
                    int xOff = col * scaledGridEntry;
                    int yOff = row * scaledGridEntry;
                    int xStart = x + xOff;
                    int yStart = y + yOff;
                    if (mouseX >= xStart && mouseX < xStart + scaledStackDimensions && mouseY >= yStart && mouseY < yStart + scaledStackDimensions) {
                        return recipe.getRecipeItems()[i];
                    }
                    ++col;
                    ++i;
                }
            }
        }
        return class_1799.field_8037;
    }

    private void renderStackAt(class_1799 stack, int x, int y, boolean border, class_332 drawContext) {
        int w = 16;
        if (border) {
            RenderUtils.drawOutline((int)(x - 1), (int)(y - 1), (int)18, (int)18, (int)-1);
        }
        RenderUtils.drawRect((int)x, (int)y, (int)16, (int)16, (int)0x20FFFFFF);
        if (!InventoryUtils.isStackEmpty(stack)) {
            class_308.method_24211();
            stack = stack.method_7972();
            InventoryUtils.setStackSize(stack, 1);
            class_4587 matrixStack = drawContext.method_51448();
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.0f, 100.0f);
            drawContext.method_51427(stack, x, y);
            matrixStack.method_22909();
        }
    }
}

