/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget.config;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5684;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;

public class ListWidget
extends class_362
implements class_4068,
class_6379 {
    protected final class_310 client;
    private final List<Entry> children = Lists.newArrayList();
    protected int width;
    protected int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    private double scrollAmount;
    private boolean renderSelection = true;
    private boolean scrolling;
    private Entry selected;
    private Entry hoveredEntry;
    public int padding = 4;

    public ListWidget(class_310 client, int width, int height, int top, int bottom) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    public int getRowWidth() {
        return Math.min(400, this.width - 60);
    }

    public int getLogicalHeight() {
        return this.bottom - this.top;
    }

    @Nullable
    public Entry getSelectedOrNull() {
        return this.selected;
    }

    public void setSelected(@Nullable Entry entry) {
        this.selected = entry;
    }

    public final List<Entry> method_25396() {
        return this.children;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<Entry> newEntries) {
        this.children.clear();
        this.children.addAll(newEntries);
    }

    protected Entry getEntry(int index) {
        return this.method_25396().get(index);
    }

    public int addEntry(Entry entry) {
        this.children.add(entry);
        entry.parentList = this;
        return this.children.size() - 1;
    }

    protected int getEntryCount() {
        return this.method_25396().size();
    }

    protected boolean isSelectedEntry(int index) {
        return Objects.equals((Object)this.getSelectedOrNull(), (Object)this.method_25396().get(index));
    }

    @Nullable
    protected final Entry getEntryAtPosition(double x, double y) {
        int rowWidth = this.getRowWidth() / 2;
        int mid = this.left + this.width / 2;
        int rowLeft = mid - rowWidth;
        int rowRight = mid + rowWidth;
        int m = class_3532.method_15357((double)(y - (double)this.top)) + (int)this.getScrollAmount() - 4;
        if (x < (double)this.getScrollbarPositionX() && x >= (double)rowLeft && x <= (double)rowRight && m >= 0) {
            int h = 0;
            for (int i = 0; i < this.getEntryCount(); ++i) {
                int eh = this.getEntryHeight(i);
                if (m >= h && m < h + eh - this.padding) {
                    return this.getEntry(i);
                }
                h += eh;
            }
        }
        return null;
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    protected int getMaxPosition() {
        return this.getTotalHeight();
    }

    public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
        int i = this.getScrollbarPositionX();
        int j = i + 6;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        RenderSystem.setShader(class_757::method_34543);
        this.hoveredEntry = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_49511);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_22912((float)this.left, (float)this.bottom, 0.0f).method_22913((float)this.left / 32.0f, (float)(this.bottom + (int)this.getScrollAmount()) / 32.0f).method_1336(32, 32, 32, 255);
        bufferBuilder.method_22912((float)this.right, (float)this.bottom, 0.0f).method_22913((float)this.right / 32.0f, (float)(this.bottom + (int)this.getScrollAmount()) / 32.0f).method_1336(32, 32, 32, 255);
        bufferBuilder.method_22912((float)this.right, (float)this.top, 0.0f).method_22913((float)this.right / 32.0f, (float)(this.top + (int)this.getScrollAmount()) / 32.0f).method_1336(32, 32, 32, 255);
        bufferBuilder.method_22912((float)this.left, (float)this.top, 0.0f).method_22913((float)this.left / 32.0f, (float)(this.top + (int)this.getScrollAmount()) / 32.0f).method_1336(32, 32, 32, 255);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        int k = this.getRowLeft();
        int l = this.top + 4 - (int)this.getScrollAmount();
        this.renderList(draw, k, l, mouseX, mouseY, delta);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_49511);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912((float)this.left, (float)this.top, -100.0f).method_22913(0.0f, (float)this.top / 32.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)(this.left + this.width), (float)this.top, -100.0f).method_22913((float)this.width / 32.0f, (float)this.top / 32.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)(this.left + this.width), 0.0f, -100.0f).method_22913((float)this.width / 32.0f, 0.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)this.left, 0.0f, -100.0f).method_22913(0.0f, 0.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)this.left, (float)this.height, -100.0f).method_22913(0.0f, (float)this.height / 32.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)(this.left + this.width), (float)this.height, -100.0f).method_22913((float)this.width / 32.0f, (float)this.height / 32.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)(this.left + this.width), (float)this.bottom, -100.0f).method_22913((float)this.width / 32.0f, (float)this.bottom / 32.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)this.left, (float)this.bottom, -100.0f).method_22913(0.0f, (float)this.bottom / 32.0f).method_1336(64, 64, 64, 255);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader(class_757::method_34540);
        int n = 4;
        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912((float)this.left, (float)(this.top + 4), 0.0f).method_1336(0, 0, 0, 0);
        bufferBuilder.method_22912((float)this.right, (float)(this.top + 4), 0.0f).method_1336(0, 0, 0, 0);
        bufferBuilder.method_22912((float)this.right, (float)this.top, 0.0f).method_1336(0, 0, 0, 255);
        bufferBuilder.method_22912((float)this.left, (float)this.top, 0.0f).method_1336(0, 0, 0, 255);
        bufferBuilder.method_22912((float)this.left, (float)this.bottom, 0.0f).method_1336(0, 0, 0, 255);
        bufferBuilder.method_22912((float)this.right, (float)this.bottom, 0.0f).method_1336(0, 0, 0, 255);
        bufferBuilder.method_22912((float)this.right, (float)(this.bottom - 4), 0.0f).method_1336(0, 0, 0, 0);
        bufferBuilder.method_22912((float)this.left, (float)(this.bottom - 4), 0.0f).method_1336(0, 0, 0, 0);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        int o = this.getMaxScroll();
        if (o > 0) {
            RenderSystem.setShader(class_757::method_34540);
            int m = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getMaxPosition());
            m = class_3532.method_15340((int)m, (int)32, (int)(this.bottom - this.top - 8));
            n = (int)this.getScrollAmount() * (this.bottom - this.top - m) / o + this.top;
            if (n < this.top) {
                n = this.top;
            }
            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            bufferBuilder.method_22912((float)i, (float)this.bottom, 0.0f).method_1336(0, 0, 0, 255);
            bufferBuilder.method_22912((float)j, (float)this.bottom, 0.0f).method_1336(0, 0, 0, 255);
            bufferBuilder.method_22912((float)j, (float)this.top, 0.0f).method_1336(0, 0, 0, 255);
            bufferBuilder.method_22912((float)i, (float)this.top, 0.0f).method_1336(0, 0, 0, 255);
            bufferBuilder.method_22912((float)i, (float)(n + m), 0.0f).method_1336(128, 128, 128, 255);
            bufferBuilder.method_22912((float)j, (float)(n + m), 0.0f).method_1336(128, 128, 128, 255);
            bufferBuilder.method_22912((float)j, (float)n, 0.0f).method_1336(128, 128, 128, 255);
            bufferBuilder.method_22912((float)i, (float)n, 0.0f).method_1336(128, 128, 128, 255);
            bufferBuilder.method_22912((float)i, (float)(n + m - 1), 0.0f).method_1336(192, 192, 192, 255);
            bufferBuilder.method_22912((float)(j - 1), (float)(n + m - 1), 0.0f).method_1336(192, 192, 192, 255);
            bufferBuilder.method_22912((float)(j - 1), (float)n, 0.0f).method_1336(192, 192, 192, 255);
            bufferBuilder.method_22912((float)i, (float)n, 0.0f).method_1336(192, 192, 192, 255);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
        RenderSystem.disableBlend();
    }

    public void centerScrollOn(Entry entry) {
        int i = 0;
        for (Entry e : this.method_25396()) {
            if (e == entry) {
                this.setScrollAmount(i - 42);
                return;
            }
            i += this.getEntryHeight(e);
        }
    }

    protected void ensureVisible(Entry entry) {
        int i = this.getRowTop(this.method_25396().indexOf((Object)entry));
        int j = i - this.top - 4 - entry.getHeight();
        int k = this.bottom - i - entry.getHeight() * 2;
        if (j < 0) {
            this.scroll(j);
        }
        if (k < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int amount) {
        this.setScrollAmount(this.getScrollAmount() + (double)amount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4) + 40);
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX() && mouseX < (double)(this.getScrollbarPositionX() + 6);
    }

    protected int getScrollbarPositionX() {
        return this.width - 6;
    }

    public void unfocusTextField() {
        for (Entry e : this.children) {
            for (class_364 el : e.method_25396()) {
                if (!(el instanceof class_342)) continue;
                class_342 tfw = (class_342)el;
                EmiPort.focus(tfw, false);
            }
        }
    }

    public class_342 getFocusedTextField() {
        for (Entry e : this.children) {
            for (class_364 el : e.method_25396()) {
                class_342 tfw;
                if (!(el instanceof class_342) || !(tfw = (class_342)el).method_25370()) continue;
                return tfw;
            }
        }
        return null;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        this.unfocusTextField();
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        Entry entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)entry);
            this.method_25398(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null) {
            this.method_25399().method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button != 0 || !this.scrolling) {
            return false;
        }
        if (mouseY < (double)this.top) {
            this.setScrollAmount(0.0);
        } else if (mouseY > (double)this.bottom) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            double d = Math.max(1, this.getMaxScroll());
            int i = this.bottom - this.top;
            int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
            double e = Math.max(1.0, d / (double)(i - j));
            this.setScrollAmount(this.getScrollAmount() + deltaY * e);
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double amount) {
        this.setScrollAmount(this.getScrollAmount() - amount * 22.0);
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void moveSelection(MoveDirection direction) {
        this.moveSelectionIf(direction, entry -> true);
    }

    protected void ensureSelectedEntryVisible() {
        Entry entry = this.getSelectedOrNull();
        if (entry != null) {
            this.setSelected(entry);
            this.ensureVisible(entry);
        }
    }

    protected void moveSelectionIf(MoveDirection direction, Predicate<Entry> predicate) {
        int i;
        int n = i = direction == MoveDirection.UP ? -1 : 1;
        if (!this.method_25396().isEmpty()) {
            int k;
            int j = this.method_25396().indexOf((Object)this.getSelectedOrNull());
            while (j != (k = class_3532.method_15340((int)(j + i), (int)0, (int)(this.getEntryCount() - 1)))) {
                Entry entry = this.method_25396().get(k);
                if (predicate.test(entry)) {
                    this.setSelected(entry);
                    this.ensureVisible(entry);
                    break;
                }
                j = k;
            }
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom && mouseX >= (double)this.left && mouseX <= (double)this.right;
    }

    protected void renderList(class_332 draw, int x, int y, int mouseX, int mouseY, float delta) {
        int i = this.getEntryCount();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        for (int j = 0; j < i; ++j) {
            int p;
            int k = this.getRowTop(j);
            int l = this.getRowBottom(j);
            if (l < this.top || k > this.bottom) continue;
            int m = k;
            int n = this.getEntryHeight(j);
            if (n == 0) continue;
            n -= 4;
            Entry entry = this.getEntry(j);
            int o = this.getRowWidth();
            if (this.renderSelection && this.isSelectedEntry(j)) {
                p = this.left + this.width / 2 - o / 2;
                int q = this.left + this.width / 2 + o / 2;
                RenderSystem.setShader(class_757::method_34539);
                float f = this.method_25370() ? 1.0f : 0.5f;
                RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)1.0f);
                bufferBuilder.method_22912((float)p, (float)(m + n + 2), 0.0f);
                bufferBuilder.method_22912((float)q, (float)(m + n + 2), 0.0f);
                bufferBuilder.method_22912((float)q, (float)(m - 2), 0.0f);
                bufferBuilder.method_22912((float)p, (float)(m - 2), 0.0f);
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                bufferBuilder.method_22912((float)(p + 1), (float)(m + n + 1), 0.0f);
                bufferBuilder.method_22912((float)(q - 1), (float)(m + n + 1), 0.0f);
                bufferBuilder.method_22912((float)(q - 1), (float)(m - 1), 0.0f);
                bufferBuilder.method_22912((float)(p + 1), (float)(m - 1), 0.0f);
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
            }
            p = this.getRowLeft();
            entry.render(draw, j, k, p, o - 3, n, mouseX, mouseY, Objects.equals((Object)this.hoveredEntry, (Object)entry), delta);
        }
    }

    public int getRowLeft() {
        return this.left + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    private int getEntryHeight(int i) {
        return this.getEntryHeight(this.getEntry(i));
    }

    private int getEntryHeight(Entry entry) {
        int h = entry.getHeight();
        if (h == 0) {
            return 0;
        }
        return h + this.padding;
    }

    protected int getRowTop(int index) {
        int height = 0;
        for (int i = 0; i < index; ++i) {
            height += this.getEntryHeight(i);
        }
        return this.top + 4 - (int)this.getScrollAmount() + height;
    }

    private int getRowBottom(int index) {
        return this.getRowTop(index) + this.getEntry(index).getHeight();
    }

    public boolean method_25370() {
        return false;
    }

    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        if (this.hoveredEntry != null) {
            return class_6379.class_6380.field_33785;
        }
        return class_6379.class_6380.field_33784;
    }

    @Nullable
    public Entry getHoveredEntry() {
        return this.hoveredEntry;
    }

    void setEntryParentList(Entry entry) {
        entry.parentList = this;
    }

    protected void appendNarrations(class_6382 builder, Entry entry) {
        int i;
        List<Entry> list = this.method_25396();
        if (list.size() > 1 && (i = list.indexOf((Object)entry)) != -1) {
            builder.method_37034(class_6381.field_33789, (class_2561)EmiPort.translatable("narrator.position.list", i + 1, list.size()));
        }
    }

    public int getTotalHeight() {
        int height = 0;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            height += this.getEntryHeight(i);
        }
        if (height > 0) {
            height -= this.padding;
        }
        return height;
    }

    public void method_37020(class_6382 var1) {
    }

    public static abstract class Entry
    extends class_362 {
        public ListWidget parentList;

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean method_25405(double mouseX, double mouseY) {
            return Objects.equals((Object)this.parentList.getEntryAtPosition(mouseX, mouseY), (Object)this);
        }

        public List<class_5684> getTooltip(int mouseX, int mouseY) {
            return List.of();
        }

        public abstract int getHeight();
    }

    protected static enum MoveDirection {
        UP,
        DOWN;

    }
}

