/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.DrawableWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.dev.EmiDev;
import dev.emi.emi.runtime.dev.RecipeError;
import dev.emi.emi.screen.tooltip.EmiTooltip;
import dev.emi.emi.widget.RecipeBackground;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5684;

public class WidgetGroup
implements WidgetHolder {
    public final EmiRecipe recipe;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final List<Widget> widgets = Lists.newArrayList();

    public WidgetGroup(EmiRecipe recipe, int x, int y, int width, int height) {
        this.recipe = recipe;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (recipe != null) {
            this.widgets.add(new RecipeBackground(-4, -4, width + 8, height + 8));
        }
    }

    public void error(Throwable e) {
        this.widgets.clear();
        this.widgets.add(new RecipeBackground(-4, -4, this.width + 8, this.height + 8));
        this.widgets.add(new TextWidget(EmiPort.ordered((class_2561)EmiPort.translatable("emi.error.recipe.render")), this.width / 2, this.height / 2 - 5, class_124.field_1061.method_532(), true).horizontalAlign(TextWidget.Alignment.CENTER));
        this.widgets.add((Widget)new DrawableWidget(0, 0, this.width, this.height, (raw, mouseX, mouseY, delta) -> {}).tooltip((i, j) -> EmiUtil.getStackTrace(e).stream().map(EmiPort::literal).map(EmiPort::ordered).map(class_5684::method_32662).toList()));
    }

    public void decorateDevMode() {
        ArrayList tooltip;
        EmiRecipeCategory category = this.recipe.getCategory();
        class_2960 cid = category == null ? null : category.getId();
        class_2960 id = this.recipe.getId();
        ArrayList errors = Lists.newArrayList();
        if (id == null) {
            errors.add(new RecipeError(RecipeError.Severity.WARNING, EmiTooltip.splitTranslate("emi.dev.null_recipe_id")));
        } else if (EmiDev.duplicateRecipeIds.contains(id)) {
            tooltip = Lists.newArrayList();
            if (Objects.equals(id.method_12836(), "minecraft") || Objects.equals(id.method_12836(), "emi")) {
                tooltip.addAll(EmiTooltip.splitTranslate("emi.dev.duplicate_vanilla_recipe_id", id));
            } else {
                tooltip.addAll(EmiTooltip.splitTranslate("emi.dev.duplicate_recipe_id", id));
            }
            if (cid != null) {
                Iterator<EmiStack> suggestedPath = cid.method_12832() + "/" + id.method_12836() + "/" + id.method_12832();
                if (EmiApi.getRecipeManager().getRecipe(EmiPort.id(cid.method_12836(), (String)((Object)suggestedPath))) == null) {
                    tooltip.addAll(EmiTooltip.splitTranslate("emi.dev.suggest_id", cid.method_12836(), suggestedPath));
                } else {
                    tooltip.addAll(EmiTooltip.splitTranslate("emi.dev.synthetic_id"));
                }
            } else {
                tooltip.addAll(EmiTooltip.splitTranslate("emi.dev.synthetic_id"));
            }
            errors.add(new RecipeError(RecipeError.Severity.ERROR, tooltip));
        }
        if (this.recipe.getInputs() == null || this.recipe.getOutputs() == null || this.recipe.getCatalysts() == null) {
            errors.add(new RecipeError(RecipeError.Severity.ERROR, EmiTooltip.splitTranslate("emi.dev.null_input_or_output")));
        } else {
            int nullStacks = 0;
            for (EmiIngredient emiIngredient : this.recipe.getInputs()) {
                if (emiIngredient != null) continue;
                ++nullStacks;
            }
            for (EmiIngredient emiIngredient : this.recipe.getCatalysts()) {
                if (emiIngredient != null) continue;
                ++nullStacks;
            }
            for (EmiStack emiStack : this.recipe.getOutputs()) {
                if (emiStack != null) continue;
                ++nullStacks;
            }
            if (nullStacks > 0) {
                errors.add(new RecipeError(RecipeError.Severity.ERROR, EmiTooltip.splitTranslate("emi.dev.null_input_or_output")));
            }
            if (!this.recipe.getOutputs().isEmpty() && this.recipe.supportsRecipeTree()) {
                int recipeContexts = 0;
                for (Widget widget : this.widgets) {
                    SlotWidget sw;
                    if (!(widget instanceof SlotWidget) || (sw = (SlotWidget)widget).getRecipe() == null) continue;
                    ++recipeContexts;
                }
                if (recipeContexts == 0) {
                    errors.add(new RecipeError(RecipeError.Severity.WARNING, EmiTooltip.splitTranslate("emi.dev.no_output_slots")));
                }
            }
        }
        if (!errors.isEmpty()) {
            tooltip = Lists.newArrayList();
            RecipeError.Severity severity = RecipeError.Severity.WARNING;
            for (RecipeError error : errors) {
                if (error.severity() == RecipeError.Severity.ERROR) {
                    severity = RecipeError.Severity.ERROR;
                }
                tooltip.add(switch (error.severity()) {
                    default -> throw new MatchException(null, null);
                    case RecipeError.Severity.ERROR -> EmiTooltipComponents.of((class_2561)EmiPort.translatable("emi.dev.severity.error", class_124.field_1061));
                    case RecipeError.Severity.WARNING -> EmiTooltipComponents.of((class_2561)EmiPort.translatable("emi.dev.severity.warning", class_124.field_1054));
                });
                tooltip.addAll(error.tooltip());
            }
            int n = switch (severity) {
                default -> throw new MatchException(null, null);
                case RecipeError.Severity.ERROR -> -859045888;
                case RecipeError.Severity.WARNING -> -858993664;
            };
            this.addDrawable(0, 0, this.width, this.height, (raw, mouseX, mouseY, delta) -> {
                EmiDrawContext draw = EmiDrawContext.wrap(raw);
                draw.fill(-2, -3, this.width, 2, errorColor);
                draw.fill(-2, this.height + 1, this.width + 4, 2, errorColor);
            });
            this.addText((class_2561)EmiPort.literal("!", class_124.field_1067), this.width, -2, 0xFF000000 | n, true);
            this.addTooltip(tooltip, this.width - 2, -4, 8, 16);
        }
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public <T extends Widget> T add(T widget) {
        this.widgets.add(widget);
        return widget;
    }
}

