/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Consumer;
import me.lucko.fabric.api.permissions.v0.Permissions;
import me.senseiwells.chunkdebug.ChunkDebug;
import me.senseiwells.chunkdebug.common.network.ByePayload;
import me.senseiwells.chunkdebug.common.network.ChunkDataPayload;
import me.senseiwells.chunkdebug.common.network.ChunkUnloadPayload;
import me.senseiwells.chunkdebug.common.network.HelloPayload;
import me.senseiwells.chunkdebug.common.network.StartWatchingPayload;
import me.senseiwells.chunkdebug.common.network.StopWatchingPayload;
import me.senseiwells.chunkdebug.common.utils.ChunkData;
import me.senseiwells.chunkdebug.server.config.ChunkDebugServerConfig;
import me.senseiwells.chunkdebug.server.tracker.ChunkDebugTracker;
import me.senseiwells.chunkdebug.server.tracker.ChunkDebugTrackerHolder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class ChunkDebugServer
implements ModInitializer {
    private static final int PACKET_PARTITION_SIZE = 20000;
    private static ChunkDebugServer instance;
    private final Multimap<class_5321<class_1937>, UUID> watching = HashMultimap.create();
    private final ChunkDebugServerConfig config = ChunkDebugServerConfig.read();

    public static ChunkDebugServer getInstance() {
        return instance;
    }

    public void onInitialize() {
        instance = this;
        ServerTickEvents.END_SERVER_TICK.register(this::sendUpdatesToWatching);
        ServerPlayConnectionEvents.JOIN.register(this::sendHelloPayload);
        ServerPlayNetworking.registerGlobalReceiver(StartWatchingPayload.TYPE, this::handleStartWatching);
        ServerPlayNetworking.registerGlobalReceiver(StopWatchingPayload.TYPE, this::handleStopWatching);
    }

    public boolean isPermitted(class_3222 player) {
        if (player.field_13995.method_3816() && this.config.requirePermissions()) {
            return Permissions.check((class_1297)player, (String)"chunk-debug", (int)2);
        }
        return true;
    }

    @ApiStatus.Internal
    public void onOpPlayer(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2658((class_8710)HelloPayload.INSTANCE));
    }

    @ApiStatus.Internal
    public void onDeOpPlayer(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2658((class_8710)ByePayload.INSTANCE));
    }

    private void sendHelloPayload(class_3244 connection, PacketSender sender, MinecraftServer server) {
        if (this.isPermitted(connection.field_14140)) {
            sender.sendPacket((class_8710)HelloPayload.INSTANCE);
        }
    }

    private void sendUpdatesToWatching(MinecraftServer server) {
        Iterator dimensions = this.watching.keySet().iterator();
        LinkedList<Runnable> tasks = new LinkedList<Runnable>();
        while (dimensions.hasNext()) {
            class_5321 dimension = (class_5321)dimensions.next();
            class_3218 level = server.method_3847(dimension);
            if (level == null) {
                dimensions.remove();
                continue;
            }
            ArrayList<class_3222> players = new ArrayList<class_3222>();
            for (UUID next : this.watching.get((Object)dimension)) {
                class_3222 player = server.method_3760().method_14602(next);
                if (player == null) {
                    tasks.add(() -> this.watching.remove((Object)dimension, (Object)next));
                    continue;
                }
                players.add(player);
            }
            ChunkDebugTracker tracker = ((ChunkDebugTrackerHolder)level).chunkdebug$getTracker();
            ChunkDebugTracker.DirtyChunks dirty = tracker.getDirtyChunks();
            this.partitionInto(dirty.updated(), partition -> {
                ChunkDataPayload payload = new ChunkDataPayload((class_5321<class_1937>)dimension, (Collection<ChunkData>)partition, server.method_3780(), false);
                class_2658 packet = new class_2658((class_8710)payload);
                for (class_3222 player : players) {
                    player.field_13987.method_14364((class_2596)packet);
                }
            });
            if (dirty.removed().isEmpty()) continue;
            ChunkUnloadPayload payload = new ChunkUnloadPayload((class_5321<class_1937>)dimension, dirty.removed().toLongArray());
            class_2658 packet = new class_2658((class_8710)payload);
            for (class_3222 player : players) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
        tasks.forEach(Runnable::run);
    }

    private void handleStartWatching(StartWatchingPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        if (!this.isPermitted(player)) {
            ChunkDebug.LOGGER.warn("Player {} tried to use chunk-debug without permission!", (Object)player.method_5820());
            return;
        }
        MinecraftServer server = context.server();
        int tickCount = server.method_3780();
        for (class_5321<class_1937> dimension : payload.dimensions()) {
            class_3218 level = server.method_3847(dimension);
            if (level == null) {
                ChunkDebug.LOGGER.warn("Player {} requested invalid dimension {}", (Object)player.method_5820(), dimension);
                return;
            }
            if (!this.watching.put(dimension, (Object)player.method_5667())) continue;
            Collection<ChunkData> data = ((ChunkDebugTrackerHolder)level).chunkdebug$getTracker().getChunks();
            this.partitionInto(data, partition -> context.responseSender().sendPacket((class_8710)new ChunkDataPayload(dimension, (Collection<ChunkData>)partition, tickCount, true)));
        }
    }

    private void handleStopWatching(StopWatchingPayload payload, ServerPlayNetworking.Context context) {
        UUID uuid = context.player().method_5667();
        if (payload.dimensions().isEmpty()) {
            for (class_5321 dimension : this.watching.keySet()) {
                this.watching.remove((Object)dimension, (Object)uuid);
            }
            return;
        }
        for (class_5321<class_1937> dimension : payload.dimensions()) {
            this.watching.remove(dimension, (Object)uuid);
        }
    }

    private <T> void partitionInto(Collection<T> data, Consumer<Collection<T>> consumer) {
        if (data.isEmpty()) {
            return;
        }
        if (data.size() < 20000) {
            consumer.accept(data);
            return;
        }
        for (Collection partition : Iterables.partition(data, (int)20000)) {
            consumer.accept(partition);
        }
    }
}

