/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.common.utils;

import java.util.List;
import java.util.Optional;
import me.senseiwells.chunkdebug.ChunkDebug;
import me.senseiwells.chunkdebug.server.mixins.TicketAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2806;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ExtraStreamCodecs {
    public static final class_9139<class_9129, class_5321<class_1937>> DIMENSION = class_9139.method_56437(ExtraStreamCodecs::encodeDimension, ExtraStreamCodecs::decodeDimension);
    public static final class_9139<class_9129, List<class_5321<class_1937>>> DIMENSIONS = class_9135.method_56363().apply(DIMENSION);
    public static final class_9139<class_9129, class_6880<class_2806>> CHUNK_STATUS = class_9135.method_56383((class_5321)class_7924.field_41261);
    public static final class_9139<class_9129, Optional<class_6880<class_2806>>> OPTIONAL_CHUNK_STATUS = class_9135.method_56382(CHUNK_STATUS);
    public static final class_9139<class_2540, class_3228<?>> TICKET = class_9139.method_56437(ExtraStreamCodecs::encodeTicket, ExtraStreamCodecs::decodeTicket);
    public static final class_9139<class_2540, List<class_3228<?>>> TICKETS = class_9135.method_56363().apply(TICKET);
    private static final List<class_3230<?>> TICKET_TYPES = ExtraStreamCodecs.getTicketTypes();

    private static void encodeDimension(class_9129 buf, class_5321<class_1937> dimension) {
        buf.method_44116(dimension);
    }

    private static class_5321<class_1937> decodeDimension(class_9129 buf) {
        return buf.method_44112(class_7924.field_41223);
    }

    private static void encodeTicket(class_2540 buf, class_3228<?> ticket) {
        int index = TICKET_TYPES.indexOf(ticket.method_14281());
        if (index == -1) {
            ChunkDebug.LOGGER.warn("Tried to encode unknown ticket type: {}", (Object)ticket.method_14281());
            index = TICKET_TYPES.size() - 1;
        }
        buf.method_52997(index);
        buf.method_53002((int)((TicketAccessor)ticket).getTickCreated());
        buf.method_53002(ticket.method_14283());
    }

    private static class_3228<?> decodeTicket(class_2540 buf) {
        class_3230<?> type = TICKET_TYPES.get(buf.readByte());
        int tickCreated = buf.readInt();
        int ticketLevel = buf.readInt();
        class_3228<Object> ticket = TicketAccessor.construct(type, ticketLevel, null);
        ((TicketAccessor)ticket).setTickCreated(tickCreated);
        return ticket;
    }

    private static List<class_3230<?>> getTicketTypes() {
        return List.of(class_3230.field_14030, class_3230.field_17264, class_3230.field_14033, class_3230.field_14031, class_3230.field_19280, class_3230.field_19347, class_3230.field_14032);
    }
}

