/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.common.utils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.senseiwells.chunkdebug.common.utils.ExtraStreamCodecs;
import net.minecraft.class_1923;
import net.minecraft.class_2378;
import net.minecraft.class_2806;
import net.minecraft.class_3194;
import net.minecraft.class_3228;
import net.minecraft.class_4706;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8563;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ChunkData {
    public static final class_9139<class_9129, ChunkData> STREAM_CODEC = class_9139.method_56437(ChunkData::encode, ChunkData::decode);
    public static final class_9139<class_9129, Collection<ChunkData>> LIST_STREAM_CODEC = class_9135.method_56376(ArrayList::new, STREAM_CODEC);
    private final class_1923 position;
    private class_2806 stage;
    private List<class_3228<?>> tickets;
    private int statusLevel;
    private int tickingStatusLevel;
    private boolean unloading;

    public ChunkData(class_1923 position, class_2806 stage, class_4706<class_3228<?>> tickets, int statusLevel, int tickingStatusLevel, boolean unloading) {
        this(position, stage, (List<class_3228<?>>)ImmutableList.copyOf(tickets), statusLevel, tickingStatusLevel, unloading);
    }

    public ChunkData(class_1923 position, class_2806 stage, List<class_3228<?>> tickets, int statusLevel, int tickingStatusLevel, boolean unloading) {
        this.position = position;
        this.stage = stage;
        this.tickets = tickets;
        this.statusLevel = statusLevel;
        this.tickingStatusLevel = tickingStatusLevel;
        this.unloading = unloading;
    }

    public class_1923 position() {
        return this.position;
    }

    @Nullable
    public class_2806 stage() {
        return this.stage;
    }

    public List<class_3228<?>> tickets() {
        return this.tickets;
    }

    public int statusLevel() {
        return this.statusLevel;
    }

    public int tickingStatusLevel() {
        return this.tickingStatusLevel;
    }

    public boolean unloading() {
        return this.unloading;
    }

    public void updateStage(class_2806 stage) {
        this.stage = stage;
    }

    public void updateTickets(class_4706<class_3228<?>> tickets) {
        this.tickets = ImmutableList.copyOf(tickets);
    }

    public void updateStatusLevel(int statusLevel) {
        this.statusLevel = statusLevel;
    }

    public void updateTickingStatusLevel(int statusLevel) {
        this.tickingStatusLevel = statusLevel;
    }

    public void updateUnloading(boolean unloading) {
        this.unloading = unloading;
    }

    public class_3194 status() {
        if (this.tickingStatusLevel > this.statusLevel) {
            return class_8563.method_51830((int)this.tickingStatusLevel);
        }
        return class_8563.method_51830((int)this.statusLevel);
    }

    private static void encode(class_9129 buf, ChunkData data) {
        buf.method_36130(data.position);
        buf.method_53002(data.statusLevel);
        buf.method_53002(data.tickingStatusLevel);
        buf.method_52964(data.unloading);
        Optional status = ((class_2378)buf.method_56349().method_33310(class_7924.field_41261).orElse(class_7923.field_41184)).method_29113((Object)data.stage).flatMap(arg_0 -> ((class_7922)class_7923.field_41184).method_40264(arg_0));
        ExtraStreamCodecs.OPTIONAL_CHUNK_STATUS.encode((Object)buf, status);
        ExtraStreamCodecs.TICKETS.encode((Object)buf, data.tickets);
    }

    private static ChunkData decode(class_9129 buf) {
        class_1923 pos = buf.method_36133();
        int statusLevel = buf.readInt();
        int tickingStatusLevel = buf.readInt();
        boolean unloading = buf.readBoolean();
        class_2806 status = ((Optional)ExtraStreamCodecs.OPTIONAL_CHUNK_STATUS.decode((Object)buf)).map(class_6880::comp_349).orElse(null);
        List tickets = (List)ExtraStreamCodecs.TICKETS.decode((Object)buf);
        return new ChunkData(pos, status, tickets, statusLevel, tickingStatusLevel, unloading);
    }
}

