/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.senseiwells.chunkdebug.client.ChunkDebugClient;
import me.senseiwells.chunkdebug.client.gui.ChunkClusters;
import me.senseiwells.chunkdebug.client.gui.ChunkColors;
import me.senseiwells.chunkdebug.client.gui.ChunkSelection;
import me.senseiwells.chunkdebug.client.gui.ChunkSelectionInfo;
import me.senseiwells.chunkdebug.client.gui.widget.ArrowButton;
import me.senseiwells.chunkdebug.client.gui.widget.IntegerEditbox;
import me.senseiwells.chunkdebug.client.gui.widget.NamedButton;
import me.senseiwells.chunkdebug.client.gui.widget.ToggleButton;
import me.senseiwells.chunkdebug.client.utils.RenderUtils;
import me.senseiwells.chunkdebug.common.utils.ChunkData;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3228;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7919;

public class ChunkDebugScreen
extends class_437 {
    private static final int SELECTING_OUTLINE_COLOR = -1431699456;
    private static final int SELECTED_OUTLINE_COLOR = -1426128896;
    private static final int CLUSTER_OUTLINE_COLOR = -932399890;
    private static final int PLAYER_COLOR = -1426063616;
    private static final float MINIMAP_SCALE = 0.5f;
    private static final int MENU_PADDING = 3;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Map<class_5321<class_1937>, DimensionState> states = new Object2ObjectOpenHashMap();
    private final List<class_5321<class_1937>> dimensions = new ArrayList<class_5321<class_1937>>();
    private int dimensionWidth = 0;
    private int dimensionIndex = 0;
    private ChunkSelection clusterSelection;
    private int clusterTicks = 0;
    private int clusterIndex = 0;
    private class_1923 center = class_1923.field_35107;
    private Minimap minimap = Minimap.NONE;
    private ToggleButton breakdown;
    private ToggleButton settings;
    private ArrowButton dimensionLeft;
    private ArrowButton dimensionRight;
    private ArrowButton minimapLeft;
    private ArrowButton minimapRight;
    private NamedButton returnToPlayer;
    private ArrowButton clustersLeft;
    private ArrowButton clustersRight;
    private IntegerEditbox chunkPosX;
    private IntegerEditbox chunkPosZ;
    private ToggleButton showStages;
    private ToggleButton showTickets;
    private ToggleButton showMinimap;
    private IntegerEditbox chunkRetention;
    private boolean initialized = false;
    private int ticks = 0;

    public ChunkDebugScreen() {
        super((class_2561)class_2561.method_43471((String)"chunk-debug.screen.title"));
    }

    public void updateChunks(class_5321<class_1937> dimension, Collection<ChunkData> chunks) {
        DimensionState state = this.state(dimension);
        for (ChunkData chunk : chunks) {
            state.add(chunk.position().method_8324(), chunk);
        }
    }

    public void unloadChunks(class_5321<class_1937> dimension, long[] positions) {
        DimensionState state = this.state(dimension);
        for (long position : positions) {
            state.remove(position, this.ticks + this.chunkRetention.getIntValue());
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.initialized = true;
        this.breakdown = new ToggleButton(this.field_22789 - 20, this.field_22790 - 20, 15);
        this.breakdown.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chunk-debug.info.breakdown.toggle")));
        this.breakdown.setToggled(true);
        this.method_37063((class_364)this.breakdown);
        this.settings = new ToggleButton(5, this.field_22790 - 20, 15);
        this.settings.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chunk-debug.settings.toggle")));
        this.settings.setToggled(true);
        this.method_37063((class_364)this.settings);
        this.dimensionLeft = new ArrowButton(ArrowButton.Direction.LEFT, 9, 0, 15, () -> this.incrementDimension(-1));
        this.method_37063((class_364)this.dimensionLeft);
        this.dimensionRight = new ArrowButton(ArrowButton.Direction.RIGHT, 0, 0, 15, () -> this.incrementDimension(1));
        this.method_37063((class_364)this.dimensionRight);
        this.minimapLeft = new ArrowButton(ArrowButton.Direction.LEFT, 0, 0, 15, () -> {
            this.minimap = this.minimap.previous();
        });
        this.method_37063((class_364)this.minimapLeft);
        this.minimapRight = new ArrowButton(ArrowButton.Direction.RIGHT, 0, 0, 15, () -> {
            this.minimap = this.minimap.next();
        });
        this.method_37063((class_364)this.minimapRight);
        class_5250 player = class_2561.method_43471((String)"chunk-debug.settings.return");
        this.returnToPlayer = new NamedButton(0, 0, 0, 15, (class_2561)player, () -> {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.dimensionIndex = this.dimensions.indexOf(this.field_22787.field_1724.method_37908().method_27983());
                this.setMapCenter(this.field_22787.field_1724.method_31476());
            }
        });
        this.method_37063((class_364)this.returnToPlayer);
        this.clustersLeft = new ArrowButton(ArrowButton.Direction.LEFT, 0, 0, 15, () -> this.jumpToCluster(-1));
        this.method_37063((class_364)this.clustersLeft);
        this.clustersRight = new ArrowButton(ArrowButton.Direction.RIGHT, 0, 0, 15, () -> this.jumpToCluster(1));
        this.method_37063((class_364)this.clustersRight);
        this.chunkPosX = new IntegerEditbox(this.field_22793, 40, 15, x -> this.setMapCenter(x, this.center.field_9180));
        this.method_37063((class_364)this.chunkPosX);
        this.chunkPosZ = new IntegerEditbox(this.field_22793, 40, 15, z -> this.setMapCenter(this.center.field_9181, z));
        this.method_37063((class_364)this.chunkPosZ);
        this.showStages = new ToggleButton(0, 0, 15);
        this.showStages.setToggled(true);
        this.method_37063((class_364)this.showStages);
        this.showTickets = new ToggleButton(0, 0, 15);
        this.showTickets.setToggled(true);
        this.method_37063((class_364)this.showTickets);
        this.showMinimap = new ToggleButton(0, 0, 15);
        this.showMinimap.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chunk-debug.settings.visibility.minimap.tooltip")));
        this.method_37063((class_364)this.showMinimap);
        this.chunkRetention = new IntegerEditbox(this.field_22793, 30, 15, i -> {});
        this.chunkRetention.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chunk-debug.settings.visibility.unload.tooltip")));
        this.method_37063((class_364)this.chunkRetention);
    }

    public void method_25393() {
        if (this.clusterTicks > 0) {
            --this.clusterTicks;
        } else {
            this.clusterSelection = null;
        }
    }

    public void clientTick() {
        int tick = ++this.ticks;
        for (DimensionState state : this.states.values()) {
            state.unloaded.removeAll((Object)tick);
        }
    }

    protected void method_48640() {
        this.breakdown.method_48229(this.field_22789 - 20, this.field_22790 - 20);
        this.settings.method_46419(this.field_22790 - 20);
    }

    public void method_49589() {
        ChunkDebugClient.getInstance().startWatching(this.dimension());
    }

    public void method_25432() {
        if (this.minimap == Minimap.NONE) {
            ChunkDebugClient.getInstance().stopWatching();
            this.states.clear();
        }
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {
        this.method_57734(partial);
        DimensionState state = this.state();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(state.offsetX, state.offsetY, 0.0);
        graphics.method_51448().method_22905(state.scale, state.scale, 0.0f);
        this.renderChunkDebugMap(graphics, state);
        if (state.first != null) {
            ChunkSelection selection = new ChunkSelection(state.first, this.convertScreenToChunkPos(mouseX, mouseY));
            this.renderChunkSelection(graphics, selection, -1431699456);
        }
        if (this.clusterSelection != null) {
            this.renderChunkSelection(graphics, this.clusterSelection, 2.0f, -932399890);
        }
        graphics.method_51448().method_22909();
        if (this.showMinimap.isToggled()) {
            this.renderMinimap(graphics);
        }
        this.renderChunkSelectionMenu(graphics, state);
        this.renderSettingsMenu(graphics);
        this.center = this.convertScreenToChunkPos((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0);
        if (!this.chunkPosX.method_25370()) {
            this.chunkPosX.setIntValue(this.center.field_9181);
        }
        if (!this.chunkPosZ.method_25370()) {
            this.chunkPosZ.setIntValue(this.center.field_9180);
        }
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 290) {
            boolean visible = this.settings.isToggled() || this.breakdown.isToggled();
            this.settings.setToggled(!visible);
            this.breakdown.setToggled(!visible);
            return true;
        }
        if (this.field_22787 != null && ChunkDebugClient.getInstance().keybind.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        this.chunkPosX.method_25365(false);
        this.chunkPosZ.method_25365(false);
        this.chunkRetention.method_25365(false);
        if (button == 1) {
            DimensionState state = this.state();
            state.first = this.convertScreenToChunkPos(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        DimensionState state = this.state();
        if (state.first != null && button == 1) {
            ChunkSelection selection = new ChunkSelection(state.first, this.convertScreenToChunkPos(mouseX, mouseY));
            state.first = null;
            state.selection = selection.equals(state.selection) ? null : selection;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        DimensionState state = this.state();
        if (button == 0) {
            state.offsetX += dragX;
            state.offsetY += dragY;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        DimensionState state = this.state();
        double currentX = (mouseX - state.offsetX) / (double)state.scale;
        double currentY = (mouseY - state.offsetY) / (double)state.scale;
        state.scale = class_3532.method_15363((float)(state.scale + (float)scrollY * 0.5f), (float)1.0f, (float)64.0f);
        state.offsetX = mouseX - currentX * (double)state.scale;
        state.offsetY = mouseY - currentY * (double)state.scale;
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        if (!this.initialized) {
            return;
        }
        DimensionState state = this.state();
        double oldCenterX = (double)this.field_22789 / 2.0;
        double oldCenterY = (double)this.field_22790 / 2.0;
        double currentX = (oldCenterX - state.offsetX) / (double)state.scale;
        double currentY = (oldCenterY - state.offsetY) / (double)state.scale;
        super.method_25410(minecraft, width, height);
        double newCenterX = (double)width / 2.0;
        double newCenterY = (double)height / 2.0;
        state.offsetX = newCenterX - currentX * (double)state.scale;
        state.offsetY = newCenterY - currentY * (double)state.scale;
    }

    public void renderMinimap(class_332 graphics) {
        DimensionState state;
        if (this.minimap == Minimap.NONE || this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        int size = 100;
        int padding = 10;
        int minX = this.field_22789 - size - padding;
        int minY = padding + 1 - 1;
        int maxX = this.field_22789 - padding;
        int maxY = size + padding;
        graphics.method_51448().method_22903();
        graphics.method_25294(minX - 3, minY - 3, maxX + 3, maxY + 3, -936035512);
        graphics.method_25294(minX, minY, maxX, maxY, -936561610);
        graphics.method_44379(minX, minY, maxX, maxY);
        graphics.method_51448().method_22904((double)minX + (double)size / 2.0, (double)minY + (double)size / 2.0, 0.0);
        if (this.minimap == Minimap.STATIC) {
            state = this.state();
            double offsetX = ((double)this.field_22789 / 2.0 - state.offsetX) / (double)state.scale;
            double offsetY = ((double)this.field_22790 / 2.0 - state.offsetY) / (double)state.scale;
            graphics.method_51448().method_22905(state.scale * 0.5f, state.scale * 0.5f, 0.0f);
            graphics.method_51448().method_22904(-offsetX, -offsetY, 0.0);
        } else {
            class_746 player = this.field_22787.field_1724;
            class_5321 dimension = player.method_37908().method_27983();
            state = this.state((class_5321<class_1937>)dimension);
            class_1923 pos = player.method_31476();
            graphics.method_51448().method_22905(state.scale * 0.5f, state.scale * 0.5f, 0.0f);
            graphics.method_51448().method_22904((double)(-pos.field_9181) - 0.5, (double)(-pos.field_9180) - 0.5, 0.0);
        }
        this.renderChunkDebugMap(graphics, state);
        graphics.method_44380();
        graphics.method_51448().method_22909();
    }

    private void renderChunkDebugMap(class_332 graphics, DimensionState state) {
        graphics.method_51741(() -> {
            for (ChunkData data : state.chunks.values()) {
                class_1923 pos = data.position();
                int color = this.calculateChunkColor(data);
                graphics.method_25294(pos.field_9181, pos.field_9180, pos.field_9181 + 1, pos.field_9180 + 1, color);
            }
            int ticks = this.chunkRetention.getIntValue();
            if (ticks > 0) {
                for (Map.Entry entry : state.unloaded.entries()) {
                    float delta = (float)((Integer)entry.getKey() - this.ticks) / (float)ticks;
                    int alpha = (byte)(delta * 255.0f) << 24 | 0xFFFFFF;
                    ChunkData data = (ChunkData)entry.getValue();
                    class_1923 pos = data.position();
                    int color = this.calculateChunkColor(data) & alpha;
                    graphics.method_25294(pos.field_9181, pos.field_9180, pos.field_9181 + 1, pos.field_9180 + 1, color);
                }
            }
        });
        if (state.selection != null) {
            this.renderChunkSelection(graphics, state.selection, -1426128896);
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.field_22787.field_1724.method_37908().method_27983() == state.dimension) {
            this.renderPlayer(graphics, this.field_22787.field_1724.method_31476());
        }
    }

    private void renderSettingsMenu(class_332 graphics) {
        RenderUtils.setVisible(this.settings.isToggled(), new class_339[]{this.dimensionLeft, this.dimensionRight, this.minimapLeft, this.minimapRight, this.clustersLeft, this.clustersRight, this.returnToPlayer, this.showMinimap, this.showStages, this.showTickets, this.chunkPosX, this.chunkPosZ, this.chunkRetention});
        if (!this.settings.isToggled()) {
            return;
        }
        graphics.method_51448().method_22903();
        class_5250 title = class_2561.method_43471((String)"chunk-debug.settings").method_54663(-932399890);
        class_5250 player = class_2561.method_43471((String)"chunk-debug.settings.return");
        class_5250 clusters = class_2561.method_43471((String)"chunk-debug.settings.clusters");
        class_5250 stages = class_2561.method_43471((String)"chunk-debug.settings.visibility.stages");
        class_5250 tickets = class_2561.method_43471((String)"chunk-debug.settings.visibility.tickets");
        class_5250 minimap = class_2561.method_43471((String)"chunk-debug.settings.visibility.minimap");
        class_5250 fade = class_2561.method_43471((String)"chunk-debug.settings.visibility.unload");
        int padding = 3;
        int width = Math.max(this.dimensionWidth, RenderUtils.maxWidth(this.field_22793, (class_2561)clusters, new class_2561[]{minimap})) + 2 * padding + 30;
        width = Math.max(width, RenderUtils.maxWidth(this.field_22793, (class_2561)title, new class_2561[]{player}));
        width = Math.max(width, RenderUtils.maxWidth(this.field_22793, (class_2561)stages, new class_2561[]{tickets, fade}) + padding + 15);
        int minX = padding + 1 - 1;
        int minY = padding + 1 - 1;
        int maxX = padding + (width += 4 * padding);
        int maxY = this.field_22790 - padding;
        int centerX = (maxX + minX) / 2;
        graphics.method_25294(minX, minY, maxX, maxY, -936035512);
        graphics.method_27535(this.field_22793, (class_2561)title, minX + padding, minY + padding, -1);
        Objects.requireNonNull(this.field_22793);
        int offsetY = minY + padding * 2 + 9;
        int gap = 2 * padding + 15;
        class_2561 mode = this.minimap.pretty();
        RenderUtils.options(graphics, this.field_22793, minX, maxX, offsetY, padding, mode, this.minimapLeft, this.minimapRight);
        class_5250 dimension = class_2561.method_43470((String)this.dimension().method_29177().toString());
        RenderUtils.options(graphics, this.field_22793, minX, maxX, offsetY += gap + 3, padding, (class_2561)dimension, this.dimensionLeft, this.dimensionRight);
        RenderUtils.options(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)clusters, this.clustersLeft, this.clustersRight);
        class_5250 x = class_2561.method_43470((String)"X");
        class_5250 z = class_2561.method_43470((String)"Z");
        this.chunkPosX.method_25358(centerX - minX - 5 * padding - this.field_22793.method_27525((class_5348)x) + 2);
        this.chunkPosZ.method_25358(maxX - centerX - 5 * padding - this.field_22793.method_27525((class_5348)z) + 2);
        RenderUtils.optionRight(graphics, this.field_22793, minX, centerX + padding / 2, offsetY += gap, padding, (class_2561)x, (class_339)this.chunkPosX);
        RenderUtils.optionRight(graphics, this.field_22793, centerX - padding / 2, maxX, offsetY, padding, (class_2561)z, (class_339)this.chunkPosZ);
        this.returnToPlayer.method_48229(minX + padding, offsetY += gap);
        this.returnToPlayer.method_25358(maxX - minX - 2 * padding);
        RenderUtils.optionLeft(graphics, this.field_22793, minX, maxX, offsetY += gap + 3, padding, (class_2561)stages, (class_339)this.showStages);
        RenderUtils.optionLeft(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)tickets, (class_339)this.showTickets);
        RenderUtils.optionLeft(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)minimap, (class_339)this.showMinimap);
        RenderUtils.optionLeft(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)fade, (class_339)this.chunkRetention);
        graphics.method_51448().method_22909();
    }

    private void renderChunkSelectionMenu(class_332 graphics, DimensionState state) {
        boolean bl = this.breakdown.field_22764 = state.selection != null;
        if (!this.breakdown.field_22764 || !this.breakdown.isToggled()) {
            return;
        }
        graphics.method_51448().method_22903();
        ChunkSelectionInfo info = ChunkSelectionInfo.create(state.selection, state.chunks);
        int padding = 3;
        int width = info.getMaxWidth(this.field_22793) + 4 * padding;
        int minX = this.field_22789 - width - padding;
        int minY = padding + 1 - 1;
        int maxX = this.field_22789 - padding;
        int maxY = this.field_22790 - padding;
        graphics.method_25294(minX, minY, maxX, maxY, -936035512);
        graphics.method_27535(this.field_22793, info.title(), minX + padding, minY + padding, -1);
        minX += padding;
        maxX -= padding;
        int offsetY = minY + padding * 2;
        for (List<class_2561> section : info.sections()) {
            offsetY = this.renderInnerChunkSelectionInfo(graphics, section, padding, minX, maxX, offsetY);
        }
        graphics.method_51448().method_22909();
    }

    private int renderInnerChunkSelectionInfo(class_332 graphics, List<class_2561> lines, int padding, int minX, int maxX, int offsetY) {
        if (lines.isEmpty()) {
            return offsetY;
        }
        Objects.requireNonNull(this.field_22793);
        int increment = 9 + padding;
        int maxY = offsetY + increment * (lines.size() + 1);
        graphics.method_25294(minX, offsetY + increment - padding, maxX, maxY, 0x55000000);
        for (class_2561 line : lines) {
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, line, minX + padding, offsetY += 9 + padding, -1);
        }
        return maxY - padding;
    }

    private void renderChunkSelection(class_332 graphics, ChunkSelection selection, int color) {
        this.renderChunkSelection(graphics, selection, 0.3f, color);
    }

    private void renderChunkSelection(class_332 graphics, ChunkSelection selection, float thickness, int color) {
        RenderUtils.outline(graphics, selection.minX, selection.minZ, selection.sizeX(), selection.sizeZ(), thickness, color);
    }

    private void renderPlayer(class_332 graphics, class_1923 pos) {
        RenderUtils.outline(graphics, pos.field_9181, pos.field_9180, 1.0f, 1.0f, 0.3f, -1426063616);
    }

    private DimensionState state() {
        return this.state(this.dimension());
    }

    private DimensionState state(class_5321<class_1937> dimension) {
        return this.states.computeIfAbsent(dimension, dim -> {
            DimensionState state = new DimensionState((class_5321<class_1937>)dim, this.executor);
            this.initializeState(state);
            return state;
        });
    }

    private void jumpToCluster(int offset) {
        DimensionState state = this.state();
        state.getCluster(this.clusterIndex + offset).thenApplyAsync(pair -> {
            ChunkSelection selection = (ChunkSelection)pair.first();
            this.clusterIndex = pair.secondInt();
            this.setMapCenter(selection.getCenterChunkPos());
            this.clusterSelection = selection;
            this.clusterTicks = 20;
            return null;
        }, (Executor)this.field_22787);
    }

    private void loadDimensions() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.method_1562() != null) {
            Set dimensions = minecraft.method_1562().method_29356();
            LinkedHashSet<class_5321> sorted = new LinkedHashSet<class_5321>();
            if (dimensions.contains(class_1937.field_25179)) {
                sorted.add(class_1937.field_25179);
            }
            if (dimensions.contains(class_1937.field_25180)) {
                sorted.add(class_1937.field_25180);
            }
            if (dimensions.contains(class_1937.field_25181)) {
                sorted.add(class_1937.field_25181);
            }
            sorted.addAll(dimensions);
            this.dimensions.addAll(sorted);
        } else {
            this.dimensions.add((class_5321<class_1937>)class_1937.field_25179);
            this.dimensions.add((class_5321<class_1937>)class_1937.field_25180);
            this.dimensions.add((class_5321<class_1937>)class_1937.field_25181);
        }
        int width = this.dimensions.stream().mapToInt(key -> minecraft.field_1772.method_1727(key.method_29177().toString())).max().orElse(10);
        this.dimensionWidth = Math.min(width, 140);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            this.dimensionIndex = this.dimensions.indexOf(player.method_37908().method_27983());
        }
    }

    private void initializeState(DimensionState state) {
        if (!this.isWatching(state.dimension)) {
            ChunkDebugClient.getInstance().startWatching(state.dimension);
        }
        if (!state.initialized) {
            class_746 player;
            class_1923 center = class_1923.field_35107;
            if (this.field_22787 != null && (player = this.field_22787.field_1724) != null && player.method_37908().method_27983() == state.dimension) {
                center = player.method_31476();
            }
            state.offsetX = (double)this.field_22789 / 2.0 - (double)((float)center.field_9181 * state.scale);
            state.offsetY = (double)this.field_22790 / 2.0 - (double)((float)center.field_9180 * state.scale);
            state.initialized = true;
        }
    }

    private void setMapCenter(class_1923 pos) {
        this.setMapCenter(pos.field_9181, pos.field_9180);
    }

    private void setMapCenter(int x, int z) {
        DimensionState state = this.state();
        state.offsetX = (double)this.field_22789 / 2.0 - (double)((float)x * state.scale);
        state.offsetY = (double)this.field_22790 / 2.0 - (double)((float)z * state.scale);
    }

    private class_1923 convertScreenToChunkPos(double x, double y) {
        DimensionState state = this.state();
        double scaledX = (x - state.offsetX) / (double)state.scale;
        double scaledY = (y - state.offsetY) / (double)state.scale;
        return new class_1923(class_3532.method_15357((double)scaledX), class_3532.method_15357((double)scaledY));
    }

    private void incrementDimension(int increment) {
        this.dimensionIndex = (this.dimensionIndex + increment + this.dimensions.size()) % this.dimensions.size();
    }

    private class_5321<class_1937> dimension() {
        if (this.dimensions.isEmpty()) {
            this.loadDimensions();
        }
        return this.dimensions.get(this.dimensionIndex);
    }

    private boolean isWatching(class_5321<class_1937> dimension) {
        return this.states.containsKey(dimension);
    }

    private int calculateChunkColor(ChunkData data) {
        class_1923 pos = data.position();
        class_2806 stage = this.showStages.isToggled() ? data.stage() : null;
        List<class_3228<?>> tickets = this.showTickets.isToggled() ? data.tickets() : List.of();
        int color = ChunkColors.calculateChunkColor(data.status(), stage, tickets, data.unloading());
        if ((pos.field_9181 + pos.field_9180) % 2 == 0) {
            color = class_5253.class_5254.method_48780((float)0.12f, (int)color, (int)0xFFFFFF);
        }
        return color | 0xFF000000;
    }

    private static enum Minimap {
        NONE,
        STATIC,
        FOLLOW;


        public Minimap previous() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> FOLLOW;
                case 1 -> NONE;
                case 2 -> STATIC;
            };
        }

        public Minimap next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> STATIC;
                case 1 -> FOLLOW;
                case 2 -> NONE;
            };
        }

        public class_2561 pretty() {
            return class_2561.method_43471((String)("chunk-debug.settings.minimap." + this.name().toLowerCase()));
        }
    }

    private static class DimensionState {
        private final Multimap<Integer, ChunkData> unloaded = HashMultimap.create();
        private final Long2ObjectMap<ChunkData> chunks = new Long2ObjectOpenHashMap();
        private final ChunkClusters clusters = new ChunkClusters();
        private final class_5321<class_1937> dimension;
        private final Executor clusterWorker;
        private ChunkSelection selection;
        private class_1923 first;
        private float scale = 1.0f;
        private double offsetX = 0.0;
        private double offsetY = 0.0;
        boolean initialized = false;

        private DimensionState(class_5321<class_1937> dimension, Executor clusterWorker) {
            this.dimension = dimension;
            this.clusterWorker = clusterWorker;
        }

        void add(long pos, ChunkData data) {
            this.chunks.put(pos, (Object)data);
            this.clusterWorker.execute(() -> this.clusters.add(pos));
        }

        void remove(long pos, int tick) {
            this.clusterWorker.execute(() -> this.clusters.remove(pos));
            ChunkData data = (ChunkData)this.chunks.remove(pos);
            if (data != null) {
                this.unloaded.put((Object)tick, (Object)data);
                data.updateUnloading(false);
            }
        }

        CompletableFuture<ObjectIntPair<ChunkSelection>> getCluster(int index) {
            return CompletableFuture.supplyAsync(() -> {
                int corrected = index + this.clusters.count() % this.clusters.count();
                LongSet cluster = this.clusters.getCluster(corrected);
                List<class_1923> positions = cluster.longStream().mapToObj(class_1923::new).toList();
                return ObjectIntPair.of((Object)ChunkSelection.fromPositions(positions), (int)corrected);
            }, this.clusterWorker);
        }
    }
}

