/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.gui;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;

public class ChunkClusters {
    private final List<LongSet> groups = new ArrayList<LongSet>();
    private final LongSet chunks = new LongOpenHashSet();

    public void add(long position) {
        if (!this.chunks.add(position)) {
            return;
        }
        long[] directions = ChunkClusters.getOffsets(position);
        long up = directions[0];
        long down = directions[1];
        long right = directions[2];
        long left = directions[3];
        ArrayList<LongSet> nearby = new ArrayList<LongSet>(4);
        for (LongSet positions : this.groups) {
            if (!positions.contains(up) && !positions.contains(down) && !positions.contains(right) && !positions.contains(left)) continue;
            nearby.add(positions);
        }
        if (nearby.isEmpty()) {
            LongOpenHashSet set = new LongOpenHashSet();
            this.groups.add((LongSet)set);
            set.add(position);
            return;
        }
        if (nearby.size() == 1) {
            ((LongSet)nearby.getFirst()).add(position);
            return;
        }
        LongSet largest = (LongSet)nearby.getFirst();
        for (int i = 1; i < nearby.size(); ++i) {
            LongSet next = (LongSet)nearby.get(i);
            if (largest.size() >= next.size()) continue;
            largest = next;
        }
        largest.add(position);
        for (LongSet set : nearby) {
            if (set == largest) continue;
            largest.addAll((LongCollection)set);
            this.groups.remove(set);
        }
    }

    public void remove(long position) {
        if (!this.chunks.remove(position)) {
            return;
        }
        for (LongSet group : this.groups) {
            if (!group.remove(position)) continue;
            this.groups.remove(group);
            if (group.isEmpty()) {
                return;
            }
            this.groups.addAll(ChunkClusters.search(position, group));
            return;
        }
    }

    public int count() {
        return this.groups.size();
    }

    public LongSet getCluster(int index) {
        return this.groups.get(index);
    }

    private static List<LongSet> search(long origin, LongSet originGroup) {
        long[] directions = ChunkClusters.getOffsets(origin);
        ArrayList<LongSet> groups = new ArrayList<LongSet>(4);
        for (long direction : directions) {
            if (!originGroup.contains(direction)) continue;
            boolean grouped = false;
            for (LongSet group : groups) {
                if (!group.contains(direction)) continue;
                grouped = true;
                break;
            }
            if (grouped) continue;
            LongOpenHashSet found = new LongOpenHashSet();
            ChunkClusters.searchFrom(direction, originGroup, (LongSet)new LongOpenHashSet(), (LongSet)found);
            if (found.isEmpty()) continue;
            groups.add((LongSet)found);
        }
        return groups;
    }

    private static void searchFrom(long position, LongSet group, LongSet checked, LongSet found) {
        LongArrayList stack = new LongArrayList();
        stack.push(position);
        while (!stack.isEmpty()) {
            long[] directions;
            long current = stack.popLong();
            for (long direction : directions = ChunkClusters.getOffsets(current)) {
                if (!checked.add(direction) || !group.contains(direction)) continue;
                found.add(direction);
                stack.push(direction);
            }
        }
    }

    private static long[] getOffsets(long position) {
        int x = (int)position;
        int z = (int)(position >> 32);
        return new long[]{ChunkClusters.pack(x + 1, z), ChunkClusters.pack(x - 1, z), ChunkClusters.pack(x, z + 1), ChunkClusters.pack(x, z - 1)};
    }

    private static long pack(int x, int z) {
        return class_1923.method_8331((int)x, (int)z);
    }
}

