/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client;

import java.util.List;
import java.util.function.Supplier;
import me.senseiwells.chunkdebug.ChunkDebug;
import me.senseiwells.chunkdebug.client.gui.ChunkDebugScreen;
import me.senseiwells.chunkdebug.common.network.ByePayload;
import me.senseiwells.chunkdebug.common.network.ChunkDataPayload;
import me.senseiwells.chunkdebug.common.network.ChunkUnloadPayload;
import me.senseiwells.chunkdebug.common.network.HelloPayload;
import me.senseiwells.chunkdebug.common.network.StartWatchingPayload;
import me.senseiwells.chunkdebug.common.network.StopWatchingPayload;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.class_9779;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ChunkDebugClient
implements ClientModInitializer {
    private static ChunkDebugClient instance;
    public final class_304 keybind = new class_304("chunk-debug.key", 295, "key.categories.misc");
    @Nullable
    private ChunkDebugScreen screen;

    public static ChunkDebugClient getInstance() {
        return instance;
    }

    public void onInitializeClient() {
        instance = this;
        KeyBindingHelper.registerKeyBinding((class_304)this.keybind);
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::onClientStopping);
        ClientPlayNetworking.registerGlobalReceiver(HelloPayload.TYPE, this::handleHello);
        ClientPlayNetworking.registerGlobalReceiver(ByePayload.TYPE, this::handleBye);
        ClientPlayNetworking.registerGlobalReceiver(ChunkDataPayload.TYPE, this::handleChunkData);
        ClientPlayNetworking.registerGlobalReceiver(ChunkUnloadPayload.TYPE, this::handleChunkUnload);
    }

    public void startWatching(class_5321<class_1937> dimension) {
        this.trySendPayload(() -> new StartWatchingPayload(List.of(dimension)));
    }

    public void stopWatching() {
        this.trySendPayload(StopWatchingPayload::new);
    }

    @ApiStatus.Internal
    public void onGuiRender(class_332 graphics, class_9779 tracker) {
        if (this.screen != null) {
            this.screen.renderMinimap(graphics);
        }
    }

    @ApiStatus.Internal
    public void onGuiResize(class_310 minecraft, int width, int height) {
        if (this.screen != null) {
            this.screen.method_25410(minecraft, width, height);
        }
    }

    private void onClientTick(class_310 minecraft) {
        if (this.screen != null) {
            this.screen.clientTick();
        }
        if (this.keybind.method_1436() && minecraft.field_1755 == null) {
            if (this.screen != null) {
                minecraft.method_1507((class_437)this.screen);
            } else {
                minecraft.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"chunk-debug.screen.unavailable").method_27692(class_124.field_1061));
            }
        }
    }

    private void onClientStopping(class_310 minecraft) {
        this.setScreen(null);
    }

    private void handleHello(HelloPayload payload, ClientPlayNetworking.Context context) {
        if (payload.version() == 1) {
            this.setScreen(new ChunkDebugScreen());
            ChunkDebug.LOGGER.info("ChunkDebug connection successful");
        } else if (payload.version() < 1) {
            ChunkDebug.LOGGER.info("ChunkDebug failed to connect, server is out of date!");
        } else {
            ChunkDebug.LOGGER.info("ChunkDebug failed to connect, client is out of date!");
        }
    }

    private void handleBye(ByePayload payload, ClientPlayNetworking.Context context) {
        class_310 minecraft = context.client();
        if (minecraft.field_1755 == this.screen) {
            minecraft.method_1507(null);
        }
        this.setScreen(null);
    }

    private void handleChunkData(ChunkDataPayload payload, ClientPlayNetworking.Context context) {
        if (this.screen != null) {
            this.screen.updateChunks(payload.dimension(), payload.chunks());
        }
    }

    private void handleChunkUnload(ChunkUnloadPayload payload, ClientPlayNetworking.Context context) {
        if (this.screen != null) {
            this.screen.unloadChunks(payload.dimension(), payload.positions());
        }
    }

    private void trySendPayload(Supplier<class_8710> supplier) {
        class_310 minecraft = class_310.method_1551();
        class_634 listener = minecraft.method_1562();
        if (listener != null) {
            listener.method_52787((class_2596)new class_2817(supplier.get()));
        }
    }

    private void setScreen(@Nullable ChunkDebugScreen screen) {
        if (this.screen != null) {
            this.screen.shutdown();
        }
        this.screen = screen;
    }
}

