/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util.shape;

import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ShapeRenderType;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class SphereUtils {
    public static void collectSpherePositions(Consumer<class_2338.class_2339> positionConsumer, RingPositionTest test, class_2338 centerPos, int radius) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        mutablePos.method_10101((class_2382)centerPos);
        SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
        mutablePos.method_10101((class_2382)centerPos);
        SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, class_2350.field_11043, test);
        int r = radius + 2;
        for (int i = 1; i < r; ++i) {
            mutablePos.method_10103(centerPos.method_10263(), centerPos.method_10264() - i, centerPos.method_10260());
            SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            mutablePos.method_10103(centerPos.method_10263(), centerPos.method_10264() + i, centerPos.method_10260());
            SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            mutablePos.method_10103(centerPos.method_10263(), centerPos.method_10264(), centerPos.method_10260() - i);
            SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, class_2350.field_11043, test);
            mutablePos.method_10103(centerPos.method_10263(), centerPos.method_10264(), centerPos.method_10260() + i);
            SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, class_2350.field_11043, test);
        }
    }

    public static boolean movePositionToRing(class_2338.class_2339 posMutable, class_2350 moveDirection, RingPositionTest test) {
        int incX = moveDirection.method_10148();
        int incY = moveDirection.method_10164();
        int incZ = moveDirection.method_10165();
        int x = posMutable.method_10263();
        int y = posMutable.method_10264();
        int z = posMutable.method_10260();
        int nextX = x;
        int nextY = y;
        int nextZ = z;
        while (test.isInsideOrCloserThan(nextX, nextY, nextZ, moveDirection)) {
            x = nextX;
            y = nextY;
            z = nextZ;
            nextX += incX;
            nextY += incY;
            nextZ += incZ;
        }
        if (x != nextX || y != nextY | z != nextZ) {
            posMutable.method_10103(x, y, z);
            return true;
        }
        return false;
    }

    public static void addPositionsOnHorizontalBlockRing(Consumer<class_2338.class_2339> positionConsumer, class_2338.class_2339 mutablePos, RingPositionTest test) {
        Function<class_2350, class_2350> nextDirectionFunction = SphereUtils::getNextHorizontalDirection;
        class_2350 startDirection = class_2350.field_11034;
        SphereUtils.addPositionsOnBlockRing(positionConsumer, mutablePos, startDirection, test, nextDirectionFunction);
    }

    public static void addPositionsOnVerticalBlockRing(Consumer<class_2338.class_2339> positionConsumer, class_2338.class_2339 mutablePos, class_2350 mainAxis, RingPositionTest test) {
        Function<class_2350, class_2350> nextDirectionFunction = dir -> SphereUtils.getNextVerticalRingDirection(dir, mainAxis);
        class_2350 startDirection = class_2350.field_11036;
        SphereUtils.addPositionsOnBlockRing(positionConsumer, mutablePos, startDirection, test, nextDirectionFunction);
    }

    public static void addPositionsOnBlockRing(Consumer<class_2338.class_2339> positionConsumer, class_2338.class_2339 mutablePos, class_2350 startDirection, RingPositionTest test, Function<class_2350, class_2350> nextDirectionFunction) {
        if (SphereUtils.movePositionToRing(mutablePos, startDirection, test)) {
            LongOpenHashSet seenPositions = new LongOpenHashSet();
            class_2338 firstPos = mutablePos.method_10062();
            class_2350 direction = startDirection;
            positionConsumer.accept(mutablePos);
            while (true) {
                direction = SphereUtils.getNextPositionOnBlockRing(mutablePos, direction, test, nextDirectionFunction);
                long posLong = mutablePos.method_10063();
                if (direction == null || mutablePos.equals((Object)firstPos) || seenPositions.contains(posLong)) break;
                positionConsumer.accept(mutablePos);
                seenPositions.add(posLong);
            }
        }
    }

    @Nullable
    public static class_2350 getNextPositionOnBlockRing(class_2338.class_2339 posMutable, class_2350 escapeDirection, RingPositionTest test, Function<class_2350, class_2350> nextDirectionFunction) {
        class_2350 dirOut = escapeDirection;
        for (int i = 0; i < 4; ++i) {
            int z;
            int y;
            int x = posMutable.method_10263() + escapeDirection.method_10148();
            if (test.isInsideOrCloserThan(x, y = posMutable.method_10264() + escapeDirection.method_10164(), z = posMutable.method_10260() + escapeDirection.method_10165(), escapeDirection)) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            class_2350 ccw90 = nextDirectionFunction.apply(escapeDirection);
            if (test.isInsideOrCloserThan(x += ccw90.method_10148(), y += ccw90.method_10164(), z += ccw90.method_10165(), escapeDirection)) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            dirOut = escapeDirection;
            escapeDirection = nextDirectionFunction.apply(escapeDirection);
        }
        return null;
    }

    public static boolean isPositionInsideOrClosestToRadiusOnBlockRing(int blockX, int blockY, int blockZ, class_243 center, double squareRadius, class_2350 escapeDirection) {
        double zAdj;
        double yAdj;
        double x = (double)blockX + 0.5;
        double y = (double)blockY + 0.5;
        double z = (double)blockZ + 0.5;
        double dist = center.method_1028(x, y, z);
        double diff = squareRadius - dist;
        if (diff > 0.0) {
            return true;
        }
        double xAdj = (double)blockX + (double)escapeDirection.method_10148() + 0.5;
        double distAdj = center.method_1028(xAdj, yAdj = (double)blockY + (double)escapeDirection.method_10164() + 0.5, zAdj = (double)blockZ + (double)escapeDirection.method_10165() + 0.5);
        double diffAdj = squareRadius - distAdj;
        return diffAdj > 0.0 && Math.abs(diff) < Math.abs(diffAdj);
    }

    public static class_2350 getNextHorizontalDirection(class_2350 dirIn) {
        return dirIn.method_10160();
    }

    public static class_2350 getNextVerticalRingDirection(class_2350 currentDirection, class_2350 mainAxis) {
        return switch (mainAxis) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11036 -> {
                switch (currentDirection) {
                    case field_11043: {
                        yield class_2350.field_11033;
                    }
                    case field_11035: {
                        yield class_2350.field_11036;
                    }
                    case field_11033: {
                        yield class_2350.field_11035;
                    }
                }
                yield class_2350.field_11043;
            }
            case class_2350.field_11043, class_2350.field_11035 -> {
                switch (currentDirection) {
                    case field_11039: {
                        yield class_2350.field_11036;
                    }
                    case field_11034: {
                        yield class_2350.field_11033;
                    }
                    case field_11033: {
                        yield class_2350.field_11039;
                    }
                }
                yield class_2350.field_11034;
            }
            case class_2350.field_11039, class_2350.field_11034 -> {
                switch (currentDirection) {
                    case field_11043: {
                        yield class_2350.field_11036;
                    }
                    case field_11035: {
                        yield class_2350.field_11033;
                    }
                    case field_11033: {
                        yield class_2350.field_11043;
                    }
                }
                yield class_2350.field_11035;
            }
        };
    }

    public static class_2350[] getDirectionsNotOnAxis(class_2350.class_2351 axis) {
        class_2350[] sides = new class_2350[4];
        int index = 0;
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            if (side.method_10166() == axis) continue;
            sides[index++] = side;
        }
        return sides;
    }

    public static List<SideQuad> buildSphereShellToQuads(LongOpenHashSet positions, class_2350.class_2351 mainAxis, RingPositionTest test, ShapeRenderType renderType, LayerRange layerRange) {
        Long2ObjectOpenHashMap<SideQuad> strips = SphereUtils.buildSphereShellToStrips(positions, mainAxis, test, renderType, layerRange);
        return SphereUtils.buildStripsToQuads(strips, mainAxis);
    }

    public static Long2ObjectOpenHashMap<SideQuad> buildSphereShellToStrips(LongOpenHashSet positions, class_2350.class_2351 mainAxis, RingPositionTest test, ShapeRenderType renderType, LayerRange layerRange) {
        Long2ObjectOpenHashMap strips = new Long2ObjectOpenHashMap();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        class_2350[] sides = PositionUtils.ALL_DIRECTIONS;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            if (!layerRange.isPositionWithinRange(pos)) continue;
            for (class_2350 side : sides) {
                if (SphereUtils.isHandledAndMarkHandled(pos, side, handledPositions) || !SphereUtils.shouldRenderSide(pos, side, test, renderType, positions)) continue;
                class_2350 minDir = side.method_10166() != mainAxis ? SphereUtils.getNegativeDirectionFor(SphereUtils.getThirdAxis(mainAxis, side.method_10166())) : (mainAxis.method_10178() ? class_2350.field_11039 : class_2350.field_11033);
                class_2350 maxDir = minDir.method_10153();
                int lengthMin = SphereUtils.getStripLengthOnSide(pos, side, minDir, test, renderType, positions, handledPositions);
                int lengthMax = SphereUtils.getStripLengthOnSide(pos, side, maxDir, test, renderType, positions, handledPositions);
                long startPosLong = SphereUtils.offsetPos(pos, minDir, lengthMin);
                int length = lengthMin + lengthMax + 1;
                long index = SphereUtils.getCompressedPosSide(startPosLong, side);
                strips.put(index, (Object)new SideQuad(startPosLong, length, 1, side));
            }
        }
        return strips;
    }

    public static List<SideQuad> buildStripsToQuads(Long2ObjectOpenHashMap<SideQuad> strips, class_2350.class_2351 mainAxis) {
        ArrayList<SideQuad> quads = new ArrayList<SideQuad>();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        for (SideQuad strip : strips.values()) {
            class_2350 side;
            long pos = strip.startPos();
            if (SphereUtils.isHandledAndMarkHandled(pos, side = strip.side(), handledPositions)) continue;
            class_2350 minDir = side.method_10166() != mainAxis ? SphereUtils.getNegativeDirectionFor(mainAxis) : (mainAxis.method_10178() ? class_2350.field_11043 : class_2350.field_11033);
            class_2350 maxDir = minDir.method_10153();
            int stripCountMin = SphereUtils.getStripCountOnSide(strip, minDir, strips, handledPositions);
            int stripCountMax = SphereUtils.getStripCountOnSide(strip, maxDir, strips, handledPositions);
            long startPos = SphereUtils.offsetPos(pos, minDir, stripCountMin);
            int height = stripCountMin + stripCountMax + 1;
            quads.add(new SideQuad(startPos, strip.width(), height, side));
        }
        return quads;
    }

    protected static int getStripCountOnSide(SideQuad startStrip, class_2350 offsetSide, Long2ObjectOpenHashMap<SideQuad> strips, Long2ByteOpenHashMap handledPositions) {
        long index;
        SideQuad adjStrip;
        long startPos = startStrip.startPos();
        class_2350 side = startStrip.side();
        int width = startStrip.width();
        long adjPos = class_2338.method_10060((long)startPos, (class_2350)offsetSide);
        int count = 0;
        while ((adjStrip = (SideQuad)strips.get(index = SphereUtils.getCompressedPosSide(adjPos, side))) != null && adjStrip.width() == width && !SphereUtils.isHandledAndMarkHandled(adjPos, side, handledPositions)) {
            ++count;
            adjPos = class_2338.method_10060((long)adjPos, (class_2350)offsetSide);
        }
        return count;
    }

    protected static int getStripLengthOnSide(long pos, class_2350 side, class_2350 moveDirection, RingPositionTest test, ShapeRenderType renderType, LongOpenHashSet positions, Long2ByteOpenHashMap handledPositions) {
        int length = 0;
        long adjPos = class_2338.method_10060((long)pos, (class_2350)moveDirection);
        while (positions.contains(adjPos) && SphereUtils.shouldRenderSide(adjPos, side, test, renderType, positions) && !SphereUtils.isHandledAndMarkHandled(adjPos, side, handledPositions)) {
            ++length;
            adjPos = class_2338.method_10060((long)adjPos, (class_2350)moveDirection);
        }
        return length;
    }

    public static boolean isHandledAndMarkHandled(long pos, class_2350 side, Long2ByteOpenHashMap handledPositions) {
        byte sideMask = (byte)(1 << side.method_10146());
        byte val = handledPositions.get(pos);
        if ((val & sideMask) != 0) {
            return true;
        }
        val = (byte)(val | sideMask);
        handledPositions.put(pos, val);
        return false;
    }

    protected static boolean shouldRenderSide(long pos, class_2350 side, RingPositionTest test, ShapeRenderType renderType, LongOpenHashSet positions) {
        long adjPos = class_2338.method_10060((long)pos, (class_2350)side);
        if (positions.contains(adjPos)) {
            return false;
        }
        if (renderType == ShapeRenderType.FULL_BLOCK) {
            return true;
        }
        int adjX = class_2338.method_10061((long)adjPos);
        int adjY = class_2338.method_10071((long)adjPos);
        int adjZ = class_2338.method_10083((long)adjPos);
        boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
        return renderType == ShapeRenderType.OUTER_EDGE && !onOrIn || renderType == ShapeRenderType.INNER_EDGE && onOrIn;
    }

    public static class_2350 getNegativeDirectionFor(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> class_2350.field_11039;
            case class_2350.class_2351.field_11052 -> class_2350.field_11033;
            case class_2350.class_2351.field_11051 -> class_2350.field_11043;
        };
    }

    public static class_2350 getPositiveDirectionFor(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> class_2350.field_11034;
            case class_2350.class_2351.field_11052 -> class_2350.field_11036;
            case class_2350.class_2351.field_11051 -> class_2350.field_11035;
        };
    }

    public static class_2350.class_2351 getThirdAxis(class_2350.class_2351 axis1, class_2350.class_2351 axis2) {
        return switch (axis1) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> {
                if (axis2 == class_2350.class_2351.field_11052) {
                    yield class_2350.class_2351.field_11051;
                }
                yield class_2350.class_2351.field_11052;
            }
            case class_2350.class_2351.field_11052 -> {
                if (axis2 == class_2350.class_2351.field_11048) {
                    yield class_2350.class_2351.field_11051;
                }
                yield class_2350.class_2351.field_11048;
            }
            case class_2350.class_2351.field_11051 -> axis2 == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11048;
        };
    }

    public static long offsetPos(long pos, class_2350 direction, int amount) {
        return class_2338.method_10096((long)pos, (int)(direction.method_10148() * amount), (int)(direction.method_10164() * amount), (int)(direction.method_10165() * amount));
    }

    public static long getCompressedPosSide(long pos, class_2350 side) {
        int x = class_2338.method_10061((long)pos);
        int y = class_2338.method_10071((long)pos);
        int z = class_2338.method_10083((long)pos);
        long val = 1L << side.method_10146() << 58;
        val |= ((long)y & 0x3FFFL) << 44;
        val |= ((long)z & 0x3FFFFFL) << 22;
        return val |= (long)x & 0x3FFFFFL;
    }

    public static interface RingPositionTest {
        public boolean isInsideOrCloserThan(int var1, int var2, int var3, class_2350 var4);
    }
}

