/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.settings.base;

import com.google.gson.JsonObject;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import de.florianmichael.viafabricplus.protocoltranslator.ProtocolTranslator;
import de.florianmichael.viafabricplus.screen.VFPListEntry;
import de.florianmichael.viafabricplus.screen.settings.VersionedBooleanSettingRenderer;
import de.florianmichael.viafabricplus.settings.base.AbstractSetting;
import de.florianmichael.viafabricplus.settings.base.SettingGroup;
import net.minecraft.class_5250;
import net.raphimc.vialoader.util.VersionRange;

public class VersionedBooleanSetting
extends AbstractSetting<Integer> {
    public static final int AUTO_INDEX = 2;
    public static final int DISABLED_INDEX = 1;
    public static final int ENABLED_INDEX = 0;
    private final VersionRange protocolRange;

    public VersionedBooleanSetting(SettingGroup parent, class_5250 name, VersionRange protocolRange) {
        super(parent, name, 2);
        this.protocolRange = protocolRange;
    }

    @Override
    public VFPListEntry makeSettingRenderer() {
        return new VersionedBooleanSettingRenderer(this);
    }

    @Override
    public void write(JsonObject object) {
        object.addProperty(this.getTranslationKey(), (Integer)this.getValue() == 2 ? "auto" : ((Integer)this.getValue() == 0 ? "enabled" : "disabled"));
    }

    @Override
    public void read(JsonObject object) {
        String selected = object.get(this.getTranslationKey()).getAsString();
        this.setValue(selected.equals("auto") ? 2 : (selected.equals("enabled") ? 0 : 1));
    }

    public boolean isAuto() {
        return (Integer)this.getValue() == 2;
    }

    public boolean isEnabled() {
        return this.isEnabled(ProtocolTranslator.getTargetVersion());
    }

    public boolean isEnabled(ProtocolVersion version) {
        if (this.isAuto()) {
            return this.protocolRange.contains(version);
        }
        return (Integer)this.getValue() == 0;
    }

    public VersionRange getProtocolRange() {
        return this.protocolRange;
    }
}

