/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.settings.base;

import com.google.gson.JsonObject;
import de.florianmichael.viafabricplus.screen.VFPListEntry;
import de.florianmichael.viafabricplus.settings.base.SettingGroup;
import de.florianmichael.viafabricplus.util.ChatUtil;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class AbstractSetting<T> {
    private final class_5250 name;
    private final T defaultValue;
    private T value;
    private Supplier<class_2561> tooltip;

    public AbstractSetting(SettingGroup parent, class_5250 name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        parent.getSettings().add(this);
    }

    public abstract VFPListEntry makeSettingRenderer();

    public abstract void write(JsonObject var1);

    public abstract void read(JsonObject var1);

    public void onValueChanged() {
    }

    public class_5250 getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return AbstractSetting.mapTranslationKey(ChatUtil.uncoverTranslationKey((class_2561)this.name));
    }

    public static String mapTranslationKey(String input) {
        return input.split("viafabricplus.")[1];
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.onValueChanged();
    }

    public class_2561 getTooltip() {
        if (this.tooltip == null) {
            return null;
        }
        return this.tooltip.get();
    }

    public void setTooltip(class_2561 tooltip) {
        this.tooltip = () -> tooltip;
    }

    public void setTooltip(Supplier<class_2561> tooltip) {
        this.tooltip = tooltip;
    }
}

