/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.save.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import de.florianmichael.viafabricplus.protocoltranslator.ProtocolTranslator;
import de.florianmichael.viafabricplus.save.AbstractSave;
import de.florianmichael.viafabricplus.settings.SettingsManager;
import de.florianmichael.viafabricplus.settings.base.AbstractSetting;
import de.florianmichael.viafabricplus.settings.base.SettingGroup;
import de.florianmichael.viafabricplus.settings.impl.GeneralSettings;
import de.florianmichael.viafabricplus.util.ChatUtil;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;

public class SettingsSave
extends AbstractSave {
    private final SettingsManager settingsManager;
    private String selectedProtocolVersion;

    public SettingsSave(SettingsManager settingsManager) {
        super("settings");
        this.settingsManager = settingsManager;
    }

    @Override
    public void write(JsonObject object) {
        for (SettingGroup group : this.settingsManager.getGroups()) {
            JsonObject groupObject = new JsonObject();
            for (AbstractSetting<?> setting : group.getSettings()) {
                setting.write(groupObject);
            }
            object.add(AbstractSetting.mapTranslationKey(ChatUtil.uncoverTranslationKey(group.getName())), (JsonElement)groupObject);
        }
        object.addProperty("selected-protocol-version", ProtocolTranslator.getTargetVersion().getName());
    }

    @Override
    public void read(JsonObject object) {
        for (SettingGroup group : this.settingsManager.getGroups()) {
            String translationKey = ChatUtil.uncoverTranslationKey(group.getName());
            JsonObject groupObject = object.getAsJsonObject(AbstractSetting.mapTranslationKey(translationKey));
            for (AbstractSetting<?> setting : group.getSettings()) {
                if (!groupObject.has(setting.getTranslationKey())) continue;
                setting.read(groupObject);
            }
        }
        if (object.has("selected-protocol-version")) {
            this.selectedProtocolVersion = object.get("selected-protocol-version").getAsString();
        }
    }

    @Override
    public void postInit() {
        if (this.selectedProtocolVersion == null) {
            return;
        }
        if (((Boolean)GeneralSettings.global().saveSelectedProtocolVersion.getValue()).booleanValue()) {
            ProtocolVersion protocolVersion = SettingsSave.protocolVersionByName(this.selectedProtocolVersion);
            if (protocolVersion != null) {
                ProtocolTranslator.setTargetVersion(protocolVersion);
            }
        } else {
            ProtocolTranslator.setTargetVersion(ProtocolTranslator.NATIVE_VERSION);
        }
    }

    public static ProtocolVersion protocolVersionByName(String name) {
        if (name.contains("Bedrock")) {
            return BedrockProtocolVersion.bedrockLatest;
        }
        return ProtocolVersion.getClosest((String)name);
    }
}

