/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.save.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.florianmichael.classic4j.model.classicube.account.CCAccount;
import de.florianmichael.viafabricplus.ViaFabricPlus;
import de.florianmichael.viafabricplus.save.AbstractSave;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.bedrock.session.StepFullBedrockSession;

public class AccountsSave
extends AbstractSave {
    private StepFullBedrockSession.FullBedrockSession bedrockAccount;
    private CCAccount classicubeAccount;

    public AccountsSave() {
        super("accounts");
    }

    @Override
    public void write(JsonObject object) {
        if (this.bedrockAccount != null) {
            object.add("bedrock", (JsonElement)MinecraftAuth.BEDROCK_DEVICE_CODE_LOGIN.toJson((AbstractStep.StepResult)this.bedrockAccount));
        }
        if (this.classicubeAccount != null) {
            object.add("classicube", (JsonElement)this.classicubeAccount.asJson());
        }
    }

    @Override
    public void read(JsonObject object) {
        if (object.has("bedrock")) {
            try {
                this.bedrockAccount = (StepFullBedrockSession.FullBedrockSession)MinecraftAuth.BEDROCK_DEVICE_CODE_LOGIN.fromJson(object.get("bedrock").getAsJsonObject());
            }
            catch (Exception e) {
                ViaFabricPlus.global().getLogger().error("Failed to read bedrock account!", (Throwable)e);
            }
        }
        if (object.has("classicube")) {
            try {
                this.classicubeAccount = CCAccount.fromJson((JsonObject)object.get("classicube").getAsJsonObject());
            }
            catch (Exception e) {
                ViaFabricPlus.global().getLogger().error("Failed to read classicube account!", (Throwable)e);
            }
        }
    }

    public StepFullBedrockSession.FullBedrockSession refreshAndGetBedrockAccount() {
        if (this.bedrockAccount == null) {
            return null;
        }
        try {
            this.bedrockAccount = (StepFullBedrockSession.FullBedrockSession)MinecraftAuth.BEDROCK_DEVICE_CODE_LOGIN.refresh(MinecraftAuth.createHttpClient(), (AbstractStep.StepResult)this.bedrockAccount);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to refresh Bedrock chain data. Please re-login to Bedrock!", t);
        }
        return this.bedrockAccount;
    }

    public StepFullBedrockSession.FullBedrockSession getBedrockAccount() {
        return this.bedrockAccount;
    }

    public void setBedrockAccount(StepFullBedrockSession.FullBedrockSession bedrockAccount) {
        this.bedrockAccount = bedrockAccount;
    }

    public CCAccount getClassicubeAccount() {
        return this.classicubeAccount;
    }

    public void setClassicubeAccount(CCAccount classicubeAccount) {
        this.classicubeAccount = classicubeAccount;
    }
}

