/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.save;

import de.florianmichael.viafabricplus.event.LoadSaveFilesCallback;
import de.florianmichael.viafabricplus.save.AbstractSave;
import de.florianmichael.viafabricplus.save.impl.AccountsSave;
import de.florianmichael.viafabricplus.save.impl.SettingsSave;
import de.florianmichael.viafabricplus.settings.SettingsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class SaveManager {
    private final List<AbstractSave> saves = new ArrayList<AbstractSave>();
    private final SettingsSave settingsSave;
    private final AccountsSave accountsSave;

    public SaveManager(SettingsManager settingsManager) {
        ((LoadSaveFilesCallback)LoadSaveFilesCallback.EVENT.invoker()).onLoadSaveFiles(this, LoadSaveFilesCallback.State.PRE);
        AbstractSave[] abstractSaveArray = new AbstractSave[2];
        this.settingsSave = new SettingsSave(settingsManager);
        abstractSaveArray[0] = this.settingsSave;
        this.accountsSave = new AccountsSave();
        abstractSaveArray[1] = this.accountsSave;
        this.add(abstractSaveArray);
        for (AbstractSave save : this.saves) {
            save.init();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (AbstractSave save : this.saves) {
                save.save();
            }
        }));
        ((LoadSaveFilesCallback)LoadSaveFilesCallback.EVENT.invoker()).onLoadSaveFiles(this, LoadSaveFilesCallback.State.POST);
    }

    @ApiStatus.Internal
    public void postInit() {
        for (AbstractSave save : this.saves) {
            save.postInit();
        }
        ((LoadSaveFilesCallback)LoadSaveFilesCallback.EVENT.invoker()).onLoadSaveFiles(this, LoadSaveFilesCallback.State.POST_INIT);
    }

    public void add(AbstractSave ... saves) {
        this.saves.addAll(Arrays.asList(saves));
    }

    public SettingsSave getSettingsSave() {
        return this.settingsSave;
    }

    public AccountsSave getAccountsSave() {
        return this.accountsSave;
    }
}

