/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.save;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.florianmichael.viafabricplus.ViaFabricPlus;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public abstract class AbstractSave {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File file;

    public AbstractSave(String name) {
        this.file = new File(ViaFabricPlus.global().getDirectory(), name + ".json");
    }

    public void init() {
        if (this.file.exists()) {
            try (FileReader fr = new FileReader(this.file);){
                this.read((JsonObject)GSON.fromJson((Reader)fr, JsonObject.class));
            }
            catch (Exception e) {
                ViaFabricPlus.global().getLogger().error("Failed to read file: {}!", (Object)this.file.getName(), (Object)e);
            }
        }
    }

    public void save() {
        try {
            this.file.delete();
            this.file.createNewFile();
        }
        catch (IOException e) {
            ViaFabricPlus.global().getLogger().error("Failed to create file: {}!", (Object)this.file.getName(), (Object)e);
        }
        try (FileWriter fw = new FileWriter(this.file);){
            JsonObject parentNode = new JsonObject();
            this.write(parentNode);
            fw.write(GSON.toJson((JsonElement)parentNode));
            fw.flush();
        }
        catch (IOException e) {
            ViaFabricPlus.global().getLogger().error("Failed to write file: {}!", (Object)this.file.getName(), (Object)e);
        }
    }

    public abstract void write(JsonObject var1);

    public abstract void read(JsonObject var1);

    public void postInit() {
    }

    public File getFile() {
        return this.file;
    }
}

