/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.protocoltranslator.netty;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import de.florianmichael.viafabricplus.ViaFabricPlus;
import de.florianmichael.viafabricplus.fixes.viaversion.ViaFabricPlusProtocol;
import de.florianmichael.viafabricplus.protocoltranslator.netty.NoReadFlowControlHandler;
import de.florianmichael.viafabricplus.protocoltranslator.netty.ViaFabricPlusViaDecoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import net.raphimc.vialoader.netty.CompressionReorderEvent;
import net.raphimc.vialoader.netty.VLLegacyPipeline;

public class ViaFabricPlusVLLegacyPipeline
extends VLLegacyPipeline {
    public static final String VIA_FLOW_CONTROL = "via-flow-control";
    public static final String VIABEDROCK_COMPRESSION_HANDLER_NAME = "viabedrock-compression";
    public static final String VIABEDROCK_ENCRYPTION_HANDLER_NAME = "viabedrock-encryption";
    public static final String VIABEDROCK_PING_ENCAPSULATION_HANDLER_NAME = "viabedrock-ping-encapsulation";

    public ViaFabricPlusVLLegacyPipeline(UserConnection user, ProtocolVersion version) {
        super(user, version);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        ctx.pipeline().addAfter("via-decoder", VIA_FLOW_CONTROL, (ChannelHandler)new NoReadFlowControlHandler());
        this.user.getProtocolInfo().getPipeline().add((Protocol)ViaFabricPlusProtocol.INSTANCE);
    }

    protected ChannelHandler createViaDecoder() {
        return new ViaFabricPlusViaDecoder(this.user);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt.getClass().getName().equals("me.steinborn.krypton.mod.shared.misc.KryptonPipelineEvent") && evt.toString().equals("COMPRESSION_ENABLED")) {
            super.userEventTriggered(ctx, (Object)CompressionReorderEvent.INSTANCE);
            ViaFabricPlus.global().getLogger().info("Compression has been re-ordered after \"Krypton\"");
            return;
        }
        super.userEventTriggered(ctx, evt);
    }

    protected String decompressName() {
        return "decompress";
    }

    protected String compressName() {
        return "compress";
    }

    protected String packetDecoderName() {
        return "inbound_config";
    }

    protected String packetEncoderName() {
        return "encoder";
    }

    protected String lengthSplitterName() {
        return "splitter";
    }

    protected String lengthPrependerName() {
        return "prepender";
    }
}

