/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.protocoltranslator;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.platform.ViaInjector;
import com.viaversion.viaversion.api.platform.ViaPlatform;
import com.viaversion.viaversion.api.platform.ViaPlatformLoader;
import com.viaversion.viaversion.api.protocol.ProtocolPathEntry;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.protocol.version.VersionType;
import com.viaversion.viaversion.commands.ViaCommandHandler;
import com.viaversion.viaversion.connection.UserConnectionImpl;
import com.viaversion.viaversion.protocol.ProtocolPipelineImpl;
import de.florianmichael.viafabricplus.event.ChangeProtocolVersionCallback;
import de.florianmichael.viafabricplus.fixes.viaversion.ViaFabricPlusProtocol;
import de.florianmichael.viafabricplus.injection.access.IClientConnection;
import de.florianmichael.viafabricplus.protocoltranslator.impl.command.ViaFabricPlusVLCommandHandler;
import de.florianmichael.viafabricplus.protocoltranslator.impl.platform.ViaFabricPlusViaLegacyPlatformImpl;
import de.florianmichael.viafabricplus.protocoltranslator.impl.platform.ViaFabricPlusViaVersionPlatformImpl;
import de.florianmichael.viafabricplus.protocoltranslator.impl.viaversion.ViaFabricPlusVLInjector;
import de.florianmichael.viafabricplus.protocoltranslator.impl.viaversion.ViaFabricPlusVLLoader;
import de.florianmichael.viafabricplus.protocoltranslator.netty.ViaFabricPlusVLLegacyPipeline;
import de.florianmichael.viafabricplus.protocoltranslator.util.NoPacketSendChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.util.AttributeKey;
import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.lenni0451.reflect.stream.RStream;
import net.lenni0451.reflect.stream.field.FieldWrapper;
import net.minecraft.class_155;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import net.raphimc.vialoader.ViaLoader;
import net.raphimc.vialoader.impl.platform.ViaAprilFoolsPlatformImpl;
import net.raphimc.vialoader.impl.platform.ViaBackwardsPlatformImpl;
import net.raphimc.vialoader.impl.platform.ViaBedrockPlatformImpl;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.jetbrains.annotations.ApiStatus;

public class ProtocolTranslator {
    public static final AttributeKey<class_2535> CLIENT_CONNECTION_ATTRIBUTE_KEY = AttributeKey.newInstance((String)"viafabricplus-clientconnection");
    public static final AttributeKey<ProtocolVersion> TARGET_VERSION_ATTRIBUTE_KEY = AttributeKey.newInstance((String)"viafabricplus-targetversion");
    public static final ProtocolVersion NATIVE_VERSION = ProtocolVersion.v1_21;
    public static final ProtocolVersion AUTO_DETECT_PROTOCOL = new ProtocolVersion(VersionType.SPECIAL, -2, -1, "Auto Detect (1.7+ servers)", null){

        protected Comparator<ProtocolVersion> customComparator() {
            return (o1, o2) -> {
                if (o1 == AUTO_DETECT_PROTOCOL) {
                    return 1;
                }
                if (o2 == AUTO_DETECT_PROTOCOL) {
                    return -1;
                }
                return 0;
            };
        }

        public boolean isKnown() {
            return false;
        }
    };
    private static ProtocolVersion targetVersion = NATIVE_VERSION;
    private static ProtocolVersion previousVersion = null;

    @ApiStatus.Internal
    public static void injectViaPipeline(class_2535 connection, Channel channel) {
        IClientConnection mixinClientConnection = (IClientConnection)connection;
        ProtocolVersion serverVersion = mixinClientConnection.viaFabricPlus$getTargetVersion();
        if (serverVersion != NATIVE_VERSION) {
            channel.attr(CLIENT_CONNECTION_ATTRIBUTE_KEY).set((Object)connection);
            channel.attr(TARGET_VERSION_ATTRIBUTE_KEY).set((Object)serverVersion);
            if (serverVersion.equals((Object)BedrockProtocolVersion.bedrockLatest)) {
                channel.config().setOption(RakChannelOption.RAK_PROTOCOL_VERSION, (Object)11);
                channel.config().setOption(RakChannelOption.RAK_COMPATIBILITY_MODE, (Object)true);
                channel.config().setOption(RakChannelOption.RAK_CLIENT_INTERNAL_ADDRESSES, (Object)20);
                channel.config().setOption(RakChannelOption.RAK_TIME_BETWEEN_SEND_CONNECTION_ATTEMPTS_MS, (Object)500);
                channel.config().setOption(RakChannelOption.RAK_CONNECT_TIMEOUT, (Object)((Integer)channel.config().getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS)).longValue());
                channel.config().setOption(RakChannelOption.RAK_SESSION_TIMEOUT, (Object)30000L);
                channel.config().setOption(RakChannelOption.RAK_GUID, (Object)ThreadLocalRandom.current().nextLong());
            }
            UserConnectionImpl user = new UserConnectionImpl(channel, true);
            new ProtocolPipelineImpl((UserConnection)user);
            mixinClientConnection.viaFabricPlus$setUserConnection((UserConnection)user);
            channel.pipeline().addLast(new ChannelHandler[]{new ViaFabricPlusVLLegacyPipeline((UserConnection)user, serverVersion)});
        }
    }

    public static ProtocolVersion getTargetVersion() {
        return targetVersion;
    }

    public static ProtocolVersion getTargetVersion(Channel channel) {
        if (channel == null || !channel.hasAttr(TARGET_VERSION_ATTRIBUTE_KEY)) {
            throw new IllegalStateException("Target version attribute not set");
        }
        return (ProtocolVersion)channel.attr(TARGET_VERSION_ATTRIBUTE_KEY).get();
    }

    public static void setTargetVersion(ProtocolVersion newVersion) {
        ProtocolTranslator.setTargetVersion(newVersion, false);
    }

    public static void setTargetVersion(ProtocolVersion newVersion, boolean revertOnDisconnect) {
        if (newVersion == null) {
            return;
        }
        ProtocolVersion oldVersion = targetVersion;
        targetVersion = newVersion;
        if (oldVersion != newVersion) {
            if (revertOnDisconnect) {
                previousVersion = oldVersion;
            }
            ((ChangeProtocolVersionCallback)ChangeProtocolVersionCallback.EVENT.invoker()).onChangeProtocolVersion(oldVersion, targetVersion);
        }
    }

    @ApiStatus.Internal
    public static void injectPreviousVersionReset(Channel channel) {
        if (previousVersion == null) {
            return;
        }
        channel.closeFuture().addListener(future -> {
            ProtocolTranslator.setTargetVersion(previousVersion);
            previousVersion = null;
        });
    }

    public static UserConnection createDummyUserConnection(ProtocolVersion clientVersion, ProtocolVersion serverVersion) {
        UserConnectionImpl user = new UserConnectionImpl((Channel)NoPacketSendChannel.INSTANCE, true);
        ProtocolPipelineImpl pipeline = new ProtocolPipelineImpl((UserConnection)user);
        List path = Via.getManager().getProtocolManager().getProtocolPath(clientVersion, serverVersion);
        if (path != null) {
            for (ProtocolPathEntry pair : path) {
                pipeline.add(pair.protocol());
                pair.protocol().init((UserConnection)user);
            }
        }
        ProtocolInfo info = user.getProtocolInfo();
        info.setState(State.PLAY);
        info.setProtocolVersion(clientVersion);
        info.setServerProtocolVersion(serverVersion);
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            GameProfile profile = mc.field_1724.method_7334();
            info.setUsername(profile.getName());
            info.setUuid(profile.getId());
        }
        return user;
    }

    public static UserConnection getPlayNetworkUserConnection() {
        class_634 handler = class_310.method_1551().method_1562();
        if (handler == null) {
            return null;
        }
        return ((IClientConnection)handler.method_48296()).viaFabricPlus$getUserConnection();
    }

    private static void patchConfigs(File directory) {
        directory.mkdirs();
        try {
            File viaVersionConfig = new File(directory, "viaversion.yml");
            Files.writeString(viaVersionConfig.toPath(), (CharSequence)"fix-infested-block-breaking: false\nshield-blocking: false\nno-delay-shield-blocking: true\nhandle-invalid-item-count: true\n", StandardOpenOption.CREATE_NEW);
        }
        catch (FileAlreadyExistsException viaVersionConfig) {
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to patch ViaVersion config", e);
        }
        try {
            File viaLegacyConfig = new File(directory, "vialegacy.yml");
            Files.writeString(viaLegacyConfig.toPath(), (CharSequence)"legacy-skull-loading: true\nlegacy-skin-loading: true\n", StandardOpenOption.CREATE_NEW);
        }
        catch (FileAlreadyExistsException viaLegacyConfig) {
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to patch ViaLegacy config", e);
        }
    }

    private static void changeBedrockProtocolName() {
        ProtocolVersion bedrockLatest = (ProtocolVersion)RStream.of(BedrockProtocolVersion.class).fields().by("bedrockLatest").get();
        FieldWrapper name = RStream.of((Object)bedrockLatest).withSuper().fields().by("name");
        name.set((Object)(String.valueOf(name.get()) + " (Work in progress)"));
    }

    @Deprecated
    private static void migrateOldConfigs(File directory) {
        File oldDirectory = new File(directory, "ViaLoader");
        if (oldDirectory.exists()) {
            for (File file : oldDirectory.listFiles()) {
                file.renameTo(new File(directory, file.getName()));
            }
            oldDirectory.delete();
        }
    }

    @ApiStatus.Internal
    public static CompletableFuture<Void> init(File directory) {
        if (class_155.method_31372() != NATIVE_VERSION.getOriginalVersion()) {
            throw new IllegalStateException("Native version is not the same as the current version");
        }
        ProtocolTranslator.migrateOldConfigs(directory);
        ProtocolTranslator.patchConfigs(directory);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            ViaFabricPlusVLCommandHandler commandHandler = (ViaFabricPlusVLCommandHandler)Via.getManager().getCommandHandler();
            RequiredArgumentBuilder executor = ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(commandHandler::execute)).suggests(commandHandler::suggestion);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"viafabricplus").then((ArgumentBuilder)executor)).executes(commandHandler::execute));
        });
        return CompletableFuture.runAsync(() -> {
            ViaLoader.init((ViaPlatform)new ViaFabricPlusViaVersionPlatformImpl(directory), (ViaPlatformLoader)new ViaFabricPlusVLLoader(), (ViaInjector)new ViaFabricPlusVLInjector(), (ViaCommandHandler)new ViaFabricPlusVLCommandHandler(), (Supplier[])new Supplier[]{ViaBackwardsPlatformImpl::new, ViaFabricPlusViaLegacyPlatformImpl::new, ViaAprilFoolsPlatformImpl::new, ViaBedrockPlatformImpl::new});
            ProtocolVersion.register((ProtocolVersion)AUTO_DETECT_PROTOCOL);
            ProtocolTranslator.changeBedrockProtocolName();
            ViaFabricPlusProtocol.INSTANCE.initialize();
        });
    }
}

