/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.injection.mixin.fixes.viaversion;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.data.AttributeModifiers1_20_5;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.v1_8to1_9.Protocol1_8To1_9;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ServerboundPackets1_9;
import com.viaversion.viaversion.protocols.v1_8to1_9.rewriter.ItemPacketRewriter1_9;
import com.viaversion.viaversion.rewriter.ItemRewriter;
import com.viaversion.viaversion.util.Pair;
import de.florianmichael.viafabricplus.protocoltranslator.impl.ViaFabricPlusMappingDataLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemPacketRewriter1_9.class}, remap=false)
public abstract class MixinItemPacketRewriter1_9
extends ItemRewriter<ClientboundPackets1_8, ServerboundPackets1_9, Protocol1_8To1_9> {
    @Unique
    private final Int2ObjectMap<String> viaFabricPlus$itemIdentifiers = new Int2ObjectOpenHashMap();
    @Unique
    private final Map<String, Map<String, Pair<String, AttributeModifiers1_20_5.ModifierData>>> viaFabricPlus$itemAttributes = new HashMap<String, Map<String, Pair<String, AttributeModifiers1_20_5.ModifierData>>>();

    public MixinItemPacketRewriter1_9(Protocol1_8To1_9 protocol, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType) {
        super((Protocol)protocol, itemType, itemArrayType, mappedItemType, mappedItemArrayType);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void loadAdditionalData(CallbackInfo ci) {
        JsonObject itemIdentifiers = ViaFabricPlusMappingDataLoader.INSTANCE.loadData("item-identifiers-1.8.json");
        for (Map.Entry entry : itemIdentifiers.entrySet()) {
            this.viaFabricPlus$itemIdentifiers.put(((JsonElement)entry.getValue()).getAsInt(), (Object)((String)entry.getKey()));
        }
        JsonObject itemAttributes = ViaFabricPlusMappingDataLoader.INSTANCE.loadData("item-attributes-1.8.json");
        for (Map.Entry itemEntry : itemAttributes.entrySet()) {
            String itemIdentifier = (String)itemEntry.getKey();
            HashMap<String, Pair> attributes = new HashMap<String, Pair>();
            for (Map.Entry attributeEntry : ((JsonElement)itemEntry.getValue()).getAsJsonObject().entrySet()) {
                String attribute = (String)attributeEntry.getKey();
                JsonObject attributeData = ((JsonElement)attributeEntry.getValue()).getAsJsonObject();
                AttributeModifiers1_20_5.ModifierData modifierData = new AttributeModifiers1_20_5.ModifierData(UUID.fromString(attributeData.get("id").getAsString()), attributeData.get("name").getAsString(), attributeData.get("amount").getAsDouble(), attributeData.get("operation").getAsInt());
                String slot = attributeData.get("slot").getAsString();
                attributes.put(attribute, new Pair((Object)slot, (Object)modifierData));
            }
            this.viaFabricPlus$itemAttributes.put(itemIdentifier, attributes);
        }
    }

    @Inject(method={"handleItemToClient"}, at={@At(value="RETURN")})
    private void addAttributeFixData(CallbackInfoReturnable<Item> cir) {
        Item item = (Item)cir.getReturnValue();
        if (item == null) {
            return;
        }
        String identifier = (String)this.viaFabricPlus$itemIdentifiers.get(item.identifier());
        if (identifier != null && this.viaFabricPlus$itemAttributes.containsKey(identifier)) {
            Map<String, Pair<String, AttributeModifiers1_20_5.ModifierData>> attributes = this.viaFabricPlus$itemAttributes.get(identifier);
            CompoundTag attributeFixTag = new CompoundTag();
            CompoundTag tag = item.tag();
            if (tag == null) {
                tag = new CompoundTag();
                item.setTag(tag);
                attributeFixTag.putBoolean("RemoveTag", true);
            }
            tag.put(this.nbtTagName("attributeFix"), (Tag)attributeFixTag);
            ListTag attributeModifiers = tag.getListTag("AttributeModifiers", CompoundTag.class);
            if (attributeModifiers == null) {
                attributeModifiers = new ListTag(CompoundTag.class);
                for (Map.Entry<String, Pair<String, AttributeModifiers1_20_5.ModifierData>> entry : attributes.entrySet()) {
                    CompoundTag attributeModifier = new CompoundTag();
                    attributeModifier.putString("AttributeName", entry.getKey());
                    attributeModifier.putString("Name", ((AttributeModifiers1_20_5.ModifierData)entry.getValue().value()).name());
                    attributeModifier.putDouble("Amount", ((AttributeModifiers1_20_5.ModifierData)entry.getValue().value()).amount());
                    attributeModifier.putInt("Operation", ((AttributeModifiers1_20_5.ModifierData)entry.getValue().value()).operation());
                    attributeModifier.putLong("UUIDMost", ((AttributeModifiers1_20_5.ModifierData)entry.getValue().value()).uuid().getMostSignificantBits());
                    attributeModifier.putLong("UUIDLeast", ((AttributeModifiers1_20_5.ModifierData)entry.getValue().value()).uuid().getLeastSignificantBits());
                    attributeModifier.putString("Slot", (String)entry.getValue().key());
                    attributeModifiers.add((Tag)attributeModifier);
                }
                tag.put("AttributeModifiers", (Tag)attributeModifiers);
                attributeFixTag.putBoolean("RemoveAttributeModifiers", true);
            }
        }
    }

    @Inject(method={"handleItemToServer"}, at={@At(value="RETURN")})
    private void removeAttributeFixData(CallbackInfoReturnable<Item> cir) {
        Item item = (Item)cir.getReturnValue();
        if (item == null) {
            return;
        }
        CompoundTag tag = item.tag();
        if (tag == null) {
            return;
        }
        CompoundTag attributeFixTag = (CompoundTag)tag.removeUnchecked(this.nbtTagName("attributeFix"));
        if (attributeFixTag == null) {
            return;
        }
        if (attributeFixTag.contains("RemoveAttributeModifiers")) {
            tag.remove("AttributeModifiers");
        }
        if (attributeFixTag.contains("RemoveTag")) {
            item.setTag(null);
        }
    }
}

