/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.injection.mixin.fixes.minecraft.screen.hud;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import de.florianmichael.viafabricplus.injection.access.IPlayerListEntry;
import de.florianmichael.viafabricplus.injection.access.IPlayerListHud;
import de.florianmichael.viafabricplus.settings.impl.VisualSettings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import net.minecraft.class_355;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_355.class})
public abstract class MixinPlayerListHud
implements IPlayerListHud {
    @Shadow
    @Final
    private class_310 field_2155;
    @Unique
    private static final Comparator<class_640> viaFabricPlus$FIFO_COMPARATOR = Comparator.comparingInt(e -> ((IPlayerListEntry)e).viaFabricPlus$getIndex());
    @Unique
    private int viaFabricPlus$maxSlots;
    @Unique
    private boolean viaFabricPlus$hideSkins = true;

    @Inject(method={"collectPlayerEntries"}, at={@At(value="HEAD")}, cancellable=true)
    private void collectPlayerEntries(CallbackInfoReturnable<List<class_640>> result) {
        if (VisualSettings.global().enableLegacyTablist.isEnabled()) {
            result.setReturnValue((Object)this.field_2155.field_1724.field_3944.method_45732().stream().sorted(viaFabricPlus$FIFO_COMPARATOR).limit(this.viaFabricPlus$maxSlots).collect(Collectors.collectingAndThen(Collectors.toList(), this::viaFabricPlus$transpose)));
        } else {
            this.viaFabricPlus$hideSkins = false;
        }
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/ClientConnection;isEncrypted()Z")})
    private boolean hideSkins(boolean original) {
        return original && !this.viaFabricPlus$hideSkins;
    }

    @Unique
    private List<class_640> viaFabricPlus$transpose(List<class_640> list) {
        if (list.size() != this.viaFabricPlus$maxSlots) {
            this.viaFabricPlus$hideSkins = list.stream().noneMatch(e -> e.method_2966().getProperties().containsKey((Object)"textures"));
            return list;
        }
        ArrayList<class_640> result = new ArrayList<class_640>(list.size());
        int columns = this.viaFabricPlus$maxSlots / 20;
        boolean anyHasSkinData = false;
        for (int i = 0; i < this.viaFabricPlus$maxSlots; ++i) {
            int row = i % 20;
            int col = i / 20;
            class_640 current = list.get(row * columns + col);
            result.add(current);
            anyHasSkinData = anyHasSkinData || current.method_2966().getProperties().containsKey((Object)"textures");
        }
        this.viaFabricPlus$hideSkins = !anyHasSkinData;
        return result;
    }

    @Override
    public void viaFabricPlus$setMaxPlayers(int maxPlayers) {
        this.viaFabricPlus$maxSlots = Math.min(200, Math.max(20, (maxPlayers + 20 - 1) / 20 * 20));
    }
}

