/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.injection.mixin.fixes.minecraft.item;

import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import de.florianmichael.viafabricplus.fixes.versioned.Enchantments1_14_4;
import de.florianmichael.viafabricplus.protocoltranslator.ProtocolTranslator;
import de.florianmichael.viafabricplus.util.ItemUtil;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9299;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1799.class})
public abstract class MixinItemStack {
    @Shadow
    public abstract class_1792 method_7909();

    @Inject(method={"appendTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends class_9299> void replaceEnchantmentTooltip(class_9331<T> componentType, class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, CallbackInfo ci) {
        if (ProtocolTranslator.getTargetVersion().newerThan(ProtocolVersion.v1_14_4)) {
            return;
        }
        class_2487 tag = ItemUtil.getTagOrNull((class_1799)this);
        if (tag == null) {
            return;
        }
        if (componentType == class_9334.field_49633) {
            this.viaFabricPlus$appendEnchantments1_14_4("Enchantments", tag, context, textConsumer);
            ci.cancel();
        } else if (componentType == class_9334.field_49643) {
            this.viaFabricPlus$appendEnchantments1_14_4("StoredEnchantments", tag, context, textConsumer);
            ci.cancel();
        }
    }

    @Redirect(method={"appendAttributeModifierTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttributeBaseValue(Lnet/minecraft/registry/entry/RegistryEntry;)D", ordinal=0))
    private double fixAttackDamageCalculation(class_1657 instance, class_6880<class_1320> registryEntry) {
        double value = 0.0;
        if (ProtocolTranslator.getTargetVersion().olderThanOrEqualTo(ProtocolVersion.v1_20_5)) {
            class_9304 enchantments = class_1890.method_57532((class_1799)((class_1799)this));
            for (class_6880 enchantment : enchantments.method_57534()) {
                if (!enchantment.method_40225(class_1893.field_9118)) continue;
                int level = enchantments.method_57536(enchantment);
                if (ProtocolTranslator.getTargetVersion().olderThanOrEqualTo(ProtocolVersion.v1_8)) {
                    value = (float)level * 1.25f;
                    break;
                }
                value = 1.0f + (float)Math.max(0, level - 1) * 0.5f;
                break;
            }
        }
        if (ProtocolTranslator.getTargetVersion().olderThanOrEqualTo(ProtocolVersion.v1_8)) {
            return value;
        }
        return instance.method_45326(registryEntry) + value;
    }

    @Unique
    private void viaFabricPlus$appendEnchantments1_14_4(String name, class_2487 nbt, class_1792.class_9635 context, Consumer<class_2561> tooltip) {
        class_7225.class_7874 registryLookup = context.method_59527();
        class_2499 enchantments = nbt.method_10554(name, 10);
        for (class_2520 element : enchantments) {
            class_2487 enchantment = (class_2487)element;
            String id = enchantment.method_10558("id");
            Optional<class_5321<class_1887>> value = Enchantments1_14_4.getOrEmpty(id);
            value.ifPresent(e -> {
                int lvl = enchantment.method_10550("lvl");
                if (registryLookup != null) {
                    Optional v = registryLookup.method_46762(class_7924.field_41265).method_46746(e);
                    v.ifPresent(enchantmentReference -> tooltip.accept(class_1887.method_8179((class_6880)enchantmentReference, (int)class_3532.method_15340((int)lvl, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE))));
                }
            });
        }
    }
}

