/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.injection.mixin.fixes.authlib;

import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.yggdrasil.YggdrasilUserApiService;
import com.mojang.authlib.yggdrasil.response.KeyPairResponse;
import de.florianmichael.viafabricplus.ViaFabricPlus;
import de.florianmichael.viafabricplus.fixes.versioned.KeyPairResponse1_19_0;
import de.florianmichael.viafabricplus.injection.access.ILegacyKeySignatureStorage;
import java.net.URL;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={YggdrasilUserApiService.class}, remap=false)
public abstract class MixinYggdrasilUserApiService {
    @Shadow
    @Final
    private MinecraftClient minecraftClient;
    @Shadow
    @Final
    private URL routeKeyPair;

    @Inject(method={"getKeyPair"}, at={@At(value="HEAD")}, cancellable=true)
    private void storeLegacyPublicKeySignature(CallbackInfoReturnable<KeyPairResponse> cir) {
        KeyPairResponse1_19_0 response = (KeyPairResponse1_19_0)this.minecraftClient.post(this.routeKeyPair, KeyPairResponse1_19_0.class);
        if (response == null) {
            cir.setReturnValue(null);
            return;
        }
        KeyPairResponse keyPairResponse = new KeyPairResponse(response.keyPair(), response.publicKeySignatureV2(), response.expiresAt(), response.refreshedAfter());
        if (response.publicKeySignature() != null && response.publicKeySignature().array().length != 0) {
            ((ILegacyKeySignatureStorage)keyPairResponse).viafabricplus$setLegacyPublicKeySignature(response.publicKeySignature().array());
        } else {
            ViaFabricPlus.global().getLogger().error("Could not get legacy public key signature. 1.19.0 with secure-profiles enabled will not work!");
        }
        cir.setReturnValue((Object)keyPairResponse);
    }
}

