/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus.fixes.versioned.classic;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_17;
import com.viaversion.viaversion.exception.InformativeException;
import java.util.ArrayList;
import java.util.BitSet;
import net.raphimc.vialegacy.api.LegacyProtocolVersion;
import net.raphimc.vialegacy.protocol.classic.c0_28_30toa1_0_15.model.ClassicLevel;
import net.raphimc.vialegacy.protocol.classic.c0_28_30toa1_0_15.provider.ClassicWorldHeightProvider;
import net.raphimc.vialegacy.protocol.classic.c0_28_30toa1_0_15.storage.ClassicLevelStorage;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WorldHeightSupport {
    public static PacketHandler handleJoinGame(PacketHandler parentHandler) {
        return wrapper -> {
            parentHandler.handle(wrapper);
            if (wrapper.isCancelled()) {
                return;
            }
            if (wrapper.user().getProtocolInfo().serverProtocolVersion().olderThanOrEqualTo(LegacyProtocolVersion.c0_28toc0_30)) {
                for (CompoundTag dimension : ((CompoundTag)wrapper.get(Types.NAMED_COMPOUND_TAG, 0)).getCompoundTag("minecraft:dimension_type").getListTag("value", CompoundTag.class)) {
                    WorldHeightSupport.changeDimensionTagHeight(wrapper.user(), dimension.getCompoundTag("element"));
                }
                WorldHeightSupport.changeDimensionTagHeight(wrapper.user(), (CompoundTag)wrapper.get(Types.NAMED_COMPOUND_TAG, 1));
            }
        };
    }

    public static PacketHandler handleRespawn(PacketHandler parentHandler) {
        return wrapper -> {
            parentHandler.handle(wrapper);
            if (wrapper.isCancelled()) {
                return;
            }
            if (wrapper.user().getProtocolInfo().serverProtocolVersion().olderThanOrEqualTo(LegacyProtocolVersion.c0_28toc0_30)) {
                WorldHeightSupport.changeDimensionTagHeight(wrapper.user(), (CompoundTag)wrapper.get(Types.NAMED_COMPOUND_TAG, 0));
            }
        };
    }

    public static PacketHandler handleChunkData(PacketHandler parentHandler) {
        return wrapper -> {
            parentHandler.handle(wrapper);
            if (wrapper.isCancelled()) {
                return;
            }
            if (wrapper.user().getProtocolInfo().serverProtocolVersion().olderThanOrEqualTo(LegacyProtocolVersion.c0_28toc0_30)) {
                wrapper.resetReader();
                Chunk chunk = (Chunk)wrapper.read((Type)new ChunkType1_17(16));
                wrapper.write((Type)new ChunkType1_17(chunk.getSections().length), (Object)chunk);
                ClassicWorldHeightProvider heightProvider = (ClassicWorldHeightProvider)Via.getManager().getProviders().get(ClassicWorldHeightProvider.class);
                if (chunk.getSections().length < heightProvider.getMaxChunkSectionCount(wrapper.user())) {
                    ChunkSection[] newArray = new ChunkSection[heightProvider.getMaxChunkSectionCount(wrapper.user())];
                    System.arraycopy(chunk.getSections(), 0, newArray, 0, chunk.getSections().length);
                    chunk.setSections(newArray);
                }
                BitSet chunkMask = new BitSet();
                for (int i = 0; i < chunk.getSections().length; ++i) {
                    if (chunk.getSections()[i] == null) continue;
                    chunkMask.set(i);
                }
                chunk.setChunkMask(chunkMask);
                int[] newBiomeData = new int[chunk.getSections().length * 4 * 4 * 4];
                System.arraycopy(chunk.getBiomeData(), 0, newBiomeData, 0, chunk.getBiomeData().length);
                for (int i = 64; i < chunk.getSections().length * 4; ++i) {
                    System.arraycopy(chunk.getBiomeData(), chunk.getBiomeData().length - 16, newBiomeData, i * 16, 16);
                }
                chunk.setBiomeData(newBiomeData);
                chunk.setHeightMap(new CompoundTag());
            }
        };
    }

    public static PacketHandler handleUpdateLight(PacketHandler parentHandler) {
        PacketHandlers classicLightHandler = new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    short i;
                    wrapper.read((Type)Types.VAR_INT);
                    wrapper.read((Type)Types.VAR_INT);
                    int emptySkyLightMask = (Integer)wrapper.read((Type)Types.VAR_INT);
                    int emptyBlockLightMask = (Integer)wrapper.read((Type)Types.VAR_INT);
                    ClassicLevel level = ((ClassicLevelStorage)wrapper.user().get(ClassicLevelStorage.class)).getClassicLevel();
                    ClassicWorldHeightProvider heightProvider = (ClassicWorldHeightProvider)Via.getManager().getProviders().get(ClassicWorldHeightProvider.class);
                    short sectionYCount = level.getSizeY() >> 4;
                    if (level.getSizeY() % 16 != 0) {
                        ++sectionYCount;
                    }
                    if (sectionYCount > heightProvider.getMaxChunkSectionCount(wrapper.user())) {
                        sectionYCount = heightProvider.getMaxChunkSectionCount(wrapper.user());
                    }
                    ArrayList<byte[]> lightArrays = new ArrayList<byte[]>();
                    while (wrapper.isReadable(Types.BYTE_ARRAY_PRIMITIVE, 0)) {
                        lightArrays.add((byte[])wrapper.read(Types.BYTE_ARRAY_PRIMITIVE));
                    }
                    short skyLightCount = 16;
                    short blockLightCount = sectionYCount;
                    if (lightArrays.size() == 18) {
                        blockLightCount = 0;
                    } else if (lightArrays.size() != 16 + sectionYCount + 2 && lightArrays.size() == sectionYCount + sectionYCount + 2) {
                        skyLightCount = sectionYCount;
                    }
                    BitSet skyLightMask = new BitSet();
                    BitSet blockLightMask = new BitSet();
                    skyLightMask.set(0, skyLightCount += 2);
                    blockLightMask.set(0, blockLightCount);
                    wrapper.write(Types.LONG_ARRAY_PRIMITIVE, (Object)skyLightMask.toLongArray());
                    wrapper.write(Types.LONG_ARRAY_PRIMITIVE, (Object)blockLightMask.toLongArray());
                    wrapper.write(Types.LONG_ARRAY_PRIMITIVE, (Object)new long[emptySkyLightMask]);
                    wrapper.write(Types.LONG_ARRAY_PRIMITIVE, (Object)new long[emptyBlockLightMask]);
                    wrapper.write((Type)Types.VAR_INT, (Object)skyLightCount);
                    for (i = 0; i < skyLightCount; ++i) {
                        wrapper.write(Types.BYTE_ARRAY_PRIMITIVE, (Object)((byte[])lightArrays.remove(0)));
                    }
                    wrapper.write((Type)Types.VAR_INT, (Object)blockLightCount);
                    for (i = 0; i < blockLightCount; ++i) {
                        wrapper.write(Types.BYTE_ARRAY_PRIMITIVE, (Object)((byte[])lightArrays.remove(0)));
                    }
                });
            }
        };
        return arg_0 -> WorldHeightSupport.lambda$handleUpdateLight$3((PacketHandler)classicLightHandler, parentHandler, arg_0);
    }

    private static void changeDimensionTagHeight(UserConnection user, CompoundTag tag) {
        tag.putInt("height", ((ClassicWorldHeightProvider)Via.getManager().getProviders().get(ClassicWorldHeightProvider.class)).getMaxChunkSectionCount(user) << 4);
    }

    private static /* synthetic */ void lambda$handleUpdateLight$3(PacketHandler classicLightHandler, PacketHandler parentHandler, PacketWrapper wrapper) throws InformativeException {
        if (wrapper.user().getProtocolInfo().serverProtocolVersion().olderThanOrEqualTo(LegacyProtocolVersion.c0_28toc0_30)) {
            classicLightHandler.handle(wrapper);
        } else {
            parentHandler.handle(wrapper);
        }
    }
}

