/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viafabricplus;

import de.florianmichael.viafabricplus.event.PostGameLoadCallback;
import de.florianmichael.viafabricplus.fixes.ClientsideFixes;
import de.florianmichael.viafabricplus.protocoltranslator.ProtocolTranslator;
import de.florianmichael.viafabricplus.save.SaveManager;
import de.florianmichael.viafabricplus.settings.SettingsManager;
import de.florianmichael.viafabricplus.util.ClassLoaderPriorityUtil;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ViaFabricPlus {
    private static final ViaFabricPlus INSTANCE = new ViaFabricPlus();
    private final Logger logger = LogManager.getLogger((String)"ViaFabricPlus");
    private final File directory = FabricLoader.getInstance().getConfigDir().resolve("viafabricplus").toFile();
    private SettingsManager settingsManager;
    private SaveManager saveManager;
    private CompletableFuture<Void> loadingFuture;

    public void init() {
        this.directory.mkdir();
        ClassLoaderPriorityUtil.loadOverridingJars(this.directory);
        this.settingsManager = new SettingsManager();
        this.saveManager = new SaveManager(this.settingsManager);
        ClientsideFixes.init();
        this.loadingFuture = ProtocolTranslator.init(this.directory);
        PostGameLoadCallback.EVENT.register(() -> {
            this.loadingFuture.join();
            this.saveManager.postInit();
        });
    }

    public static ViaFabricPlus global() {
        return INSTANCE;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public File getDirectory() {
        return this.directory;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public SaveManager getSaveManager() {
        return this.saveManager;
    }
}

