/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.util;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.mixin.accessor.KeyMappingAccessor;
import dev.terminalmc.commandkeys.util.Localization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class KeybindUtil {
    public static boolean handleKey(class_3675.class_306 key) {
        boolean cancel = false;
        boolean cancelNext = false;
        if (class_310.method_1551().field_1755 == null && CommandKeys.profile().keyMacroMap.containsKey((Object)key)) {
            long window = class_310.method_1551().method_22683().method_4490();
            boolean onlyLimit = false;
            Collection allKeys = CommandKeys.profile().keyMacroMap.get((Object)key);
            for (Object macro : allKeys) {
                if (((Macro)macro).getConflictStrategy().equals((Object)Macro.ConflictStrategy.AVOID) || ((Macro)macro).getLimitKey().equals((Object)class_3675.field_16237) || !class_3675.method_15987((long)window, (int)((Macro)macro).getLimitKey().method_1444())) continue;
                onlyLimit = true;
                break;
            }
            ArrayList<Macro> sendKeys = new ArrayList<Macro>();
            if (onlyLimit) {
                for (Macro macro : allKeys) {
                    if (macro.getConflictStrategy().equals((Object)Macro.ConflictStrategy.AVOID) || macro.getLimitKey().equals((Object)class_3675.field_16237) || !class_3675.method_15987((long)window, (int)macro.getLimitKey().method_1444())) continue;
                    sendKeys.add(macro);
                }
            } else {
                for (Macro macro : allKeys) {
                    if (macro.getConflictStrategy().equals((Object)Macro.ConflictStrategy.AVOID) || !macro.getLimitKey().equals((Object)class_3675.field_16237)) continue;
                    sendKeys.add(macro);
                }
            }
            boolean override = false;
            for (Macro macro : sendKeys) {
                boolean send = true;
                switch (macro.getConflictStrategy()) {
                    case SUBMIT: {
                        send = KeybindUtil.getConflict(key) == null;
                        break;
                    }
                    case VETO: {
                        override = true;
                    }
                }
                if (!send) continue;
                cancelNext = macro.trigger();
            }
            if (override) {
                cancel = true;
            }
        }
        if (!cancel) {
            class_304.method_1420((class_3675.class_306)key);
        }
        return cancelNext;
    }

    @Nullable
    public static class_304 getConflict(class_3675.class_306 key) {
        for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
            if (!((KeyMappingAccessor)keyMapping).getKey().equals((Object)key)) continue;
            return keyMapping;
        }
        return null;
    }

    public static class_5250[] getKeybindInfo(Macro macro) {
        class_5250 conflictLabel;
        class_5250 label;
        class_5250 tooltip = class_2561.method_43473();
        boolean[] conflict = new boolean[]{false, false};
        boolean checkMcKeys = !macro.getConflictStrategy().equals((Object)Macro.ConflictStrategy.AVOID);
        KeybindUtil.checkConflict(macro.getLimitKey(), macro.profile, conflict, tooltip, checkMcKeys);
        KeybindUtil.checkConflict(macro.getKey(), macro.profile, conflict, tooltip, checkMcKeys);
        class_5250 class_52502 = label = macro.getLimitKey().equals((Object)class_3675.field_16237) ? macro.getKey().method_27445().method_27661() : macro.getLimitKey().method_27445().method_27661().method_27693(" + ").method_10852(macro.getKey().method_27445());
        if (conflict[1]) {
            conflictLabel = class_2561.method_43470((String)"[ ").method_10852((class_2561)label.method_27692(class_124.field_1068)).method_27693(" ]").method_27692(class_124.field_1061);
            tooltip.method_27693("\n");
            tooltip.method_10852((class_2561)Localization.localized("option", "key.bind.tooltip.conflict_strategy", KeybindUtil.localizeConflictStrategy(macro.getConflictStrategy())));
        } else {
            conflictLabel = conflict[0] ? class_2561.method_43470((String)"[ ").method_10852((class_2561)label.method_27692(class_124.field_1068)).method_27693(" ]").method_27692(class_124.field_1065) : label;
        }
        return new class_5250[]{label, conflictLabel, tooltip};
    }

    public static void checkConflict(class_3675.class_306 key, Profile profile, boolean[] conflict, class_5250 tooltip, boolean checkMcKeys) {
        if (!key.equals((Object)class_3675.field_16237)) {
            class_304 conflictingMcKey;
            if (profile.keyMacroMap.get((Object)key).size() > 1) {
                tooltip.method_10852((class_2561)Localization.localized("option", "key.bind.tooltip.conflict.internal", key.method_27445().method_27661().method_27692(class_124.field_1065))).method_27692(class_124.field_1068);
                conflict[0] = true;
            }
            if (checkMcKeys && (conflictingMcKey = KeybindUtil.getConflict(key)) != null) {
                if (conflict[0] || conflict[1]) {
                    tooltip.method_27693("\n");
                }
                tooltip.method_10852((class_2561)Localization.localized("option", "key.bind.tooltip.conflict.external", key.method_27445().method_27661().method_27692(class_124.field_1061), class_2561.method_43471((String)conflictingMcKey.method_1431()).method_27692(class_124.field_1080))).method_27692(class_124.field_1068);
                conflict[1] = true;
            }
        }
    }

    public static class_2561 localizeConflictStrategy(Macro.ConflictStrategy strategy) {
        class_5250 class_52502 = Localization.localized("option", "key.conflict." + strategy.toString().toLowerCase(Locale.ROOT), new Object[0]);
        return class_52502.method_27692(switch (strategy) {
            default -> throw new MatchException(null, null);
            case Macro.ConflictStrategy.SUBMIT -> class_124.field_1060;
            case Macro.ConflictStrategy.ASSERT -> class_124.field_1065;
            case Macro.ConflictStrategy.VETO -> class_124.field_1061;
            case Macro.ConflictStrategy.AVOID -> class_124.field_1062;
        });
    }

    public static class_2561 localizeConflictStrategyTooltip(Macro.ConflictStrategy strategy) {
        return Localization.localized("option", "key.conflict." + strategy.toString().toLowerCase(Locale.ROOT) + ".tooltip", new Object[0]);
    }

    public static class_2561 localizeSendMode(Macro.SendMode mode) {
        class_5250 class_52502 = Localization.localized("option", "key.mode." + mode.toString().toLowerCase(Locale.ROOT), new Object[0]);
        return class_52502.method_27692(switch (mode) {
            default -> throw new MatchException(null, null);
            case Macro.SendMode.SEND -> class_124.field_1060;
            case Macro.SendMode.TYPE -> class_124.field_1065;
            case Macro.SendMode.CYCLE -> class_124.field_1062;
            case Macro.SendMode.REPEAT -> class_124.field_1076;
        });
    }

    public static class_2561 localizeSendModeTooltip(Macro.SendMode mode) {
        return Localization.localized("option", "key.mode." + mode.toString().toLowerCase(Locale.ROOT) + ".tooltip", new Object[0]);
    }
}

