/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.OptionsScreen;
import dev.terminalmc.commandkeys.gui.widget.list.MacroBindList;
import dev.terminalmc.commandkeys.gui.widget.list.MacroOptionList;
import dev.terminalmc.commandkeys.gui.widget.list.MainOptionList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ProfileOptionList
extends MacroBindList {
    private int dragSourceSlot = -1;

    public ProfileOptionList(class_310 mc, int width, int height, int y, int itemHeight, int entryWidth, int entryHeight, @NotNull Profile profile) {
        super(mc, width, height, y, itemHeight, entryWidth, entryHeight);
        this.profile = profile;
        this.method_25321((class_350.class_351)new Entry.ScreenSwitchEntry(this.entryX, entryWidth, entryHeight, this));
        this.method_25321((class_350.class_351)new Entry.HudAndHistoryEntry(this.entryX, entryWidth, entryHeight, this));
        this.method_25321((class_350.class_351)new OptionList.Entry.TextEntry(this.entryX, entryWidth, entryHeight, (class_2561)Localization.localized("option", "profile.keys", "\u2139"), class_7919.method_47407((class_2561)Localization.localized("option", "profile.keys.tooltip", new Object[0])), 500));
        for (Macro macro : profile.getMacros()) {
            List<Message> messages = macro.getMessages();
            if (messages.isEmpty()) {
                macro.addMessage(new Message());
            }
            this.method_25321((class_350.class_351)new Entry.CommandKeyEntry(this.dynEntryX, this.dynEntryWidth, entryHeight, this, macro));
        }
        this.method_25321((class_350.class_351)new OptionList.Entry.ActionButtonEntry(this.dynEntryX, this.dynEntryWidth, entryHeight, (class_2561)class_2561.method_43470((String)"+"), null, -1, button -> {
            profile.addMacro(new Macro(profile));
            this.reload();
        }));
    }

    @Override
    public ProfileOptionList reload(int width, int height, double scrollAmount) {
        ProfileOptionList newListWidget = new ProfileOptionList(this.field_22740, width, height, this.method_46427(), this.field_22741, this.entryWidth, this.entryHeight, this.profile);
        newListWidget.method_25307(scrollAmount);
        return newListWidget;
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_48579(graphics, mouseX, mouseY, delta);
        if (this.dragSourceSlot != -1) {
            super.method_44397(graphics, mouseX, mouseY, delta, this.dragSourceSlot, mouseX, mouseY, this.entryWidth, this.entryHeight);
        }
    }

    public boolean method_25406(double x, double y, int button) {
        if (this.dragSourceSlot != -1 && button == 0) {
            this.dropDragged(x, y);
            return true;
        }
        return super.method_25406(x, y, button);
    }

    private void dropDragged(double mouseX, double mouseY) {
        OptionList.Entry hoveredEntry = (OptionList.Entry)this.method_25308(mouseX, mouseY);
        int hoveredSlot = this.method_25396().indexOf((Object)hoveredEntry);
        int offset = this.macroListOffset();
        if (!(!(hoveredEntry instanceof Entry.CommandKeyEntry) && hoveredSlot != offset - 1 || hoveredSlot <= this.dragSourceSlot && hoveredSlot >= this.dragSourceSlot - 1)) {
            int sourceIndex = this.dragSourceSlot - offset;
            int destIndex = hoveredSlot - offset;
            if (sourceIndex > destIndex) {
                ++destIndex;
            }
            this.profile.moveMacro(sourceIndex, destIndex);
            this.reload();
        }
        this.dragSourceSlot = -1;
    }

    private int macroListOffset() {
        int i = 0;
        for (OptionList.Entry entry : this.method_25396()) {
            if (entry instanceof Entry.CommandKeyEntry) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("CommandKey list not found");
    }

    public void openMainOptionsScreen() {
        class_437 lastScreen = this.screen.getLastScreen();
        if (lastScreen instanceof OptionsScreen) {
            OptionsScreen lastOptionsScreen = (OptionsScreen)lastScreen;
            lastScreen = lastOptionsScreen.getLastScreen();
        }
        this.field_22740.method_1507((class_437)new OptionsScreen(lastScreen, (class_2561)Localization.localized("option", "main", new Object[0]), new MainOptionList(this.field_22740, this.screen.field_22789, this.screen.field_22790, this.method_46427(), this.field_22741, this.entryWidth, this.entryHeight, null)));
    }

    public void openCommandKeyOptionsScreen(Macro macro) {
        this.field_22740.method_1507((class_437)new OptionsScreen(this.field_22740.field_1755, (class_2561)Localization.localized("option", "key", new Object[0]), new MacroOptionList(this.field_22740, this.screen.field_22789, this.screen.field_22790, this.method_46427(), this.field_22741, this.entryWidth, this.entryHeight, macro)));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class CommandKeyEntry
        extends Entry {
            CommandKeyEntry(int x, int width, int height, ProfileOptionList list, Macro macro) {
                List<Message> messages = macro.getMessages();
                boolean editableField = messages.size() == 1;
                int keyButtonWidth = Math.max(110, Math.min(150, width / 5));
                int messageFieldWidth = width - keyButtonWidth - (3 * list.smallButtonWidth + 16);
                int modeButtonWidth = 0;
                if (messageFieldWidth > 300) {
                    modeButtonWidth = 40;
                    messageFieldWidth -= (modeButtonWidth + 4) * 2;
                }
                int movingX = x;
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191\u2193"), button -> {
                    this.method_25398(true);
                    list.dragSourceSlot = list.method_25396().indexOf((Object)this);
                }).method_46433(movingX, 0).method_46437(list.smallButtonWidth, height).method_46431());
                class_5250[] keybindInfo = KeybindUtil.getKeybindInfo(macro);
                this.elements.add(class_4185.method_46430((class_2561)keybindInfo[1], button -> {
                    list.selectedMacro = macro;
                    button.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)keybindInfo[0].method_27692(class_124.field_1068).method_27692(class_124.field_1073)).method_27693(" <").method_27692(class_124.field_1054));
                }).method_46436(class_7919.method_47407((class_2561)keybindInfo[2])).method_46433(movingX += list.smallButtonWidth + 4, 0).method_46437(keyButtonWidth, height).method_46431());
                class_342 messageField = new class_342(class_310.method_1551().field_1772, movingX += keyButtonWidth + 4, 0, messageFieldWidth, height, (class_2561)class_2561.method_43473());
                messageField.method_1880(256);
                messageField.method_1852(editableField ? messages.getFirst().string : this.getEditButtonLabel(macro, messageFieldWidth - 10));
                messageField.method_1863(editableField ? val -> macro.setMessage(0, val.stripLeading()) : val -> list.openCommandKeyOptionsScreen(macro));
                this.elements.add(messageField);
                class_344 editButton = new class_344(movingX += messageFieldWidth + 4, 0, list.smallButtonWidth, height, GEAR_SPRITES, button -> {
                    list.openCommandKeyOptionsScreen(macro);
                    list.reload();
                });
                editButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "profile.key.edit", new Object[0])));
                editButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(editButton);
                movingX += list.smallButtonWidth + 4;
                if (modeButtonWidth != 0) {
                    class_5676 conflictButton = class_5676.method_32606(KeybindUtil::localizeConflictStrategy).method_32616().method_32624((Object[])Macro.ConflictStrategy.values()).method_32619((Object)macro.getConflictStrategy()).method_32618(status -> class_7919.method_47407((class_2561)KeybindUtil.localizeConflictStrategyTooltip(status))).method_32617(movingX, 0, modeButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                        macro.setConflictStrategy((Macro.ConflictStrategy)((Object)status));
                        list.reload();
                    });
                    this.elements.add(conflictButton);
                    class_5676 modeButton = class_5676.method_32606(KeybindUtil::localizeSendMode).method_32616().method_32624((Object[])Macro.SendMode.values()).method_32619((Object)macro.getSendMode()).method_32618(status -> class_7919.method_47407((class_2561)KeybindUtil.localizeSendModeTooltip(status))).method_32617(movingX += modeButtonWidth + 4, 0, modeButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                        macro.setSendMode((Macro.SendMode)((Object)status));
                        list.reload();
                    });
                    this.elements.add(modeButton);
                }
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061), button -> {
                    list.profile.removeMacro(macro);
                    list.reload();
                }).method_46433(x + width - list.smallButtonWidth, 0).method_46437(list.smallButtonWidth, height).method_46431());
            }

            private String getEditButtonLabel(Macro macro, int maxWidth) {
                class_327 font = class_310.method_1551().field_1772;
                ArrayList<String> strings = new ArrayList<String>();
                for (Message msg : macro.getMessages()) {
                    strings.add(msg.string);
                }
                int excess = strings.size() - 1;
                String tag = String.format(" [+%d]", excess);
                String trimTag = String.format("... [+%d]", excess);
                String first = (String)strings.getFirst();
                if (first.isBlank()) {
                    return trimTag;
                }
                String label = first + tag;
                int i = first.length();
                while (font.method_1727(label) > maxWidth) {
                    label = first.substring(0, i--) + trimTag;
                }
                return label;
            }
        }

        private static class HudAndHistoryEntry
        extends Entry {
            HudAndHistoryEntry(int x, int width, int height, ProfileOptionList list) {
                int buttonWidth = (width - 4) / 2;
                class_5676 hudButton = class_5676.method_32606(this::getLabel).method_32624((Object[])Profile.Control.values()).method_32619((Object)list.profile.showHudMessage).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "profile.hud.tooltip", new Object[0]))).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.hud", new Object[0]), (button, status) -> {
                    list.profile.showHudMessage = status;
                });
                hudButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(hudButton);
                class_5676 historyButton = class_5676.method_32606(this::getLabel).method_32624((Object[])Profile.Control.values()).method_32619((Object)list.profile.addToHistory).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "profile.history.tooltip", new Object[0]))).method_32617(x + width - buttonWidth, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.history", new Object[0]), (button, status) -> {
                    list.profile.addToHistory = status;
                });
                historyButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(historyButton);
            }

            private class_2561 getLabel(Profile.Control control) {
                return switch (control) {
                    default -> throw new MatchException(null, null);
                    case Profile.Control.ON -> class_5244.field_24332.method_27661().method_27692(class_124.field_1060);
                    case Profile.Control.OFF -> class_5244.field_24333.method_27661().method_27692(class_124.field_1061);
                    case Profile.Control.DEFER -> Localization.localized("option", "profile.control.defer", new Object[0]).method_27692(class_124.field_1065);
                };
            }
        }

        private static class ScreenSwitchEntry
        extends Entry {
            ScreenSwitchEntry(int x, int width, int height, ProfileOptionList list) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(class_4185.method_46430((class_2561)Localization.localized("option", "profile.switch", new Object[0]), button -> list.openMainOptionsScreen()).method_46433(x, 0).method_46437(buttonWidth, height).method_46431());
                this.elements.add(class_4185.method_46430((class_2561)Localization.localized("option", "profile.controls", new Object[0]), button -> list.openMinecraftControlsScreen()).method_46433(x + width - buttonWidth, 0).method_46437(buttonWidth, height).method_46431());
            }
        }
    }
}

