/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.gui.screen.OptionsScreen;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionList
extends class_4265<Entry> {
    public static final int ROW_WIDTH_MARGIN = 20;
    protected OptionsScreen screen;
    protected final int rowWidth;
    protected final int entryWidth;
    protected final int dynEntryWidth;
    protected final int entryHeight;
    protected final int entryX;
    protected final int dynEntryX;
    protected final int smallButtonWidth;

    public OptionList(class_310 mc, int width, int height, int y, int itemHeight, int entryWidth, int entryHeight) {
        super(mc, width, height, y, itemHeight);
        this.entryWidth = entryWidth;
        this.dynEntryWidth = Math.max(entryWidth, (int)((float)width / 5.0f * 4.0f));
        this.entryHeight = entryHeight;
        this.entryX = width / 2 - entryWidth / 2;
        this.dynEntryX = width / 2 - this.dynEntryWidth / 2;
        this.rowWidth = Math.max(entryWidth, this.dynEntryWidth) + 20;
        this.smallButtonWidth = Math.max(16, entryHeight);
    }

    public int method_25322() {
        return this.rowWidth;
    }

    protected int method_25329() {
        return this.field_22758 / 2 + this.rowWidth / 2;
    }

    public OptionList reload() {
        return this.screen.reload();
    }

    public OptionList reload(OptionsScreen screen, int width, int height, double scrollAmount) {
        OptionList newList = this.reload(width, height, scrollAmount);
        newList.screen = screen;
        return newList;
    }

    protected abstract OptionList reload(int var1, int var2, double var3);

    public abstract boolean keyPressed(class_3675.class_306 var1);

    public abstract boolean keyReleased(class_3675.class_306 var1);

    public abstract boolean mouseClicked(class_3675.class_306 var1);

    public abstract boolean mouseReleased(class_3675.class_306 var1);

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        public static final int SPACING = 4;
        public static final class_8666 COPY_SPRITES = new class_8666(class_2960.method_60655((String)"commandkeys", (String)"widget/copy_button"), class_2960.method_60655((String)"commandkeys", (String)"widget/copy_button_disabled"), class_2960.method_60655((String)"commandkeys", (String)"widget/copy_button_highlighted"));
        public static final class_8666 GEAR_SPRITES = new class_8666(class_2960.method_60655((String)"commandkeys", (String)"widget/gear_button"), class_2960.method_60655((String)"commandkeys", (String)"widget/gear_button_disabled"), class_2960.method_60655((String)"commandkeys", (String)"widget/gear_button_highlighted"));
        public static final class_8666 LINK_SPRITES = new class_8666(class_2960.method_60655((String)"commandkeys", (String)"widget/link_button"), class_2960.method_60655((String)"commandkeys", (String)"widget/link_button_disabled"), class_2960.method_60655((String)"commandkeys", (String)"widget/link_button_highlighted"));
        public final List<class_339> elements = new ArrayList<class_339>();

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.elements;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.elements;
        }

        public void method_25343(@NotNull class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.elements.forEach(button -> {
                button.method_46419(y);
                button.method_25394(context, mouseX, mouseY, tickDelta);
            });
        }

        public static class SpaceEntry
        extends Entry {
            private final Entry entry;

            public SpaceEntry(Entry entry) {
                this.entry = entry;
            }

            public boolean method_25397() {
                return this.entry.method_25397();
            }

            public void method_25398(boolean dragging) {
                this.entry.method_25398(dragging);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                return this.entry.method_25402(mouseX, mouseY, button);
            }

            public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
                return this.entry.method_25403(mouseX, mouseY, button, deltaY, deltaX);
            }

            public void method_25395(class_364 listener) {
                this.entry.method_25395(listener);
            }

            public class_364 method_25399() {
                return this.entry.method_25399();
            }

            public class_8016 method_48208(@NotNull class_8023 event, int i) {
                if (this.entry.method_25396().isEmpty()) {
                    return null;
                }
                class_8016 $$2 = this.entry.method_25396().get(Math.min(i, this.entry.method_25396().size() - 1)).method_48205(event);
                return class_8016.method_48192((class_4069)this.entry, (class_8016)$$2);
            }
        }

        public static class ActionButtonEntry
        extends Entry {
            public ActionButtonEntry(int x, int width, int height, class_2561 message, @Nullable class_7919 tooltip, int tooltipDelay, class_4185.class_4241 onPress) {
                class_4185 button = class_4185.method_46430((class_2561)message, (class_4185.class_4241)onPress).method_46433(x, 0).method_46437(width, height).method_46431();
                if (tooltip != null) {
                    button.method_47400(tooltip);
                }
                if (tooltipDelay >= 0) {
                    button.method_47402(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(button);
            }
        }

        public static class TextEntry
        extends Entry {
            public TextEntry(int x, int width, int height, class_2561 message, @Nullable class_7919 tooltip, int tooltipDelay) {
                Object widget = class_310.method_1551().field_1772.method_1727(message.getString()) <= width ? new class_7842(x, 0, width, height, message, class_310.method_1551().field_1772) : new class_7940(x, 0, message, class_310.method_1551().field_1772).method_48984(width).method_48981(true);
                if (tooltip != null) {
                    widget.method_47400(tooltip);
                }
                if (tooltipDelay >= 0) {
                    widget.method_47402(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(widget);
            }
        }
    }
}

