/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.OptionsScreen;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.gui.widget.list.ProfileOptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.time.Duration;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class MainOptionList
extends OptionList {
    @Nullable
    private Profile editingProfile;

    public MainOptionList(class_310 mc, int width, int height, int y, int itemHeight, int entryWidth, int entryHeight, @Nullable Profile editingProfile) {
        super(mc, width, height, y, itemHeight, entryWidth, entryHeight);
        this.editingProfile = editingProfile;
        boolean inGame = CommandKeys.inGame();
        this.method_25321((class_350.class_351)new OptionList.Entry.TextEntry(this.entryX, entryWidth, entryHeight, (class_2561)Localization.localized("option", "main.default", "\u2139"), class_7919.method_47407((class_2561)Localization.localized("option", "main.default.tooltip", new Object[0])), 500));
        this.method_25321((class_350.class_351)new Entry.DefaultOptionsEntry(this.entryX, entryWidth, entryHeight));
        this.method_25321((class_350.class_351)new OptionList.Entry.TextEntry(this.entryX, entryWidth, entryHeight, (class_2561)(inGame ? Localization.localized("option", "main.active_profile", new Object[0]) : Localization.localized("option", "main.profiles", "\u2139")), inGame ? null : class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.tooltip", new Object[0])), 500));
        Config config = Config.get();
        int i = 0;
        for (Profile profile : config.getProfiles()) {
            this.method_25321((class_350.class_351)new Entry.ProfileEntry(this.entryX, entryWidth, entryHeight, this, profile, i, i == config.spDefault, i == config.mpDefault, inGame));
            if (profile.equals(editingProfile)) {
                this.method_25321((class_350.class_351)new Entry.ProfileNameEntry(this.entryX, entryWidth, entryHeight, profile));
                for (String address : profile.getLinks()) {
                    this.method_25321((class_350.class_351)new Entry.ServerAddressEntry(this.entryX, entryWidth, entryHeight, this, profile, address));
                }
            }
            if (i == 0 && inGame) {
                this.method_25321((class_350.class_351)new OptionList.Entry.TextEntry(this.entryX, entryWidth, entryHeight, (class_2561)Localization.localized("option", "main.other_profiles", "\u2139"), class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.tooltip", new Object[0])), 500));
            }
            ++i;
        }
        this.method_25321((class_350.class_351)new OptionList.Entry.ActionButtonEntry(this.entryX, entryWidth, entryHeight, (class_2561)class_2561.method_43470((String)"+"), null, -1, button -> {
            Config.get().addProfile(new Profile());
            this.reload();
        }));
    }

    @Override
    public MainOptionList reload(int width, int height, double scrollAmount) {
        MainOptionList newListWidget = new MainOptionList(this.field_22740, width, height, this.method_46427(), this.field_22741, this.entryWidth, this.entryHeight, this.editingProfile);
        newListWidget.method_25307(scrollAmount);
        return newListWidget;
    }

    @Override
    public boolean keyPressed(class_3675.class_306 key) {
        return false;
    }

    @Override
    public boolean keyReleased(class_3675.class_306 key) {
        return false;
    }

    @Override
    public boolean mouseClicked(class_3675.class_306 key) {
        return false;
    }

    @Override
    public boolean mouseReleased(class_3675.class_306 key) {
        return false;
    }

    public void openProfileOptionsScreen(Profile profile) {
        this.field_22740.method_1507((class_437)new OptionsScreen((class_437)this.screen, (class_2561)Localization.localized("option", "profile", profile.getDisplayName()), new ProfileOptionList(this.field_22740, this.screen.field_22789, this.screen.field_22790, this.method_46427(), this.field_22741, this.entryWidth, this.entryHeight, profile)));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class ServerAddressEntry
        extends Entry {
            ServerAddressEntry(int x, int width, int height, MainOptionList list, Profile profile, String address) {
                int labelWidth = 50;
                int addressBoxWidth = width - labelWidth - list.smallButtonWidth - 4;
                class_4185 label = class_4185.method_46430((class_2561)Localization.localized("option", "main.link", new Object[0]), button -> {}).method_46433(x, 0).method_46437(labelWidth, height).method_46431();
                label.field_22763 = false;
                this.elements.add(label);
                class_342 addressBox = new class_342(class_310.method_1551().field_1772, x + labelWidth, 0, addressBoxWidth, height, (class_2561)class_2561.method_43473());
                addressBox.method_1880(64);
                addressBox.method_1852(address);
                addressBox.field_22763 = false;
                this.elements.add(addressBox);
                class_4185 removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c"), button -> {
                    profile.removeLink(address);
                    list.reload();
                }).method_46433(x + width - list.smallButtonWidth, 0).method_46437(list.smallButtonWidth, height).method_46431();
                removeButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.remove_link.tooltip", new Object[0])));
                removeButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(removeButton);
            }
        }

        private static class ProfileNameEntry
        extends Entry {
            ProfileNameEntry(int x, int width, int height, Profile profile) {
                int labelWidth = 50;
                int nameBoxWidth = width - labelWidth - 4;
                class_4185 label = class_4185.method_46430((class_2561)Localization.localized("option", "main.name", new Object[0]), button -> {}).method_46433(x, 0).method_46437(labelWidth, height).method_46431();
                label.field_22763 = false;
                this.elements.add(label);
                class_342 nameBox = new class_342(class_310.method_1551().field_1772, x + labelWidth, 0, nameBoxWidth, height, (class_2561)class_2561.method_43473());
                nameBox.method_1880(64);
                nameBox.method_1852(profile.name);
                nameBox.method_1863(value -> {
                    profile.name = value.strip();
                });
                this.elements.add(nameBox);
            }
        }

        private static class ProfileEntry
        extends Entry {
            MainOptionList list;
            Profile profile;

            ProfileEntry(int x, int width, int height, MainOptionList list, Profile profile, int index, boolean spDefault, boolean mpDefault, boolean inGame) {
                this.list = list;
                this.profile = profile;
                int smallButtonWidth = list.smallButtonWidth;
                int mainButtonWidth = width - smallButtonWidth * 5 - 20;
                int mainButtonX = x;
                if (inGame) {
                    if (index == 0) {
                        class_344 linkButton = new class_344(x, 0, smallButtonWidth, height, LINK_SPRITES, button -> {
                            profile.forceAddLink(CommandKeys.lastConnection);
                            list.reload();
                        });
                        if (profile.getLinks().contains(CommandKeys.lastConnection)) {
                            linkButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.linked.tooltip", new Object[0])));
                            linkButton.field_22763 = false;
                        } else {
                            linkButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.link.tooltip", new Object[0])));
                        }
                        linkButton.method_47402(Duration.ofMillis(500L));
                        this.elements.add(linkButton);
                    } else {
                        class_4185 activateButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> {
                            Config.get().activateProfile(index);
                            list.reload();
                        }).method_46433(x, 0).method_46437(smallButtonWidth, smallButtonWidth).method_46431();
                        activateButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.activate.tooltip", new Object[0])));
                        activateButton.method_47402(Duration.ofMillis(500L));
                        this.elements.add(activateButton);
                    }
                    mainButtonWidth -= smallButtonWidth + 4;
                    mainButtonX += smallButtonWidth + 4;
                }
                class_5250 name = class_2561.method_43470((String)profile.getDisplayName());
                int numLinks = profile.getLinks().size();
                if (numLinks != 0) {
                    name.method_27693(" ");
                    if (numLinks == 1) {
                        name.method_10852((class_2561)Localization.localized("option", "main.links.one", new Object[0]).method_27692(class_124.field_1080));
                    } else {
                        name.method_10852((class_2561)Localization.localized("option", "main.links.many", numLinks).method_27692(class_124.field_1080));
                    }
                }
                this.elements.add(class_4185.method_46430((class_2561)name, button -> list.openProfileOptionsScreen(profile)).method_46436(class_7919.method_47407((class_2561)Localization.localized("option", "main.edit_profile.tooltip", new Object[0]))).method_46433(mainButtonX, 0).method_46437(mainButtonWidth, height).method_46431());
                int movingX = x + width - smallButtonWidth * 5 - 16;
                class_344 configureButton = new class_344(movingX, 0, smallButtonWidth, height, GEAR_SPRITES, button -> {
                    list.editingProfile = list.editingProfile == null ? profile : (!list.editingProfile.equals(profile) ? profile : null);
                    list.reload();
                }, (class_2561)class_2561.method_43473());
                configureButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.edit_details.tooltip", new Object[0])));
                configureButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(configureButton);
                class_4185 setAsSpDefaultButton = class_4185.method_46430((class_2561)Localization.localized("option", "main.default_singleplayer.set", new Object[0]), button -> {
                    Config.get().spDefault = index;
                    list.reload();
                }).method_46433(movingX += smallButtonWidth + 4, 0).method_46437(smallButtonWidth, height).method_46431();
                if (spDefault) {
                    setAsSpDefaultButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.default_singleplayer.tooltip", new Object[0])));
                    setAsSpDefaultButton.method_25355((class_2561)setAsSpDefaultButton.method_25369().method_27661().method_27692(class_124.field_1060));
                } else {
                    setAsSpDefaultButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.default_singleplayer.set.tooltip", new Object[0])));
                }
                setAsSpDefaultButton.method_47402(Duration.ofMillis(500L));
                setAsSpDefaultButton.field_22763 = !spDefault;
                this.elements.add(setAsSpDefaultButton);
                class_4185 setAsMpDefaultButton = class_4185.method_46430((class_2561)Localization.localized("option", "main.default_multiplayer.set", new Object[0]), button -> {
                    Config.get().mpDefault = index;
                    list.reload();
                }).method_46433(movingX += smallButtonWidth + 4, 0).method_46437(smallButtonWidth, height).method_46431();
                if (mpDefault) {
                    setAsMpDefaultButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.default_multiplayer.tooltip", new Object[0])));
                    setAsMpDefaultButton.method_25355((class_2561)setAsMpDefaultButton.method_25369().method_27661().method_27692(class_124.field_1060));
                } else {
                    setAsMpDefaultButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.default_multiplayer.set.tooltip", new Object[0])));
                }
                setAsMpDefaultButton.method_47402(Duration.ofMillis(500L));
                setAsMpDefaultButton.field_22763 = !mpDefault;
                this.elements.add(setAsMpDefaultButton);
                class_344 copyButton = new class_344(movingX += smallButtonWidth + 4, 0, smallButtonWidth, height, COPY_SPRITES, button -> {
                    Config.get().copyProfile(profile);
                    list.reload();
                }, (class_2561)class_2561.method_43473());
                copyButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.copy.tooltip", new Object[0])));
                copyButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(copyButton);
                class_4185 deleteButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c"), button -> {
                    Config.get().removeProfile(index);
                    list.reload();
                }).method_46433(movingX += smallButtonWidth + 4, 0).method_46437(smallButtonWidth, height).method_46431();
                if (spDefault || mpDefault) {
                    deleteButton.field_22763 = false;
                    deleteButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.delete.disabled.tooltip", new Object[0])));
                } else {
                    deleteButton.method_25355((class_2561)deleteButton.method_25369().method_27661().method_27692(class_124.field_1061));
                    deleteButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.delete.tooltip", new Object[0])));
                }
                deleteButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(deleteButton);
            }
        }

        private static class DefaultOptionsEntry
        extends Entry {
            DefaultOptionsEntry(int x, int width, int height) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(class_5676.method_32606(KeybindUtil::localizeConflictStrategy).method_32624((Object[])Macro.ConflictStrategy.values()).method_32619((Object)Config.get().defaultConflictStrategy).method_32618(status -> class_7919.method_47407((class_2561)KeybindUtil.localizeConflictStrategyTooltip(status))).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "main.default.conflict_strategy", new Object[0]), (button, status) -> {
                    Config.get().defaultConflictStrategy = status;
                }));
                this.elements.add(class_5676.method_32606(KeybindUtil::localizeSendMode).method_32624((Object[])Macro.SendMode.values()).method_32619((Object)Config.get().defaultSendMode).method_32618(status -> class_7919.method_47407((class_2561)KeybindUtil.localizeSendModeTooltip(status))).method_32617(x + width - buttonWidth, 0, buttonWidth, height, (class_2561)Localization.localized("option", "main.default.send_mode", new Object[0]), (button, status) -> {
                    Config.get().defaultSendMode = status;
                }));
            }
        }
    }
}

