/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.widget.list.MacroBindList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.time.Duration;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7529;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class MacroOptionList
extends MacroBindList {
    private final Macro macro;
    private int dragSourceSlot = -1;

    public MacroOptionList(class_310 mc, int width, int height, int y, int itemHeight, int entryWidth, int entryHeight, Macro macro) {
        super(mc, width, height, y, itemHeight, entryWidth, entryHeight);
        this.profile = macro.profile;
        this.macro = macro;
        this.method_25321((class_350.class_351)new Entry.BindAndControlsEntry(this.entryX, entryWidth, entryHeight, this, macro));
        if (this.profile.showHudMessage.equals((Object)Profile.Control.DEFER) || this.profile.addToHistory.equals((Object)Profile.Control.DEFER)) {
            this.method_25321((class_350.class_351)new Entry.HudAndHistoryEntry(this.entryX, entryWidth, entryHeight, this.profile, macro));
        }
        this.method_25321((class_350.class_351)new Entry.StrategyAndModeEntry(this.entryX, entryWidth, entryHeight, this, macro));
        this.method_25321((class_350.class_351)new OptionList.Entry.TextEntry(this.entryX, entryWidth, entryHeight, (class_2561)Localization.localized("option", "key.messages", new Object[0]), null, -1));
        int i = 0;
        for (Message msg : macro.getMessages()) {
            Entry.MessageEntry msgEntry = new Entry.MessageEntry(this.dynEntryX, this.dynEntryWidth, entryHeight, this, macro, msg, i++);
            this.method_25321((class_350.class_351)msgEntry);
            this.method_25321((class_350.class_351)new OptionList.Entry.SpaceEntry(msgEntry));
        }
        this.method_25321((class_350.class_351)new OptionList.Entry.ActionButtonEntry(this.entryX, entryWidth, entryHeight, (class_2561)class_2561.method_43470((String)"+"), null, -1, button -> {
            macro.addMessage(new Message());
            this.reload();
        }));
    }

    @Override
    protected OptionList reload(int width, int height, double scrollAmount) {
        MacroOptionList newListWidget = new MacroOptionList(this.field_22740, width, height, this.method_46427(), this.field_22741, this.entryWidth, this.entryHeight, this.macro);
        newListWidget.method_25307(scrollAmount);
        return newListWidget;
    }

    void focusDelayField() {
        for (OptionList.Entry e : this.method_25396()) {
            if (!(e instanceof Entry.StrategyAndModeEntry)) continue;
            Entry.StrategyAndModeEntry entry = (Entry.StrategyAndModeEntry)e;
            entry.focusDelayField();
            entry.method_25365(true);
            this.method_25395((class_364)entry);
            this.screen.method_25395((class_364)this);
            return;
        }
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_48579(graphics, mouseX, mouseY, delta);
        if (this.dragSourceSlot != -1) {
            super.method_44397(graphics, mouseX, mouseY, delta, this.dragSourceSlot, mouseX, mouseY, this.entryWidth, this.entryHeight);
        }
    }

    public boolean method_25406(double x, double y, int button) {
        if (this.dragSourceSlot != -1 && button == 0) {
            this.dropDragged(x, y);
            return true;
        }
        return super.method_25406(x, y, button);
    }

    private void dropDragged(double mouseX, double mouseY) {
        OptionList.Entry hoveredEntry = (OptionList.Entry)this.method_25308(mouseX, mouseY);
        int hoveredSlot = this.method_25396().indexOf((Object)hoveredEntry);
        if (!(hoveredEntry instanceof Entry.MessageEntry) && hoveredSlot != this.messageListOffset() - 1) {
            if (hoveredEntry instanceof OptionList.Entry.SpaceEntry) {
                --hoveredSlot;
            } else {
                this.dragSourceSlot = -1;
                return;
            }
        }
        if (hoveredSlot > this.dragSourceSlot || hoveredSlot < this.dragSourceSlot - 1) {
            int destIndex;
            int sourceIndex = this.dragSourceSlot - this.messageEntryOffset(this.dragSourceSlot);
            if (sourceIndex > (destIndex = hoveredSlot - this.messageEntryOffset(hoveredSlot))) {
                ++destIndex;
            }
            this.macro.moveMessage(sourceIndex, destIndex);
            this.reload();
        }
        this.dragSourceSlot = -1;
    }

    private int messageListOffset() {
        int i = 0;
        for (OptionList.Entry entry : this.method_25396()) {
            if (entry instanceof Entry.MessageEntry) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("Response list not found");
    }

    private int messageEntryOffset(int index) {
        int i = 0;
        int offset = 0;
        for (OptionList.Entry entry : this.method_25396()) {
            if (!(entry instanceof Entry.MessageEntry)) {
                ++offset;
            }
            if (i++ != index) continue;
            return offset;
        }
        throw new IllegalStateException("Response index out of range");
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class MessageEntry
        extends Entry {
            MessageEntry(int x, int width, int height, MacroOptionList list, Macro macro, Message msg, int index) {
                class_327 font = class_310.method_1551().field_1772;
                boolean showDelayField = macro.getConflictStrategy() == Macro.ConflictStrategy.AVOID || macro.getSendMode() == Macro.SendMode.SEND && macro.spaceTicks == 0 || macro.getSendMode() == Macro.SendMode.REPEAT;
                int minDelayFieldWidth = font.method_1727("0__") + 8;
                int msgFieldWidth = width - list.smallButtonWidth * 2 - 8 - (showDelayField ? minDelayFieldWidth + 4 : 0);
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191\u2193"), button -> {
                    this.method_25398(true);
                    list.dragSourceSlot = list.method_25396().indexOf((Object)this);
                }).method_46433(x, 0).method_46437(list.smallButtonWidth, height).method_46431());
                class_7529 messageField = new class_7529(font, x + list.smallButtonWidth + 4, 0, msgFieldWidth, height * 2, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473());
                messageField.method_44402(256);
                messageField.method_44400(msg.string);
                messageField.method_44401(val -> {
                    msg.string = val.stripLeading();
                });
                this.elements.add(messageField);
                if (showDelayField) {
                    class_342 delayField = new class_342(font, x + list.smallButtonWidth + msgFieldWidth + 8, 0, minDelayFieldWidth, height, (class_2561)class_2561.method_43473());
                    delayField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "key.delay.individual.tooltip", new Object[0])));
                    delayField.method_47402(Duration.ofMillis(500L));
                    delayField.method_1880(8);
                    delayField.method_1863(val -> {
                        int newWidth = Math.max(minDelayFieldWidth, font.method_1727(val) + font.method_1727("__") + 8);
                        int deltaWidth = delayField.method_25368() - newWidth;
                        messageField.method_25358(messageField.method_25368() + deltaWidth);
                        delayField.method_46421(delayField.method_46426() + deltaWidth);
                        delayField.method_25358(delayField.method_25368() - deltaWidth);
                        try {
                            int delay = Integer.parseInt(val.strip());
                            if (delay < 0) {
                                throw new NumberFormatException();
                            }
                            msg.delayTicks = delay;
                            delayField.method_1868(0xFFFFFF);
                        }
                        catch (NumberFormatException ignored) {
                            delayField.method_1868(0xFF0000);
                        }
                    });
                    delayField.method_1852(String.valueOf(msg.delayTicks));
                    delayField.method_1875(0);
                    delayField.method_1884(0);
                    this.elements.add(delayField);
                }
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061), button -> {
                    macro.removeMessage(index);
                    list.reload();
                }).method_46433(x + width - list.smallButtonWidth, 0).method_46437(list.smallButtonWidth, height).method_46431());
            }
        }

        private static class StrategyAndModeEntry
        extends Entry {
            private class_342 delayField;

            StrategyAndModeEntry(int x, int width, int height, MacroOptionList list, Macro macro) {
                class_327 font = class_310.method_1551().field_1772;
                int buttonWidth = (width - 4) / 2;
                int minDelayFieldWidth = font.method_1727("0_") + 8;
                int stopButtonWidth = font.method_1727("Stop") + 8;
                int modeButtonWidth = switch (macro.getSendMode()) {
                    default -> throw new MatchException(null, null);
                    case Macro.SendMode.SEND -> buttonWidth - minDelayFieldWidth;
                    case Macro.SendMode.TYPE -> buttonWidth;
                    case Macro.SendMode.CYCLE -> buttonWidth - list.smallButtonWidth;
                    case Macro.SendMode.REPEAT -> buttonWidth - (macro.hasRepeating() ? stopButtonWidth : minDelayFieldWidth);
                };
                class_5676 conflictButton = class_5676.method_32606(KeybindUtil::localizeConflictStrategy).method_32624((Object[])Macro.ConflictStrategy.values()).method_32619((Object)macro.getConflictStrategy()).method_32618(status -> class_7919.method_47407((class_2561)KeybindUtil.localizeConflictStrategyTooltip(status))).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "key.conflict", new Object[0]), (button, status) -> {
                    macro.setConflictStrategy((Macro.ConflictStrategy)((Object)status));
                    list.reload();
                });
                this.elements.add(conflictButton);
                class_5676 modeButton = class_5676.method_32606(KeybindUtil::localizeSendMode).method_32624((Object[])Macro.SendMode.values()).method_32619((Object)macro.getSendMode()).method_32618(status -> class_7919.method_47407((class_2561)KeybindUtil.localizeSendModeTooltip(status))).method_32617(x + width - buttonWidth, 0, modeButtonWidth, height, (class_2561)Localization.localized("option", "key.mode", new Object[0]), (button, status) -> {
                    macro.setSendMode((Macro.SendMode)((Object)status));
                    list.reload();
                });
                this.elements.add(modeButton);
                if (macro.getSendMode().equals((Object)Macro.SendMode.SEND) || macro.getSendMode().equals((Object)Macro.SendMode.REPEAT) && !macro.hasRepeating()) {
                    this.delayField = new class_342(font, x + width - minDelayFieldWidth, 0, minDelayFieldWidth, height, (class_2561)class_2561.method_43473());
                    this.delayField.method_1880(8);
                    this.delayField.method_1863(val -> {
                        int newWidth = Math.max(minDelayFieldWidth, font.method_1727(val) + font.method_1727("_") + 8);
                        int deltaWidth = this.delayField.method_25368() - newWidth;
                        modeButton.method_25358(modeButton.method_25368() + deltaWidth);
                        this.delayField.method_46421(this.delayField.method_46426() + deltaWidth);
                        this.delayField.method_25358(this.delayField.method_25368() - deltaWidth);
                        try {
                            int space = Integer.parseInt(val.strip());
                            if (space < 0) {
                                throw new NumberFormatException();
                            }
                            int oldSpace = macro.spaceTicks;
                            macro.spaceTicks = space;
                            if (macro.getSendMode() == Macro.SendMode.SEND && (space == 0 && oldSpace != 0 || space != 0 && oldSpace == 0)) {
                                ((MacroOptionList)list.reload()).focusDelayField();
                            } else {
                                this.delayField.method_1868(0xFFFFFF);
                            }
                        }
                        catch (NumberFormatException ignored) {
                            this.delayField.method_1868(0xFF0000);
                        }
                    });
                    this.delayField.method_1852(String.valueOf(macro.spaceTicks));
                    this.delayField.method_1875(0);
                    this.delayField.method_1884(0);
                    this.delayField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "key.delay.tooltip" + (macro.getSendMode().equals((Object)Macro.SendMode.REPEAT) ? "repeat" : ""), new Object[0])));
                    this.elements.add(this.delayField);
                } else if (macro.getSendMode().equals((Object)Macro.SendMode.REPEAT)) {
                    this.elements.add(class_4185.method_46430((class_2561)Localization.localized("option", "key.repeat.stop", new Object[0]), button -> {
                        macro.stopRepeating();
                        list.reload();
                    }).method_46436(class_7919.method_47407((class_2561)Localization.localized("option", "key.repeat.stop.tooltip", new Object[0]))).method_46433(x + width - stopButtonWidth, 0).method_46437(stopButtonWidth, height).method_46431());
                } else if (macro.getSendMode().equals((Object)Macro.SendMode.CYCLE)) {
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (int i = 0; i < macro.getMessages().size(); ++i) {
                        values.add(i);
                    }
                    if (values.isEmpty()) {
                        values.add(0);
                    }
                    if (macro.cycleIndex > (Integer)values.getLast()) {
                        macro.cycleIndex = 0;
                    }
                    this.elements.add(class_5676.method_32606(status -> class_2561.method_43470((String)status.toString())).method_32620(values).method_32619((Object)macro.cycleIndex).method_32616().method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "key.cycle.index.tooltip", new Object[0]))).method_32617(x + width - list.smallButtonWidth, 0, list.smallButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                        macro.cycleIndex = status;
                    }));
                }
            }

            void focusDelayField() {
                this.delayField.method_25365(true);
                this.method_25395((class_364)this.delayField);
            }
        }

        private static class BindAndControlsEntry
        extends Entry {
            BindAndControlsEntry(int x, int width, int height, MacroOptionList list, Macro macro) {
                int buttonWidth = (width - 4) / 2;
                class_5250[] keybindInfo = KeybindUtil.getKeybindInfo(macro);
                this.elements.add(class_4185.method_46430((class_2561)keybindInfo[1], button -> {
                    list.selectedMacro = macro;
                    button.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)keybindInfo[0].method_27692(class_124.field_1068).method_27692(class_124.field_1073)).method_27693(" <").method_27692(class_124.field_1054));
                }).method_46436(class_7919.method_47407((class_2561)keybindInfo[2])).method_46433(x, 0).method_46437(buttonWidth, height).method_46431());
                this.elements.add(class_4185.method_46430((class_2561)Localization.localized("option", "profile.controls", new Object[0]), button -> list.openMinecraftControlsScreen()).method_46433(x + width - buttonWidth, 0).method_46437(buttonWidth, height).method_46431());
            }
        }

        private static class HudAndHistoryEntry
        extends Entry {
            HudAndHistoryEntry(int x, int width, int height, Profile profile, Macro macro) {
                int buttonWidth = (width - 4) / 2;
                class_5676 hudButton = class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32619((Object)macro.showHudMessage).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.hud.tooltip", new Object[0]))).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.hud", new Object[0]), (button, status) -> {
                    macro.showHudMessage = status;
                });
                hudButton.method_47402(Duration.ofMillis(500L));
                if (!profile.showHudMessage.equals((Object)Profile.Control.DEFER)) {
                    hudButton.field_22763 = false;
                }
                this.elements.add(hudButton);
                class_5676 historyButton = class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32619((Object)macro.addToHistory).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.history.tooltip", new Object[0]))).method_32617(x + width - buttonWidth, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.history", new Object[0]), (button, status) -> {
                    macro.addToHistory = status;
                });
                historyButton.method_47402(Duration.ofMillis(500L));
                if (!profile.addToHistory.equals((Object)Profile.Control.DEFER)) {
                    historyButton.field_22763 = false;
                }
                this.elements.add(historyButton);
            }
        }
    }
}

