/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.commandkeys.config.Macro;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3675;

public class Profile {
    public final int version = 2;
    public static final Map<String, Profile> LINK_PROFILE_MAP = new HashMap<String, Profile>();
    public final transient Multimap<class_3675.class_306, Macro> keyMacroMap = LinkedHashMultimap.create();
    public String name;
    private final List<String> addresses;
    public Control addToHistory;
    public Control showHudMessage;
    private final List<Macro> macros;

    public Profile() {
        this.name = "";
        this.addresses = new ArrayList<String>();
        this.addToHistory = Control.OFF;
        this.showHudMessage = Control.OFF;
        this.macros = new ArrayList<Macro>();
    }

    private Profile(String name, List<String> addresses, Control addToHistory, Control showHudMessage, List<Macro> macros) {
        this.name = name;
        this.addresses = addresses;
        this.addToHistory = addToHistory;
        this.showHudMessage = showHudMessage;
        this.macros = macros;
        Iterator<String> linkIter = this.addresses.iterator();
        while (linkIter.hasNext()) {
            String link = linkIter.next();
            if (LINK_PROFILE_MAP.containsKey(link)) {
                linkIter.remove();
                continue;
            }
            LINK_PROFILE_MAP.put(link, this);
        }
    }

    public Profile(Profile profile) {
        this.name = profile.name;
        this.addresses = new ArrayList<String>();
        this.addToHistory = profile.addToHistory;
        this.showHudMessage = profile.showHudMessage;
        this.macros = profile.macros;
    }

    public String getDisplayName() {
        String name = this.name;
        if (name.isBlank()) {
            name = this.getLinks().stream().findFirst().orElse("");
        }
        if (name.isBlank()) {
            name = "[Unnamed]";
        }
        return name;
    }

    public List<String> getLinks() {
        return Collections.unmodifiableList(this.addresses);
    }

    public void forceAddLink(String link) {
        if (LINK_PROFILE_MAP.containsKey(link)) {
            LINK_PROFILE_MAP.get(link).removeLink(link);
        }
        this.addresses.add(link);
        LINK_PROFILE_MAP.put(link, this);
    }

    public void removeLink(String link) {
        this.addresses.remove(link);
        LINK_PROFILE_MAP.remove(link);
    }

    public List<Macro> getMacros() {
        return Collections.unmodifiableList(this.macros);
    }

    public void addMacro(Macro macro) {
        this.macros.add(macro);
        this.keyMacroMap.put((Object)macro.getKey(), (Object)macro);
    }

    public void moveMacro(int sourceIndex, int destIndex) {
        if (sourceIndex != destIndex) {
            this.macros.add(destIndex, this.macros.remove(sourceIndex));
            this.rebuildMacroMap();
        }
    }

    public void removeMacro(Macro macro) {
        this.macros.remove(macro);
        this.keyMacroMap.remove((Object)macro.getKey(), (Object)macro);
    }

    public void rebuildMacroMap() {
        this.keyMacroMap.clear();
        for (Macro macro : this.macros) {
            this.keyMacroMap.put((Object)macro.getKey(), (Object)macro);
        }
    }

    public void cleanup() {
        Iterator<Macro> macroIter = this.macros.iterator();
        while (macroIter.hasNext()) {
            Macro macro = macroIter.next();
            if (!macro.getSendMode().equals((Object)Macro.SendMode.TYPE)) {
                macro.messages.forEach(msg -> {
                    msg.string = msg.string.stripTrailing();
                });
            }
            if (!macro.getSendMode().equals((Object)Macro.SendMode.CYCLE)) {
                macro.messages.removeIf(msg -> msg.string.isBlank());
            }
            if (!macro.messages.isEmpty()) continue;
            macroIter.remove();
            this.keyMacroMap.remove((Object)macro.getKey(), (Object)macro);
        }
    }

    public static enum Control {
        ON,
        OFF,
        DEFER;

    }

    public static class Deserializer
    implements JsonDeserializer<Profile> {
        public Profile deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.has("version") ? obj.get("version").getAsInt() : 0;
            String name = obj.get("name").getAsString();
            ArrayList<String> addresses = new ArrayList<String>();
            for (JsonElement je : obj.getAsJsonArray("addresses")) {
                addresses.add(je.getAsString());
            }
            Control addToHistory = version >= 2 ? Control.valueOf(obj.get("addToHistory").getAsString()) : Control.OFF;
            Control showHudMessage = version >= 2 ? Control.valueOf(obj.get("showHudMessage").getAsString()) : Control.OFF;
            ArrayList<Macro> macros = new ArrayList<Macro>();
            Profile profile = new Profile(name, addresses, addToHistory, showHudMessage, macros);
            Gson macroGson = new GsonBuilder().registerTypeAdapter(Macro.class, (Object)new Macro.Deserializer(profile)).create();
            for (JsonElement je : obj.getAsJsonArray(version >= 2 ? "macros" : "commandKeys")) {
                macros.add((Macro)macroGson.fromJson(je, Macro.class));
            }
            if (name == null) {
                throw new JsonParseException("Profile #1");
            }
            return profile;
        }
    }
}

