/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.commandkeys.CommandKeys;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;

public class Message {
    public final int version = 1;
    public boolean enabled;
    public String string;
    public int delayTicks;

    public Message() {
        this.enabled = true;
        this.string = "";
        this.delayTicks = 0;
    }

    Message(boolean enabled, String string, int delayTicks) {
        this.enabled = enabled;
        this.string = string;
        this.delayTicks = delayTicks;
    }

    public static class Deserializer
    implements JsonDeserializer<Message> {
        @Nullable
        public Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            try {
                boolean enabled = obj.get("enabled").getAsBoolean();
                String string = obj.get("string").getAsString();
                int delayTicks = obj.get("delayTicks").getAsInt();
                if (delayTicks < 0) {
                    throw new JsonParseException("ResponseMessage #1");
                }
                return new Message(enabled, string, delayTicks);
            }
            catch (Exception e) {
                CommandKeys.LOG.warn("Unable to deserialize ResponseMessage", e);
                return null;
            }
        }
    }
}

